/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Collections;
import java.util.Iterator;
import org.intellij.plugins.xpathView.support.jaxen.AttributeIterator;
import org.intellij.plugins.xpathView.support.jaxen.NodeIterator;
import org.intellij.plugins.xpathView.support.jaxen.PsiChildAxisIterator;
import org.intellij.plugins.xpathView.support.jaxen.PsiXPath;
import org.intellij.plugins.xpathView.util.MyPsiUtil;
import org.jaxen.DefaultNavigator;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jetbrains.annotations.NotNull;

public class PsiDocumentNavigator
extends DefaultNavigator {
    private static final Logger LOG = Logger.getInstance(PsiDocumentNavigator.class);
    private final XmlFile file;

    public PsiDocumentNavigator(XmlFile file) {
        this.file = file;
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XmlElement)) {
            return Collections.emptyIterator();
        }
        return new PsiChildAxisIterator(contextNode);
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XmlElement)) {
            return Collections.emptyIterator();
        }
        return new NodeIterator((PsiElement)((XmlElement)contextNode)){

            @Override
            protected PsiElement getFirstNode(PsiElement n) {
                while (n != null) {
                    if (!((n = n.getParent()) instanceof XmlTag)) continue;
                    return n;
                }
                return null;
            }

            @Override
            protected PsiElement getNextNode(PsiElement n) {
                return null;
            }
        };
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof XmlDocument) {
            return contextNode;
        }
        while (contextNode instanceof PsiElement) {
            if (contextNode instanceof XmlDocument) {
                return contextNode;
            }
            contextNode = ((PsiElement)contextNode).getParent();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object element) {
        if (this.isElement(element)) {
            return ((XmlTag)element).getNamespaceByPrefix(prefix);
        }
        return super.translateNamespacePrefixToUri(prefix, element);
    }

    public String getProcessingInstructionTarget(Object obj) {
        LOG.assertTrue(obj instanceof XmlProcessingInstruction);
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        return PsiDocumentNavigator.getProcessingInstructionTarget(pi);
    }

    public static String getProcessingInstructionTarget(XmlProcessingInstruction pi) {
        int i;
        PsiElement[] children = pi.getChildren();
        LOG.assertTrue(children[1] instanceof XmlToken && ((XmlToken)children[1]).getTokenType() == XmlTokenType.XML_NAME, (Object)"Unknown PI structure");
        String text = children[1].getText();
        for (i = 0; i < text.length() && text.charAt(i) == ' '; ++i) {
        }
        int pos = text.indexOf(32, i);
        text = pos != -1 ? text.substring(i, pos) : text.substring(i);
        return text;
    }

    @NotNull
    public String getProcessingInstructionData(Object obj) {
        LOG.assertTrue(obj instanceof XmlProcessingInstruction);
        XmlProcessingInstruction pi = (XmlProcessingInstruction)obj;
        int targetLength = this.getProcessingInstructionTarget(obj).length();
        int piLength = pi.getText().length();
        String string = pi.getText().substring(2 + targetLength, piLength - 2).trim();
        if (string == null) {
            PsiDocumentNavigator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Object getParentNode(Object contextNode) {
        return ((PsiElement)contextNode).getParent();
    }

    public Object getDocument(String url) {
        PsiFile file;
        VirtualFile virtualFile = VfsUtilCore.findRelativeFile((String)url, (VirtualFile)this.file.getVirtualFile());
        if (virtualFile != null && (file = this.file.getManager().findFile(virtualFile)) instanceof XmlFile) {
            return ((XmlFile)file).getDocument();
        }
        return null;
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (this.isElement(contextNode)) {
            return new AttributeIterator((XmlElement)contextNode);
        }
        return Collections.emptyIterator();
    }

    public String getElementNamespaceUri(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        XmlTag context = (XmlTag)element;
        String namespaceUri = context.getNamespace();
        if (!MyPsiUtil.isInDeclaredNamespace(context, namespaceUri, context.getNamespacePrefix())) {
            return "";
        }
        return namespaceUri;
    }

    public String getElementName(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        return ((XmlTag)element).getLocalName();
    }

    public String getElementQName(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        return ((XmlTag)element).getName();
    }

    public String getAttributeNamespaceUri(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        XmlAttribute attribute = (XmlAttribute)attr;
        String name = attribute.getName();
        if (name.indexOf(58) == -1) {
            return "";
        }
        String uri = attribute.getNamespace();
        if (!MyPsiUtil.isInDeclaredNamespace(attribute.getParent(), uri, MyPsiUtil.getAttributePrefix(attribute))) {
            LOG.info("getElementNamespaceUri: not returning implicit attribute-namespace uri: " + uri);
            return "";
        }
        return uri;
    }

    public String getAttributeName(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        return ((XmlAttribute)attr).getLocalName();
    }

    public String getAttributeQName(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        return ((XmlAttribute)attr).getName();
    }

    public boolean isDocument(Object object) {
        return object instanceof XmlDocument;
    }

    public boolean isElement(Object object) {
        return object instanceof XmlTag && PsiDocumentNavigator.isSupportedElement((XmlTag)object);
    }

    private static boolean isSupportedElement(XmlTag object) {
        return object.getLanguage() == XMLLanguage.INSTANCE || MyPsiUtil.findNameElement(object) != null;
    }

    public boolean isAttribute(Object object) {
        return object instanceof XmlAttribute;
    }

    public boolean isNamespace(Object object) {
        return false;
    }

    public boolean isComment(Object object) {
        return object instanceof XmlComment;
    }

    public boolean isText(Object object) {
        return object instanceof PsiWhiteSpace ? ((PsiWhiteSpace)object).getParent() instanceof XmlText : object instanceof XmlText;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof XmlProcessingInstruction;
    }

    @NotNull
    public String getCommentStringValue(Object comment) {
        PsiElement[] children;
        LOG.assertTrue(comment instanceof XmlComment);
        PsiElement c = (PsiElement)comment;
        for (PsiElement child : children = c.getChildren()) {
            if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_COMMENT_CHARACTERS) continue;
            String string = child.getText();
            if (string == null) {
                PsiDocumentNavigator.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public String getElementStringValue(Object element) {
        LOG.assertTrue(element instanceof XmlTag);
        TextCollector collector = new TextCollector();
        ((XmlTag)element).accept((PsiElementVisitor)collector);
        String string = collector.getText();
        if (string == null) {
            PsiDocumentNavigator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getAttributeStringValue(Object attr) {
        LOG.assertTrue(attr instanceof XmlAttribute);
        String string = StringUtil.notNullize((String)((XmlAttribute)attr).getValue());
        if (string == null) {
            PsiDocumentNavigator.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getNamespaceStringValue(Object ns) {
        return null;
    }

    public String getNamespacePrefix(Object ns) {
        return null;
    }

    @NotNull
    public String getTextStringValue(Object txt) {
        if (txt instanceof XmlText) {
            String string = ((XmlText)txt).getValue();
            if (string == null) {
                PsiDocumentNavigator.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = txt instanceof PsiElement ? ((PsiElement)txt).getText() : txt.toString();
        if (string == null) {
            PsiDocumentNavigator.$$$reportNull$$$0(5);
        }
        return string;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new PsiXPath(this.file, xpath);
    }

    public Object getElementById(Object object, final String elementId) {
        XmlTag rootTag = ((XmlFile)((XmlElement)object).getContainingFile()).getRootTag();
        if (rootTag == null) {
            return null;
        }
        final Ref ref = new Ref();
        rootTag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ref.get() == null) {
                    super.visitElement(element);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                String value = attribute.getValue();
                if (value != null && descriptor != null && descriptor.hasIdType() && elementId.equals(value)) {
                    ref.set((Object)attribute.getParent());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator$2", "visitElement"));
            }
        });
        return ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/xpathView/support/jaxen/PsiDocumentNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingInstructionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentStringValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementStringValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeStringValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStringValue";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class TextCollector
    extends XmlRecursiveElementVisitor {
        private final StringBuffer builder = new StringBuffer();

        TextCollector() {
        }

        public void visitXmlText(XmlText text) {
            this.builder.append(text.getValue());
        }

        public String getText() {
            return this.builder.toString();
        }
    }
}

