/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.ByteBufferWrapper;
import com.intellij.util.io.IOStatistics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;

abstract class MappedBufferWrapper
extends ByteBufferWrapper {
    private static final int MAX_FORCE_ATTEMPTS = 10;
    private volatile MappedByteBuffer myBuffer;

    protected MappedBufferWrapper(Path file, long pos, long length) {
        super(file, pos, length);
    }

    protected abstract MappedByteBuffer map() throws IOException;

    @Override
    public final void unmap() {
        long finished;
        long started;
        long l = started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
        if (this.myBuffer != null) {
            if (this.isDirty()) {
                this.flush();
            }
            if (!ByteBufferUtil.cleanBuffer(this.myBuffer)) {
                Logger.getInstance(MappedBufferWrapper.class).error("Unmapping failed for: " + this.myFile);
            }
            this.myBuffer = null;
        }
        if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
            IOStatistics.dump("Unmapped " + this.myFile + "," + this.myPosition + "," + this.myLength + " for " + (finished - started));
        }
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        MappedByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.map();
        }
        return buffer;
    }

    @Override
    public void flush() {
        MappedByteBuffer buffer = this.myBuffer;
        if (buffer != null && this.isDirty()) {
            for (int i = 0; i < 10; ++i) {
                try {
                    buffer.force();
                    this.myDirty = false;
                    break;
                }
                catch (Throwable e) {
                    Logger.getInstance(MappedBufferWrapper.class).info(e);
                    TimeoutUtil.sleep(10L);
                    continue;
                }
            }
        }
    }
}

