/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectLinkedOpenHashSet<K>
extends AbstractSet<K>
implements Set<K>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    private static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final TObjectHashingStrategy DEFAULT_HASHING_STRATEGY = TObjectHashingStrategy.CANONICAL;
    transient K[] key;
    protected final TObjectHashingStrategy<K> hashingStrategy;
    private transient int mask;
    transient boolean containsNull;
    private transient int first = -1;
    private transient int last = -1;
    private transient long[] link;
    transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    public ObjectLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectLinkedOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public ObjectLinkedOpenHashSet(TObjectHashingStrategy<K> strategy) {
        this(16, 0.75f, strategy);
    }

    public ObjectLinkedOpenHashSet(Collection<? extends K> c) {
        this(c.size(), 0.75f);
        this.addAll(c);
    }

    public ObjectLinkedOpenHashSet(int expected, TObjectHashingStrategy<K> strategy) {
        this(expected, 0.75f, strategy);
    }

    public ObjectLinkedOpenHashSet(Collection<? extends K> c, TObjectHashingStrategy<K> strategy) {
        this(c.size(), 0.75f, strategy);
        this.addAll(c);
    }

    public ObjectLinkedOpenHashSet(int expected, float f) {
        this(expected, f, DEFAULT_HASHING_STRATEGY);
    }

    public ObjectLinkedOpenHashSet(int expected, float f, TObjectHashingStrategy<K> strategy) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = ObjectLinkedOpenHashSet.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = ObjectLinkedOpenHashSet.maxFill(this.n, f);
        this.key = new Object[this.n + 1];
        this.link = new long[this.n + 1];
        this.hashingStrategy = strategy;
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = ObjectLinkedOpenHashSet.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, ObjectLinkedOpenHashSet.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c.size());
        } else {
            this.tryCapacity(this.size() + c.size());
        }
        return super.addAll(c);
    }

    @Override
    public boolean add(K k) {
        int pos;
        if (k == null) {
            if (this.containsNull) {
                return false;
            }
            pos = this.n;
            this.containsNull = true;
        } else {
            K[] key = this.key;
            pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(k)) & this.mask;
            K curr = key[pos];
            if (curr != null) {
                if (this.hashingStrategy.equals(curr, k)) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != null) {
                    if (!this.hashingStrategy.equals(curr, k)) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(ObjectLinkedOpenHashSet.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    public K addOrGet(K k) {
        int pos;
        if (k == null) {
            if (this.containsNull) {
                return this.key[this.n];
            }
            pos = this.n;
            this.containsNull = true;
        } else {
            K[] key = this.key;
            pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(k)) & this.mask;
            K curr = key[pos];
            if (curr != null) {
                if (this.hashingStrategy.equals(curr, k)) {
                    return curr;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != null) {
                    if (!this.hashingStrategy.equals(curr, k)) continue;
                    return curr;
                }
            }
            key[pos] = k;
        }
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(ObjectLinkedOpenHashSet.arraySize(this.size + 1, this.f));
        }
        return k;
    }

    private void shiftKeys(int pos) {
        K[] key = this.key;
        while (true) {
            K curr;
            int last = pos;
            pos = pos + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == null) {
                    key[last] = null;
                    return;
                }
                int slot = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.fixPointers(pos, last);
        }
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.fixPointers(pos);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = null;
        --this.size;
        this.fixPointers(this.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(Object k) {
        if (k == null) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        K[] keyArray = this.key;
        Object key = k;
        int pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(key)) & this.mask;
        K curr = keyArray[pos];
        if (curr == null) {
            return false;
        }
        if (this.hashingStrategy.equals(key, curr)) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = keyArray[pos = pos + 1 & this.mask]) != null) continue;
            return false;
        } while (!this.hashingStrategy.equals(key, curr));
        return this.removeEntry(pos);
    }

    @Override
    public boolean contains(Object k) {
        if (k == null) {
            return this.containsNull;
        }
        K[] keyArray = this.key;
        Object key = k;
        int pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(key)) & this.mask;
        K curr = keyArray[pos];
        if (curr == null) {
            return false;
        }
        if (this.hashingStrategy.equals(key, curr)) {
            return true;
        }
        do {
            if ((curr = keyArray[pos = pos + 1 & this.mask]) != null) continue;
            return false;
        } while (!this.hashingStrategy.equals(key, curr));
        return true;
    }

    public K get(Object k) {
        if (k == null) {
            return this.key[this.n];
        }
        K[] keyArray = this.key;
        Object key = k;
        int pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(key)) & this.mask;
        K curr = keyArray[pos];
        if (curr == null) {
            return null;
        }
        if (this.hashingStrategy.equals(key, curr)) {
            return curr;
        }
        do {
            if ((curr = keyArray[pos = pos + 1 & this.mask]) != null) continue;
            return null;
        } while (!this.hashingStrategy.equals(key, curr));
        return curr;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    private void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public Iterator<K> iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        K[] key = this.key;
        int mask = newN - 1;
        Object[] newKey = new Object[newN + 1];
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] link = this.link;
        long[] newLink = new long[newN + 1];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos;
            if (key[i] == null) {
                pos = newN;
            } else {
                pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(key[i])) & mask;
                while (newKey[pos] != null) {
                    pos = pos + 1 & mask;
                }
            }
            newKey[pos] = key[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLink[n2] = newLink[n2] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = ObjectLinkedOpenHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public ObjectLinkedOpenHashSet<K> clone() {
        ObjectLinkedOpenHashSet c;
        try {
            c = (ObjectLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (Object[])this.key.clone();
        c.containsNull = this.containsNull;
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        while (j-- != 0) {
            while (this.key[i] == null) {
                ++i;
            }
            if (this != this.key[i]) {
                h += this.hashingStrategy.computeHashCode(this.key[i]);
            }
            ++i;
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (s.size() != this.size()) {
            return false;
        }
        return this.containsAll(s);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<K> i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            K k = i.next();
            if (this == k) {
                s.append("(this collection)");
                continue;
            }
            s.append(k);
        }
        s.append("}");
        return s.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<K> i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = ObjectLinkedOpenHashSet.arraySize(this.size, this.f);
        this.maxFill = ObjectLinkedOpenHashSet.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] key = this.key;
        this.link = new long[this.n + 1];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        while (i-- != 0) {
            int pos;
            Object k = s.readObject();
            if (k == null) {
                pos = this.n;
                this.containsNull = true;
            } else {
                pos = ObjectLinkedOpenHashSet.mix(this.hashingStrategy.computeHashCode(k)) & this.mask;
                if (key[pos] != null) {
                    while (key[pos = pos + 1 & this.mask] != null) {
                    }
                }
            }
            key[pos] = k;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                link[n2] = link[n2] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n = pos;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    private static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, ObjectLinkedOpenHashSet.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private class SetIterator
    implements ListIterator<K> {
        int prev = -1;
        int next;
        int curr = -1;
        int index;

        SetIterator() {
            this.next = ObjectLinkedOpenHashSet.this.first;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != -1;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = (int)ObjectLinkedOpenHashSet.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return ObjectLinkedOpenHashSet.this.key[this.curr];
        }

        @Override
        public K previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = (int)(ObjectLinkedOpenHashSet.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return ObjectLinkedOpenHashSet.this.key[this.curr];
        }

        private void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = ObjectLinkedOpenHashSet.this.size;
                return;
            }
            int pos = ObjectLinkedOpenHashSet.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)ObjectLinkedOpenHashSet.this.link[pos];
                ++this.index;
            }
        }

        @Override
        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        @Override
        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(ObjectLinkedOpenHashSet.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)ObjectLinkedOpenHashSet.this.link[this.curr];
            }
            ObjectLinkedOpenHashSet.this.size--;
            if (this.prev == -1) {
                ObjectLinkedOpenHashSet.this.first = this.next;
            } else {
                long[] lArray = ObjectLinkedOpenHashSet.this.link;
                int n = this.prev;
                lArray[n] = lArray[n] ^ (ObjectLinkedOpenHashSet.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                ObjectLinkedOpenHashSet.this.last = this.prev;
            } else {
                long[] lArray = ObjectLinkedOpenHashSet.this.link;
                int n = this.next;
                lArray[n] = lArray[n] ^ (ObjectLinkedOpenHashSet.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            this.curr = -1;
            if (pos != ObjectLinkedOpenHashSet.this.n) {
                K[] key = ObjectLinkedOpenHashSet.this.key;
                while (true) {
                    Object curr;
                    int last = pos;
                    pos = pos + 1 & ObjectLinkedOpenHashSet.this.mask;
                    while (true) {
                        if ((curr = key[pos]) == null) {
                            key[last] = null;
                            return;
                        }
                        int slot = ObjectLinkedOpenHashSet.mix(ObjectLinkedOpenHashSet.this.hashingStrategy.computeHashCode(curr)) & ObjectLinkedOpenHashSet.this.mask;
                        if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                        pos = pos + 1 & ObjectLinkedOpenHashSet.this.mask;
                    }
                    key[last] = curr;
                    if (this.next == pos) {
                        this.next = last;
                    }
                    if (this.prev == pos) {
                        this.prev = last;
                    }
                    ObjectLinkedOpenHashSet.this.fixPointers(pos, last);
                }
            }
            ObjectLinkedOpenHashSet.this.containsNull = false;
            ObjectLinkedOpenHashSet.this.key[ObjectLinkedOpenHashSet.this.n] = null;
        }

        @Override
        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k) {
            throw new UnsupportedOperationException();
        }
    }
}

