/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;

public class MemoryDumpHelper {
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Object ourMXBean;
    private static final Method ourDumpHeap;

    public static boolean memoryDumpAvailable() {
        try {
            return ourMXBean != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static synchronized void captureMemoryDump(@NotNull String dumpPath) throws Exception {
        if (dumpPath == null) {
            MemoryDumpHelper.$$$reportNull$$$0(0);
        }
        ourDumpHeap.invoke(ourMXBean, dumpPath, true);
    }

    public static void captureMemoryDumpZipped(@NotNull String zipPath) throws Exception {
        if (zipPath == null) {
            MemoryDumpHelper.$$$reportNull$$$0(1);
        }
        MemoryDumpHelper.captureMemoryDumpZipped(new File(zipPath));
    }

    public static synchronized void captureMemoryDumpZipped(@NotNull File zipFile) throws Exception {
        if (zipFile == null) {
            MemoryDumpHelper.$$$reportNull$$$0(2);
        }
        File tempFile = FileUtil.createTempFile("heapDump.", ".hprof");
        FileUtil.delete(tempFile);
        MemoryDumpHelper.captureMemoryDump(tempFile.getPath());
        ZipUtil.compressFile(tempFile, zipFile);
        FileUtil.delete(tempFile);
    }

    static {
        Method dumpHeap;
        Object mxBean;
        try {
            final Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            mxBean = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(MemoryDumpHelper.HOT_SPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                    }
                    return null;
                }
            });
            dumpHeap = mxBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Throwable t) {
            Logger.getInstance(MemoryDumpHelper.class).info(t.getMessage());
            mxBean = null;
            dumpHeap = null;
        }
        ourMXBean = mxBean;
        ourDumpHeap = dumpHeap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/MemoryDumpHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "captureMemoryDump";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "captureMemoryDumpZipped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

