/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import gnu.trove.THashMap;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final THashMap<String, RegistryKeyDescriptor> myContributedKeys = new THashMap();
    private static final Registry ourInstance;
    private volatile boolean myLoaded = false;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        RegistryValue value;
        if (key == null) {
            Registry.$$$reportNull$$$0(1);
        }
        if ((value = (RegistryValue)this.myValues.get(key)) != null) {
            RegistryValue registryValue = value;
            if (registryValue == null) {
                Registry.$$$reportNull$$$0(2);
            }
            return registryValue;
        }
        value = new RegistryValue(this, key, (RegistryKeyDescriptor)this.myContributedKeys.get((Object)key));
        RegistryValue prev = this.myValues.putIfAbsent(key, value);
        RegistryValue registryValue = prev == null ? value : prev;
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.get(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            LoadingState.LAF_INITIALIZED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static double doubleValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(8);
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(9);
        }
        String string = Registry.get(key).asString();
        if (string == null) {
            Registry.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static Color getColor(@NonNls @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(11);
        }
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return resourceBundle;
    }

    public String getBundleValue(@NonNls @NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if (this.myContributedKeys.containsKey((Object)key)) {
            return ((RegistryKeyDescriptor)this.myContributedKeys.get((Object)key)).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(14);
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        Element element = state;
        if (element == null) {
            Registry.$$$reportNull$$$0(15);
        }
        return element;
    }

    @ApiStatus.Internal
    public void loadState(@NotNull Element state) {
        if (state == null) {
            Registry.$$$reportNull$$$0(16);
        }
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = this.doGet(key)).isChangedFromDefault(value, this)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
        this.markAsLoaded();
    }

    @ApiStatus.Internal
    public void markAsLoaded() {
        this.myLoaded = true;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    @NotNull
    @ApiStatus.Internal
    public Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return map;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        THashMap<String, RegistryKeyDescriptor> contributedKeys = Registry.getInstance().myContributedKeys;
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired") || contributedKeys.containsKey(each)) continue;
            result.add(Registry.get(each));
        }
        for (String key : contributedKeys.keySet()) {
            result.add(Registry.get(key));
        }
        ArrayList<RegistryValue> arrayList = result;
        if (arrayList == null) {
            Registry.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        if (map == null) {
            Registry.$$$reportNull$$$0(19);
        }
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    public static synchronized void addKeys(@NotNull List<RegistryKeyDescriptor> descriptors) {
        if (descriptors == null) {
            Registry.$$$reportNull$$$0(20);
        }
        THashMap<String, RegistryKeyDescriptor> map = Registry.ourInstance.myContributedKeys;
        map.ensureCapacity(descriptors.size());
        for (RegistryKeyDescriptor descriptor : descriptors) {
            map.put((Object)descriptor.getName(), (Object)descriptor);
        }
    }

    public static synchronized void removeKey(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(21);
        }
        Registry.ourInstance.myContributedKeys.remove((Object)key);
        Registry.ourInstance.myValues.remove(key);
    }

    @Deprecated
    public static synchronized void addKey(@NonNls @NotNull String key, @NotNull String description, int defaultValue, boolean restartRequired) {
        if (key == null) {
            Registry.$$$reportNull$$$0(22);
        }
        if (description == null) {
            Registry.$$$reportNull$$$0(23);
        }
        Registry.getInstance().myContributedKeys.put((Object)key, (Object)new RegistryKeyDescriptor(key, description, Integer.toString(defaultValue), restartRequired, null));
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addKeys";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeKey";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

