/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.history;

import com.intellij.filePrediction.history.FileHistoryFeatures;
import com.intellij.filePrediction.history.FileHistoryManager;
import com.intellij.filePrediction.history.FileHistoryPersistence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/filePrediction/history/FilePredictionHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "manager", "Lcom/intellij/filePrediction/history/FileHistoryManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "calcHistoryFeatures", "Lcom/intellij/filePrediction/history/FileHistoryFeatures;", "fileUrl", "", "cleanup", "", "onFileOpened", "size", "", "Companion", "intellij.filePrediction"})
public final class FilePredictionHistory {
    private FileHistoryManager manager;
    @NotNull
    private final Project project;
    private static final int RECENT_FILES_LIMIT = 50;
    public static final Companion Companion = new Companion(null);

    public final void onFileOpened(@NotNull String fileUrl) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        this.manager.onFileOpened(fileUrl);
    }

    @NotNull
    public final FileHistoryFeatures calcHistoryFeatures(@NotNull String fileUrl) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        return this.manager.calcHistoryFeatures(fileUrl);
    }

    public final int size() {
        return this.manager.size();
    }

    public final void cleanup() {
        this.manager.cleanup();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public FilePredictionHistory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.manager = new FileHistoryManager(FileHistoryPersistence.INSTANCE.loadFileHistory(this.project), 50);
        this.project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, project){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        FileHistoryPersistence.INSTANCE.saveFileHistory(this.$project, FilePredictionHistory.access$getManager$p(this.this$0.this).getState());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$project = project;
                    }
                });
            }
        });
    }

    public static final /* synthetic */ FileHistoryManager access$getManager$p(FilePredictionHistory $this) {
        return $this.manager;
    }

    public static final /* synthetic */ void access$setManager$p(FilePredictionHistory $this, FileHistoryManager fileHistoryManager) {
        $this.manager = fileHistoryManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/filePrediction/history/FilePredictionHistory$Companion;", "", "()V", "RECENT_FILES_LIMIT", "", "getInstance", "Lcom/intellij/filePrediction/history/FilePredictionHistory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.filePrediction"})
    public static final class Companion {
        @NotNull
        public final FilePredictionHistory getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, FilePredictionHistory.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ctionHistory::class.java)");
            return (FilePredictionHistory)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

