/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FilePredictionFeature;
import com.intellij.filePrediction.FilePredictionFeaturesHelper;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010\u0013\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0014\u001a\u00020\u0012*\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/filePrediction/FileNavigationLogger;", "", "()V", "GROUP_ID", "", "logEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "event", "refsComputation", "", "isInRef", "Lcom/intellij/util/ThreeState;", "addFileFeatures", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "addNewFileInfo", "addPrevFileInfo", "intellij.filePrediction"})
public final class FileNavigationLogger {
    private static final String GROUP_ID = "file.prediction";
    public static final FileNavigationLogger INSTANCE;

    public final void logEvent(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull String event, long refsComputation, @NotNull ThreeState isInRef) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)isInRef, (String)"isInRef");
        FeatureUsageData data = this.addFileFeatures(this.addPrevFileInfo(this.addNewFileInfo(FileTypeUsagesCollector.newFeatureUsageData((FileType)newFile.getFileType()).addData("refs_computation", refsComputation), newFile, isInRef), prevFile), project, newFile, prevFile);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, event, data);
    }

    private final FeatureUsageData addNewFileInfo(@NotNull FeatureUsageData $this$addNewFileInfo, VirtualFile newFile, ThreeState isInRef) {
        if (isInRef != ThreeState.UNSURE) {
            $this$addNewFileInfo.addData("in_ref", isInRef == ThreeState.YES);
        }
        return $this$addNewFileInfo.addAnonymizedPath(newFile.getPath());
    }

    private final FeatureUsageData addPrevFileInfo(@NotNull FeatureUsageData $this$addPrevFileInfo, VirtualFile prevFile) {
        if (prevFile != null) {
            FileType fileType = prevFile.getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"prevFile.fileType");
            String string = fileType.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prevFile.fileType.name");
            return $this$addPrevFileInfo.addData("prev_file_type", string).addAnonymizedValue("prev_file_path", prevFile.getPath());
        }
        return $this$addPrevFileInfo;
    }

    private final FeatureUsageData addFileFeatures(@NotNull FeatureUsageData $this$addFileFeatures, Project project, VirtualFile newFile, VirtualFile prevFile) {
        Map<String, FilePredictionFeature> features;
        long start = System.currentTimeMillis();
        Map<String, FilePredictionFeature> map = features = FilePredictionFeaturesHelper.INSTANCE.calculateFileFeatures(project, newFile, prevFile);
        boolean bl = false;
        for (Map.Entry<String, FilePredictionFeature> feature : map.entrySet()) {
            feature.getValue().addToEventData(feature.getKey(), $this$addFileFeatures);
        }
        $this$addFileFeatures.addData("features_computation", System.currentTimeMillis() - start);
        return $this$addFileFeatures;
    }

    private FileNavigationLogger() {
    }

    static {
        FileNavigationLogger fileNavigationLogger;
        INSTANCE = fileNavigationLogger = new FileNavigationLogger();
    }
}

