/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToNestedIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiReturnStatement)) {
                    return false;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (!(returnValue instanceof PsiPolyadicExpression)) {
                    return false;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)returnValue;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                return tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR;
            }
        };
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiReturnStatement returnStatement;
        PsiExpression returnValue;
        if (element == null) {
            ConvertToNestedIfIntention.$$$reportNull$$$0(0);
        }
        if ((returnValue = (returnStatement = (PsiReturnStatement)element).getReturnValue()) == null || ErrorUtil.containsDeepError((PsiElement)returnValue)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String newStatementText = ConvertToNestedIfIntention.buildIf(returnValue, true, tracker, new StringBuilder()).toString();
        Project project = returnStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{" + newStatementText + "}", (PsiElement)returnStatement);
        PsiElement parent = returnStatement.getParent();
        if (parent instanceof PsiCodeBlock) {
            for (PsiStatement st : blockStatement.getCodeBlock().getStatements()) {
                CodeStyleManager.getInstance((Project)project).reformat(parent.addBefore((PsiElement)st, (PsiElement)returnStatement));
            }
            PsiReplacementUtil.replaceStatement((PsiStatement)returnStatement, "return false;", tracker);
        } else {
            blockStatement.getCodeBlock().add((PsiElement)elementFactory.createStatementFromText("return false;", (PsiElement)returnStatement));
            tracker.replaceAndRestoreComments((PsiElement)returnStatement, (PsiElement)blockStatement);
        }
    }

    private static StringBuilder buildIf(@Nullable PsiExpression expression2, boolean top, CommentTracker tracker, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                for (PsiExpression operand2 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand2, false, tracker, out);
                }
                if (top && !StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) {
                    out.append("return true;");
                }
                return out;
            }
            if (top && JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand3 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand3, false, tracker, out);
                    if (StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) continue;
                    out.append("return true;");
                }
                return out;
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            ConvertToNestedIfIntention.buildIf(parenthesizedExpression.getExpression(), top, tracker, out);
            return out;
        }
        if (expression2 != null) {
            out.append("if(").append(tracker.text((PsiElement)expression2)).append(")");
        }
        return out;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention", "processIntention"));
    }
}

