/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.AutomaticResourceManagementPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ReplaceArmWithTryFinallyIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new AutomaticResourceManagementPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        int i;
        PsiJavaToken token;
        PsiTryStatement tryStatement;
        if (element == null) {
            ReplaceArmWithTryFinallyIntention.$$$reportNull$$$0(0);
        }
        if ((tryStatement = (PsiTryStatement)(token = (PsiJavaToken)element).getParent()) == null) {
            return;
        }
        boolean replaceAll = tryStatement.getCatchBlocks().length == 0 && tryStatement.getFinallyBlock() == null;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return;
        }
        ArrayList<String> resources = new ArrayList<String>();
        StringBuilder newTryStatement = new StringBuilder("{");
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                newTryStatement.append(resource.getText()).append(";\n");
                resources.add(((PsiResourceVariable)resource).getName());
            } else {
                resources.add(resource.getText());
            }
            newTryStatement.append("try {");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement[] children = tryBlock.getChildren();
        for (i = 1; i < children.length - 1; ++i) {
            PsiElement child = children[i];
            newTryStatement.append(child.getText());
        }
        for (i = resources.size() - 1; i >= 0; --i) {
            newTryStatement.append("} finally {\n").append((String)resources.get(i)).append(".close();\n}");
        }
        newTryStatement.append('}');
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiCodeBlock newCodeBlock = factory.createCodeBlockFromText(newTryStatement.toString(), element);
        if (replaceAll) {
            for (PsiStatement newStatement : newCodeBlock.getStatements()) {
                tryStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        } else {
            resourceList.delete();
            tryBlock.replace((PsiElement)newCodeBlock);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention", "processIntention"));
    }
}

