/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CStyleCommentPredicate;
import org.jetbrains.annotations.NotNull;

public class ChangeToEndOfLineCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new CStyleCommentPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ChangeToEndOfLineCommentIntention.$$$reportNull$$$0(0);
        }
        PsiComment comment = (PsiComment)element;
        Project project = comment.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement parent = comment.getParent();
        assert (parent != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String commentText = comment.getText();
        PsiElement whitespace = comment.getNextSibling();
        String text2 = commentText.substring(2, commentText.length() - 2);
        String[] lines = text2.split("\n");
        int tabSize = ChangeToEndOfLineCommentIntention.getTabSize((PsiElement)comment);
        int firstLineStartColumn = ChangeToEndOfLineCommentIntention.getStartColumnNumber((PsiElement)comment, tabSize) + 2;
        ChangeToEndOfLineCommentIntention.trimLinesWithAlignment(lines, tabSize, firstLineStartColumn);
        for (int i = lines.length - 1; i >= 1; --i) {
            PsiComment nextComment = factory.createCommentFromText("//" + lines[i], parent);
            parent.addAfter((PsiElement)nextComment, (PsiElement)comment);
            if (whitespace == null) continue;
            PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
            PsiElement newWhiteSpace = parserFacade.createWhiteSpaceFromText(whitespace.getText());
            parent.addAfter(newWhiteSpace, (PsiElement)comment);
        }
        PsiComment newComment = factory.createCommentFromText("//" + lines[0], parent);
        PsiElement replacedComment = comment.replace((PsiElement)newComment);
        codeStyleManager.reformat(replacedComment);
    }

    private static int getTabSize(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            ChangeToEndOfLineCommentIntention.$$$reportNull$$$0(1);
        }
        return (file = element.getContainingFile()) == null ? 1 : Math.max(1, CodeStyle.getIndentOptions((PsiFile)file).TAB_SIZE);
    }

    private static int getStartColumnNumber(@NotNull PsiElement element, int tabSize) {
        PsiFile file;
        if (element == null) {
            ChangeToEndOfLineCommentIntention.$$$reportNull$$$0(2);
        }
        if ((file = element.getContainingFile()) == null) {
            return 0;
        }
        String text2 = file.getText();
        if (text2 == null) {
            return 0;
        }
        int elementOffset = element.getTextRange().getStartOffset();
        int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)text2, (int)(elementOffset - 1), (String)"\n") + 1;
        int column = 0;
        for (int i = lineStart; i < elementOffset; ++i) {
            column = ChangeToEndOfLineCommentIntention.nextColumn(column, text2.charAt(i), tabSize);
        }
        return column;
    }

    private static void trimLinesWithAlignment(String @NotNull [] lines, int tabSize, int firstLineStartColumn) {
        if (lines == null) {
            ChangeToEndOfLineCommentIntention.$$$reportNull$$$0(3);
        }
        if (lines.length == 1) {
            lines[0] = lines[0].trim();
        } else {
            int column;
            String line;
            int i;
            int minIndent = firstLineStartColumn;
            for (i = 1; i < lines.length; ++i) {
                char c;
                line = lines[i];
                column = 0;
                for (int j = 0; j < line.length() && " \t".indexOf(c = line.charAt(j)) != -1; ++j) {
                    column = ChangeToEndOfLineCommentIntention.nextColumn(column, c, tabSize);
                }
                if (column >= minIndent) continue;
                minIndent = column;
            }
            for (i = 1; i < lines.length; ++i) {
                int trimOffset;
                line = lines[i];
                column = 0;
                for (trimOffset = 0; trimOffset < line.length() && (column = ChangeToEndOfLineCommentIntention.nextColumn(column, line.charAt(trimOffset), tabSize)) <= minIndent; ++trimOffset) {
                }
                lines[i] = line.substring(trimOffset);
            }
        }
    }

    private static int nextColumn(int currentColumn, char c, int tabSize) {
        return c == '\t' ? (currentColumn / tabSize + 1) * tabSize : currentColumn + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/comment/ChangeToEndOfLineCommentIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTabSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartColumnNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "trimLinesWithAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

