/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class WaitNotifyNotInSynchronizedContextInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("wait.notify.while.not.synchronized.on.problem.descriptor", text2);
        if (string == null) {
            WaitNotifyNotInSynchronizedContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaiNotifyNotInSynchronizedContextVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection", "buildErrorString"));
    }

    private static class WaiNotifyNotInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private WaiNotifyNotInSynchronizedContextVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                WaiNotifyNotInSynchronizedContextVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression2) && !ThreadingUtils.isWaitCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                if (WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)expression2) || WaiNotifyNotInSynchronizedContextVisitor.isCoveredByGuardedByAnnotation((PsiElement)expression2, "this")) {
                    return;
                }
                this.registerError((PsiElement)expression2, "this");
            } else if (qualifier instanceof PsiReferenceExpression) {
                if (WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)expression2, qualifier)) {
                    return;
                }
                String text2 = qualifier.getText();
                if (WaiNotifyNotInSynchronizedContextVisitor.isCoveredByGuardedByAnnotation((PsiElement)expression2, text2)) {
                    return;
                }
                this.registerError((PsiElement)expression2, text2);
            }
        }

        private static boolean isCoveredByGuardedByAnnotation(PsiElement context, String guard) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMember.class);
            if (member == null) {
                return false;
            }
            return guard.equals(JCiPUtil.findGuardForMember(member));
        }

        private static boolean isSynchronizedOn(@NotNull PsiElement element, @NotNull PsiExpression target) {
            PsiSynchronizedStatement synchronizedStatement;
            if (element == null) {
                WaiNotifyNotInSynchronizedContextVisitor.$$$reportNull$$$0(1);
            }
            if (target == null) {
                WaiNotifyNotInSynchronizedContextVisitor.$$$reportNull$$$0(2);
            }
            if ((synchronizedStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class)) == null) {
                return false;
            }
            PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(synchronizedStatement.getLockExpression());
            EquivalenceChecker checker = EquivalenceChecker.getCanonicalPsiEquivalence();
            return checker.expressionsAreEquivalent(lockExpression2, target) || WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)synchronizedStatement, target);
        }

        private static boolean isSynchronizedOnThis(@NotNull PsiElement element) {
            PsiMethod method;
            PsiElement context;
            if (element == null) {
                WaiNotifyNotInSynchronizedContextVisitor.$$$reportNull$$$0(3);
            }
            if ((context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiSynchronizedStatement.class})) instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
                PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(synchronizedStatement.getLockExpression());
                return lockExpression2 instanceof PsiThisExpression || WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)synchronizedStatement);
            }
            return context instanceof PsiMethod && (method = (PsiMethod)context).hasModifierProperty("synchronized");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection$WaiNotifyNotInSynchronizedContextVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSynchronizedOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSynchronizedOnThis";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

