/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnGetClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("synchronization.on.get.class.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizationOnGetClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnGetClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnGetClassInspection", "buildErrorString"));
    }

    private static class SynchronizationOnGetClassVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnGetClassVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(statement.getLockExpression());
            if (!(lockExpression2 instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)lockExpression2;
            if (!MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Object", null, "getClass", new PsiType[0])) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }
    }
}

