/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NotNull;

public class ObjectNotifyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToNotifyInsteadOfNotifyAll";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.notify.problem.descriptor", new Object[0]);
        if (string == null) {
            ObjectNotifyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectNotifyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ObjectNotifyFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ObjectNotifyInspection", "buildErrorString"));
    }

    private static class ObjectNotifyVisitor
    extends BaseInspectionVisitor {
        private ObjectNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ObjectNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ObjectNotifyInspection$ObjectNotifyVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ObjectNotifyFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ObjectNotifyFix() {
        }

        @Override
        protected String getMethodName() {
            return "notifyAll";
        }
    }
}

