/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AssertHint {
    private final int myArgIndex;
    private final boolean myMessageOnFirstPosition;
    private final PsiExpression myMessage;
    private final PsiMethod myMethod;
    private final PsiExpression myOriginalExpression;

    private AssertHint(int index, boolean messageOnFirstPosition, PsiExpression message2, PsiMethod method, PsiExpression originalExpression) {
        this.myArgIndex = index;
        this.myMessageOnFirstPosition = messageOnFirstPosition;
        this.myMessage = message2;
        this.myMethod = method;
        this.myOriginalExpression = originalExpression;
    }

    public boolean isMessageOnFirstPosition() {
        return this.myMessageOnFirstPosition;
    }

    public int getArgIndex() {
        return this.myArgIndex;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiExpression getFirstArgument() {
        return ((PsiMethodCallExpression)this.myOriginalExpression).getArgumentList().getExpressions()[this.myArgIndex];
    }

    public PsiExpression getSecondArgument() {
        return ((PsiMethodCallExpression)this.myOriginalExpression).getArgumentList().getExpressions()[this.myArgIndex + 1];
    }

    public PsiExpression getExpected(boolean checkTestNG) {
        return checkTestNG ? this.getSecondArgument() : this.getFirstArgument();
    }

    public PsiExpression getActual(boolean checkTestNG) {
        return checkTestNG ? this.getFirstArgument() : this.getSecondArgument();
    }

    public PsiExpression getOriginalExpression() {
        return this.myOriginalExpression;
    }

    @Nullable
    public PsiExpression getMessage() {
        return this.myMessage;
    }

    public static AssertHint createAssertEqualsHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, (? super String methodName) -> "assertEquals".equals(methodName) ? Integer.valueOf(2) : null, checkTestNG);
    }

    public static AssertHint createAssertTrueFalseHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, (? super String methodName) -> "assertTrue".equals(methodName) || "assertFalse".equals(methodName) ? Integer.valueOf(1) : null, checkTestNG);
    }

    public static AssertHint create(PsiMethodCallExpression expression2, Function<? super String, Integer> methodNameToParamCount, boolean checkTestNG) {
        int argumentIndex;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length < minimumParamCount) {
            return null;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression message2 = null;
        if (messageOnFirstPosition) {
            if (parameters2.length > 0 && parameters2[0].getType().equalsToText("java.lang.String") && parameters2.length > minimumParamCount) {
                argumentIndex = 1;
                message2 = arguments[0];
            } else {
                argumentIndex = 0;
            }
        } else {
            int lastParameterIdx;
            argumentIndex = 0;
            if (parameters2.length > minimumParamCount && minimumParamCount >= 0 && parameters2[lastParameterIdx = parameters2.length - 1].getType() instanceof PsiClassType) {
                message2 = arguments[lastParameterIdx];
            }
        }
        return new AssertHint(argumentIndex, messageOnFirstPosition, message2, method, (PsiExpression)expression2);
    }

    public static AssertHint create(PsiMethodReferenceExpression methodExpression, Function<? super String, Integer> methodNameToParamCount, boolean checkTestNG) {
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)element;
        if (method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length != minimumParamCount) {
            return null;
        }
        return new AssertHint(0, messageOnFirstPosition, null, method, (PsiExpression)methodExpression);
    }

    private static boolean isMessageOnFirstPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.AssertJUnit".equals(qualifiedName) || "org.testng.Assert".equals(qualifiedName) && "fail".equals(method.getName());
        }
        return "junit.framework.Assert".equals(qualifiedName) || "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName) || "org.junit.Assume".equals(qualifiedName);
    }

    private static boolean isMessageOnLastPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.Assert".equals(qualifiedName) && !"fail".equals(method.getName());
        }
        return "org.junit.jupiter.api.Assertions".equals(qualifiedName) || "org.junit.jupiter.api.Assumptions".equals(qualifiedName);
    }

    public boolean isAssertTrue() {
        return "assertTrue".equals(this.getMethod().getName());
    }

    public static class JUnitCommonAssertNames {
        @NonNls
        public static final Map<String, Integer> ASSERT_METHOD_2_PARAMETER_COUNT;

        static {
            HashMap<String, Integer> map2 = new HashMap<String, Integer>(13);
            map2.put("assertArrayEquals", 2);
            map2.put("assertEquals", 2);
            map2.put("assertNotEquals", 2);
            map2.put("assertFalse", 1);
            map2.put("assumeFalse", 1);
            map2.put("assertNotNull", 1);
            map2.put("assertNotSame", 2);
            map2.put("assertNull", 1);
            map2.put("assertSame", 2);
            map2.put("assertThat", 2);
            map2.put("assertTrue", 1);
            map2.put("assumeTrue", 1);
            map2.put("fail", 0);
            ASSERT_METHOD_2_PARAMETER_COUNT = Collections.unmodifiableMap(map2);
        }
    }
}

