/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddThisQualifierFix;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedFieldAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedFieldAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unqualified.field.access.problem.descriptor", new Object[0]);
        if (string == null) {
            UnqualifiedFieldAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression expressionToQualify = (PsiReferenceExpression)infos[0];
        PsiField fieldAccessed = (PsiField)infos[1];
        return AddThisQualifierFix.buildFix((PsiExpression)expressionToQualify, (PsiMember)fieldAccessed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnqualifiedFieldAccessInspection", "buildErrorString"));
    }

    private static class UnqualifiedFieldAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                UnqualifiedFieldAccessVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression2);
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return;
            }
            PsiReferenceParameterList parameterList = expression2.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnqualifiedFieldAccessInspection$UnqualifiedFieldAccessVisitor", "visitReferenceExpression"));
        }
    }
}

