/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterTypeCanBeSpecifiedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.descriptor", infos);
        if (string == null) {
            LambdaParameterTypeCanBeSpecifiedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InferLambdaParameterTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InferLambdaParameterTypeFix(infos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "buildErrorString"));
    }

    private static class InferLambdaParameterTypeFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        InferLambdaParameterTypeFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.quickfix", this.myInfos);
            if (string == null) {
                InferLambdaParameterTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.family.quickfix", new Object[0]);
            if (string == null) {
                InferLambdaParameterTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                LambdaUtil.specifyLambdaParameterTypes((PsiLambdaExpression)((PsiLambdaExpression)element));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class InferLambdaParameterTypeVisitor
    extends BaseInspectionVisitor {
        private InferLambdaParameterTypeVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            String inferredTypesText;
            super.visitLambdaExpression(lambdaExpression);
            PsiParameterList parameterList = lambdaExpression.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length == 0) {
                return;
            }
            for (PsiParameter parameter2 : parameters2) {
                if (parameter2.getTypeElement() == null) continue;
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) != null && (inferredTypesText = LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression, (boolean)true)) != null) {
                PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)parameterList);
                if (PsiUtil.isJavaToken((PsiElement)nextElement, (IElementType)JavaTokenType.ARROW)) {
                    this.registerErrorAtRange((PsiElement)parameterList, nextElement, inferredTypesText);
                } else {
                    this.registerError((PsiElement)parameterList, inferredTypesText);
                }
            }
        }
    }
}

