/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.style.Variance;
import com.siyeh.ig.style.VarianceCandidate;
import com.siyeh.ig.style.VarianceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedWildcardInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(BoundedWildcardInspection.class);
    public boolean REPORT_INVARIANT_CLASSES = true;
    public boolean REPORT_PRIVATE_METHODS = true;
    public boolean REPORT_INSTANCE_METHODS = true;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
                if (candidate == null) {
                    return;
                }
                PsiTypeParameterListOwner owner2 = candidate.typeParameter.getOwner();
                if (owner2 instanceof PsiClass && !BoundedWildcardInspection.this.REPORT_INVARIANT_CLASSES && VarianceUtil.getClassVariance((PsiClass)owner2, candidate.typeParameter) == Variance.INVARIANT) {
                    return;
                }
                PsiClass containingClass = candidate.method.getContainingClass();
                if (!BoundedWildcardInspection.this.REPORT_PRIVATE_METHODS && (candidate.method.hasModifierProperty("private") || containingClass != null && containingClass.hasModifierProperty("private"))) {
                    return;
                }
                if (!(BoundedWildcardInspection.this.REPORT_INSTANCE_METHODS || candidate.method.hasModifierProperty("static") || candidate.method.isConstructor())) {
                    return;
                }
                Project project = holder.getProject();
                boolean canBeSuper = BoundedWildcardInspection.canChangeTo(project, candidate, false);
                boolean canBeExtends = BoundedWildcardInspection.canChangeTo(project, candidate, true);
                if (canBeExtends == canBeSuper || VarianceUtil.areBoundsSaturated(candidate, canBeExtends)) {
                    return;
                }
                boolean wildCardIsUseless = VarianceUtil.wildCardIsUseless(candidate, canBeExtends);
                ProblemHighlightType type2 = wildCardIsUseless ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String msg = (canBeExtends ? InspectionGadgetsBundle.message("bounded.wildcard.covariant.descriptor", new Object[0]) : InspectionGadgetsBundle.message("bounded.wildcard.contravariant.descriptor", new Object[0])) + (wildCardIsUseless ? " but decided against it" : "");
                if (!wildCardIsUseless || LOG.isDebugEnabled()) {
                    holder.registerProblem((PsiElement)typeElement, msg, type2, new LocalQuickFix[]{new ReplaceWithQuestionTFix(BoundedWildcardInspection.isOverriddenOrOverrides(candidate.method), canBeExtends)});
                }
            }
        };
    }

    @NotNull
    private static PsiClassReferenceType suggestMethodParameterType(@NotNull VarianceCandidate candidate, boolean isExtends) {
        if (candidate == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(2);
        }
        PsiType type2 = candidate.type;
        PsiManager psiManager = candidate.method.getManager();
        PsiElementFactory pf = PsiElementFactory.getInstance((Project)psiManager.getProject());
        PsiTypeElement newInnerTypeElement = pf.createTypeElement((PsiType)(isExtends ? PsiWildcardType.createExtends((PsiManager)psiManager, (PsiType)type2) : PsiWildcardType.createSuper((PsiManager)psiManager, (PsiType)type2)));
        PsiClassReferenceType methodParamType = candidate.methodParameterType;
        PsiClassReferenceType clone = new PsiClassReferenceType((PsiJavaCodeReferenceElement)methodParamType.getReference().copy(), methodParamType.getLanguageLevel());
        PsiAnnotation[] annotations = methodParamType.getApplicableAnnotations();
        PsiJavaCodeReferenceElement cloneReference = clone.getReference();
        for (int i = annotations.length - 1; i >= 0; --i) {
            PsiAnnotation annotation = annotations[i];
            cloneReference.addBefore((PsiElement)annotation, cloneReference.getFirstChild());
        }
        PsiTypeElement innerTypeElement = cloneReference.getParameterList().getTypeParameterElements()[candidate.typeParameterIndex];
        innerTypeElement.replace((PsiElement)newInnerTypeElement);
        PsiClassReferenceType psiClassReferenceType = clone;
        if (psiClassReferenceType == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(3);
        }
        return psiClassReferenceType;
    }

    private static boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(4);
        }
        if (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    private static PsiField findFieldAssignedFromMethodParameter(@NotNull PsiParameter methodParameter, @NotNull PsiMethod method) {
        PsiCodeBlock methodBody2;
        if (methodParameter == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(5);
        }
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(6);
        }
        if ((methodBody2 = method.getBody()) == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        Ref assignedToField = Ref.create();
        ReferencesSearch.search((PsiElement)methodParameter, (SearchScope)new LocalSearchScope((PsiElement)methodBody2)).forEach(ref -> {
            ProgressManager.checkCanceled();
            Pair<PsiField, PsiType> assigned = BoundedWildcardInspection.isAssignedToField(ref, containingClass);
            if (assigned != null) {
                if (!assignedToField.isNull() && !assigned.equals(assignedToField.get())) {
                    assignedToField.set(null);
                    return false;
                }
                assignedToField.set(assigned);
            }
            return true;
        });
        return (PsiField)Pair.getFirst((Pair)((Pair)assignedToField.get()));
    }

    private static boolean canChangeTo(@NotNull Project project, @NotNull VarianceCandidate candidate, boolean isExtends) {
        PsiMethod method;
        PsiCodeBlock methodBody2;
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(7);
        }
        if (candidate == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(8);
        }
        if ((methodBody2 = (method = candidate.method).getBody()) == null) {
            return false;
        }
        PsiClassReferenceType newParameterType = BoundedWildcardInspection.suggestMethodParameterType(candidate, isExtends);
        PsiMethod methodCopy = (PsiMethod)DebugUtil.performPsiModification((String)"Creating method copy", () -> BoundedWildcardInspection.createMethodCopy(project, candidate.method, candidate.methodParameterIndex, newParameterType));
        PsiClass containingClass = candidate.method.getContainingClass();
        PsiField field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
        ArrayList<PsiElement> superMethodsCalls = new ArrayList<PsiElement>();
        BoundedWildcardInspection.findSuperMethodCallsInside(methodCopy, candidate.superMethods, superMethodsCalls);
        if (field == null && containingClass.findMethodsByName(candidate.method.getName()).length == 1) {
            return BoundedWildcardInspection.errorChecks((PsiElement)methodCopy.getBody(), superMethodsCalls);
        }
        if (containingClass.getQualifiedName() != null) {
            List methodsToErrorCheck;
            PsiMethod methodCopyInClass = (PsiMethod)DebugUtil.performPsiModification((String)"Creating class copy", () -> BoundedWildcardInspection.createClassCopy(project, field, containingClass, candidate.method, methodCopy, newParameterType));
            if (field != null) {
                PsiClass classCopy = methodCopyInClass.getContainingClass();
                int fieldIndex = ArrayUtil.indexOf((Object[])containingClass.getFields(), (Object)field);
                if (fieldIndex == -1) {
                    return false;
                }
                PsiField fieldCopy = classCopy.getFields()[fieldIndex];
                Collection refs = ReferencesSearch.search((PsiElement)fieldCopy, (SearchScope)new LocalSearchScope((PsiElement)classCopy)).findAll();
                Map<PsiMethod, List<PsiReference>> collect2 = refs.stream().collect(Collectors.groupingBy(ref -> (PsiMethod)ObjectUtils.notNull((Object)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), PsiMethod.class), (Object)method)));
                methodsToErrorCheck = ContainerUtil.filter(collect2.keySet(), k -> k != method);
            } else {
                methodsToErrorCheck = Collections.singletonList(methodCopyInClass);
            }
            for (PsiMethod psiMethodCopy : methodsToErrorCheck) {
                PsiCodeBlock body2 = psiMethodCopy.getBody();
                if (body2 == null || BoundedWildcardInspection.errorChecks((PsiElement)body2, superMethodsCalls)) continue;
                return false;
            }
            return true;
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiMethod.class);
        if (containingMethod != null) {
            PsiMethod containingMethodCopy = (PsiMethod)DebugUtil.performPsiModification((String)"Creating method copy", () -> BoundedWildcardInspection.createMethodCopy(project, containingMethod, -1, newParameterType));
            int anonClassOffsetInContainingMethod = containingClass.getTextRange().getStartOffset() - containingMethod.getTextRange().getStartOffset();
            PsiElement element = containingMethodCopy.findElementAt(anonClassOffsetInContainingMethod);
            PsiClass containingClassCopy = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, containingClass.getClass(), (boolean)false);
            PsiMethod newMethodCopy = containingClassCopy.getMethods()[ArrayUtil.indexOf((Object[])containingClass.getMethods(), (Object)candidate.method)];
            PsiTypeElement paramTE = Objects.requireNonNull(newMethodCopy.getParameterList().getParameter(candidate.methodParameterIndex)).getTypeElement();
            ReplaceWithQuestionTFix.replaceType(project, paramTE, (PsiType)newParameterType);
            BoundedWildcardInspection.findSuperMethodCallsInside(newMethodCopy, candidate.superMethods, superMethodsCalls);
            return BoundedWildcardInspection.errorChecks((PsiElement)newMethodCopy.getBody(), superMethodsCalls);
        }
        return false;
    }

    private static void findSuperMethodCallsInside(@NotNull PsiMethod method, final @NotNull List<PsiMethod> superMethods, final @NotNull List<? super PsiElement> result) {
        PsiCodeBlock body2;
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(9);
        }
        if (superMethods == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(10);
        }
        if (result == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(11);
        }
        if ((body2 = method.getBody()) == null || superMethods.isEmpty()) {
            return;
        }
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiMethod called = expression2.resolveMethod();
                if (superMethods.contains(called)) {
                    result.add(expression2);
                }
                super.visitMethodCallExpression(expression2);
            }
        });
    }

    @NotNull
    private static PsiMethod createMethodCopy(@NotNull Project project, PsiMethod method, int methodParameterIndex, @NotNull PsiClassReferenceType newParameterExtends) {
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(12);
        }
        if (newParameterExtends == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(13);
        }
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)method);
        PsiMethod methodCopy = (PsiMethod)dummyHolder.add((PsiElement)method);
        dummyHolder.setInjectedDeclarations((processor, state, lastParent, place) -> processor.execute((PsiElement)methodCopy, state));
        if (methodParameterIndex != -1) {
            PsiTypeElement paramTE = Objects.requireNonNull(methodCopy.getParameterList().getParameter(methodParameterIndex)).getTypeElement();
            ReplaceWithQuestionTFix.replaceType(project, paramTE, (PsiType)newParameterExtends);
        }
        PsiMethod psiMethod = methodCopy;
        if (psiMethod == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(14);
        }
        return psiMethod;
    }

    @NotNull
    private static PsiMethod createClassCopy(@NotNull Project project, @Nullable PsiField field, @NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiMethod methodCopy, @NotNull PsiClassReferenceType newParameterExtends) {
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(15);
        }
        if (containingClass == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(16);
        }
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(17);
        }
        if (methodCopy == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(18);
        }
        if (newParameterExtends == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(19);
        }
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)containingClass);
        PsiClass classCopy = (PsiClass)dummyHolder.add((PsiElement)containingClass);
        if (field != null) {
            PsiField fieldCopy = classCopy.findFieldByName(field.getName(), false);
            ReplaceWithQuestionTFix.replaceType(project, fieldCopy.getTypeElement(), (PsiType)newParameterExtends);
        }
        int methodIndex = ArrayUtil.indexOf((Object[])containingClass.getMethods(), (Object)method);
        PsiMethod methodInClassCopy = classCopy.getMethods()[methodIndex];
        PsiMethod result = (PsiMethod)methodInClassCopy.replace((PsiElement)methodCopy);
        BoundedWildcardInspection.patchThisExpression(result, containingClass);
        PsiMethod psiMethod = result;
        if (psiMethod == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(20);
        }
        return psiMethod;
    }

    private static void patchThisExpression(PsiMethod methodCopy, PsiClass containingClass) {
        final PsiClass classCopy = methodCopy.getContainingClass();
        final ArrayList these = new ArrayList();
        methodCopy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                if (PsiUtil.resolveClassInType((PsiType)expression2.getType()) == classCopy) {
                    these.add(expression2);
                }
            }
        });
        if (!these.isEmpty()) {
            PsiElementFactory f = PsiElementFactory.getInstance((Project)containingClass.getProject());
            PsiParameter __this__ = f.createParameter("__this__", (PsiType)f.createType(containingClass));
            methodCopy.getParameterList().add((PsiElement)__this__);
            for (PsiThisExpression thisExpr : these) {
                PsiExpression newExpr = f.createExpressionFromText("__this__", (PsiElement)thisExpr);
                thisExpr.replace((PsiElement)newExpr);
            }
        }
    }

    private static boolean errorChecks(@NotNull PsiElement method, final @NotNull List<PsiElement> elementsToIgnore) {
        HighlightVisitor visitorImpl;
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(21);
        }
        if (elementsToIgnore == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(22);
        }
        if ((visitorImpl = (HighlightVisitor)ContainerUtil.find((Iterable)HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensionList((AreaInstance)method.getProject()), h -> h instanceof HighlightVisitorImpl)) == null) {
            return true;
        }
        final HighlightVisitor visitor2 = visitorImpl.clone();
        final HighlightInfoHolder holder = new HighlightInfoHolder(method.getContainingFile(), new HighlightInfoFilter[0]);
        visitor2.analyze(method.getContainingFile(), false, holder, () -> method.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (elementsToIgnore.contains(element)) {
                    return;
                }
                visitor2.visit(element);
                if (holder.hasErrorResults()) {
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/style/BoundedWildcardInspection$4", "visitElement"));
            }
        }));
        return !holder.hasErrorResults();
    }

    private static PsiElement skipParensAndCastsUp(@NotNull PsiElement element) {
        if (element == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(23);
        }
        PsiElement prev = element;
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression && ((PsiTypeCastExpression)parent).getOperand() == prev) {
            prev = parent;
            parent = parent.getParent();
        }
        return parent;
    }

    private static PsiExpression skipParensAndCastsDown(@Nullable PsiExpression element) {
        while (element instanceof PsiParenthesizedExpression || element instanceof PsiTypeCastExpression) {
            if (element instanceof PsiParenthesizedExpression) {
                element = ((PsiParenthesizedExpression)element).getExpression();
            }
            if (!(element instanceof PsiTypeCastExpression)) continue;
            element = ((PsiTypeCastExpression)element).getOperand();
        }
        return element;
    }

    private static Pair<PsiField, PsiType> isAssignedToField(@NotNull PsiReference ref, PsiClass containingClass) {
        PsiElement refElement;
        PsiElement parent;
        if (ref == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(24);
        }
        if (!((parent = BoundedWildcardInspection.skipParensAndCastsUp(refElement = ref.getElement())) instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ) {
            return null;
        }
        PsiExpression r = ((PsiAssignmentExpression)parent).getRExpression();
        if (!PsiTreeUtil.isAncestor((PsiElement)r, (PsiElement)refElement, (boolean)false)) {
            return null;
        }
        PsiExpression l = BoundedWildcardInspection.skipParensAndCastsDown(((PsiAssignmentExpression)parent).getLExpression());
        if (!(l instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpression = (PsiReferenceExpression)l;
        PsiExpression lQualifier = BoundedWildcardInspection.skipParensAndCastsDown(lExpression.getQualifierExpression());
        if (lQualifier != null && !(lQualifier instanceof PsiThisExpression)) {
            return null;
        }
        PsiElement resolved = lExpression.resolve();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (!field.hasModifierProperty("private") && !field.hasModifierProperty("packageLocal")) {
            return null;
        }
        PsiType type2 = r.getType();
        if (type2 == null) {
            return null;
        }
        if (field.getContainingClass() != containingClass) {
            return null;
        }
        return Pair.createNonNull((Object)field, (Object)type2);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.invariant.option", new Object[0]), "REPORT_INVARIANT_CLASSES");
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.private.option", new Object[0]), "REPORT_PRIVATE_METHODS");
        panel2.addCheckbox(InspectionGadgetsBundle.message("bounded.wildcard.report.instance.option", new Object[0]), "REPORT_INSTANCE_METHODS");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/BoundedWildcardInspection";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParameter";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethods";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterExtends";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCopy";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToIgnore";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/BoundedWildcardInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMethodParameterType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodCopy";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestMethodParameterType";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenOrOverrides";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFieldAssignedFromMethodParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canChangeTo";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodCallsInside";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCopy";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createClassCopy";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "errorChecks";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "skipParensAndCastsUp";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAssignedToField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithQuestionTFix
    implements LocalQuickFix {
        private final boolean isOverriddenOrOverrides;
        private final boolean isExtends;

        ReplaceWithQuestionTFix(boolean isOverriddenOrOverrides, boolean isExtends) {
            this.isOverriddenOrOverrides = isOverriddenOrOverrides;
            this.isExtends = isExtends;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"? " + (this.isExtends ? "extends" : "super")});
            if (string == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiField field;
            PsiElement element;
            if (project == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiTypeElement && element.isValid() && element.getParent() != null && element.isPhysical())) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
            if (candidate == null) {
                return;
            }
            PsiMethod method = candidate.method;
            PsiClassReferenceType clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
            if (!this.isOverriddenOrOverrides) {
                PsiField field2 = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
                if (field2 != null) {
                    ReplaceWithQuestionTFix.replaceType(project, field2.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
                }
                PsiTypeElement methodParameterTypeElement = candidate.methodParameter.getTypeElement();
                ReplaceWithQuestionTFix.replaceType(project, methodParameterTypeElement, (PsiType)clone);
                return;
            }
            int[] i = new int[]{0};
            List parameterInfos = ContainerUtil.map((Object[])method.getParameterList().getParameters(), p -> {
                int n = i[0];
                i[0] = n + 1;
                return ParameterInfoImpl.create(n).withName(p.getName()).withType(p.getType());
            });
            int index = method.getParameterList().getParameterIndex(candidate.methodParameter);
            if (index == -1) {
                return;
            }
            PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
            if (superMethod == null) {
                return;
            }
            if (superMethod != method) {
                method = superMethod;
                candidate = candidate.getSuperMethodVarianceCandidate(superMethod);
                clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
                i[0] = 0;
                parameterInfos = ContainerUtil.map((Object[])superMethod.getParameterList().getParameters(), p -> {
                    int n = i[0];
                    i[0] = n + 1;
                    return ParameterInfoImpl.create(n).withName(p.getName()).withType(p.getType());
                });
            }
            parameterInfos.set(index, ParameterInfoImpl.create(index).withName(candidate.methodParameter.getName()).withType((PsiType)clone));
            JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, false, null);
            dialog.setParameterInfos(parameterInfos);
            if (dialog.showAndGet() && (field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method)) != null) {
                ReplaceWithQuestionTFix.replaceType(project, field.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
            }
        }

        private static void replaceType(@NotNull Project project, @NotNull PsiTypeElement typeElement, @NotNull PsiType withType) {
            if (project == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(3);
            }
            if (typeElement == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(4);
            }
            if (withType == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(5);
            }
            PsiElementFactory pf = PsiElementFactory.getInstance((Project)project);
            PsiTypeElement newTypeElement = pf.createTypeElement(withType);
            if (typeElement.isPhysical()) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> typeElement.replace((PsiElement)newTypeElement));
            } else {
                typeElement.replace((PsiElement)newTypeElement);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/BoundedWildcardInspection$ReplaceWithQuestionTFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/BoundedWildcardInspection$ReplaceWithQuestionTFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

