/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UnsecureRandomNumberGenerationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String text2 = ((PsiElement)infos[0]).getText();
        if ("random".equals(text2)) {
            String string = InspectionGadgetsBundle.message("unsecure.random.number.generation.problem.descriptor1", new Object[0]);
            if (string == null) {
                UnsecureRandomNumberGenerationInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ("Random".equals(text2)) {
            String string = InspectionGadgetsBundle.message("unsecure.random.number.generation.problem.descriptor2", new Object[0]);
            if (string == null) {
                UnsecureRandomNumberGenerationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unsecure.random.number.generation.problem.descriptor3", new Object[0]);
        if (string == null) {
            UnsecureRandomNumberGenerationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InsecureRandomNumberGenerationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/UnsecureRandomNumberGenerationInspection", "buildErrorString"));
    }

    private static class InsecureRandomNumberGenerationVisitor
    extends BaseInspectionVisitor {
        private InsecureRandomNumberGenerationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                InsecureRandomNumberGenerationVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            PsiJavaCodeReferenceElement reference = expression2.getClassReference();
            if (reference == null) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Random")) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if ("java.security.SecureRandom".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                InsecureRandomNumberGenerationVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"random".equals(methodName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getQualifiedName();
            if (!"java.lang.Math".equals(className2)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/security/UnsecureRandomNumberGenerationInspection$InsecureRandomNumberGenerationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

