/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.makeStatic.MakeMethodStaticProcessor;
import com.intellij.refactoring.makeStatic.Settings;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MethodMayBeStaticInspection
extends BaseInspection {
    protected static final String IGNORE_DEFAULT_METHODS_ATTR_NAME = "m_ignoreDefaultMethods";
    protected static final String ONLY_PRIVATE_OR_FINAL_ATTR_NAME = "m_onlyPrivateOrFinal";
    protected static final String IGNORE_EMPTY_METHODS_ATTR_NAME = "m_ignoreEmptyMethods";
    protected static final String REPLACE_QUALIFIER_ATTR_NAME = "m_replaceQualifier";
    public boolean m_onlyPrivateOrFinal = false;
    public boolean m_ignoreEmptyMethods = true;
    public boolean m_ignoreDefaultMethods = true;
    public boolean m_replaceQualifier = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InspectionGadgetsFix(){

            @Override
            public void doFix(Project project, ProblemDescriptor descriptor) {
                PsiMethod element = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
                if (element != null) {
                    new MakeMethodStaticProcessor(project, element, new Settings(MethodMayBeStaticInspection.this.m_replaceQualifier, null, null)).run();
                }
            }

            public boolean startInWriteAction() {
                return false;
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionGadgetsBundle.message("change.modifier.quickfix", "static");
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MethodMayBeStaticInspection$1", "getFamilyName"));
            }
        };
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.only.option", new Object[0]), ONLY_PRIVATE_OR_FINAL_ATTR_NAME);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.empty.option", new Object[0]), IGNORE_EMPTY_METHODS_ATTR_NAME);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.ignore.default.methods.option", new Object[0]), IGNORE_DEFAULT_METHODS_ATTR_NAME);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.replaces.qualifiers.with.class.references.option", new Object[0]), REPLACE_QUALIFIER_ATTR_NAME);
        return optionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeStaticVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            MethodMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        node.addContent(new Element("option").setAttribute("name", ONLY_PRIVATE_OR_FINAL_ATTR_NAME).setAttribute("value", String.valueOf(this.m_onlyPrivateOrFinal)));
        node.addContent(new Element("option").setAttribute("name", IGNORE_EMPTY_METHODS_ATTR_NAME).setAttribute("value", String.valueOf(this.m_ignoreEmptyMethods)));
        if (!this.m_ignoreDefaultMethods) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_DEFAULT_METHODS_ATTR_NAME).setAttribute("value", "false"));
        }
        if (!this.m_replaceQualifier) {
            node.addContent(new Element("option").setAttribute("name", REPLACE_QUALIFIER_ATTR_NAME).setAttribute("value", "false"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/MethodMayBeStaticInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/MethodMayBeStaticInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MethodCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeStaticVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodCanBeStaticVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || method.hasModifierProperty("synchronized") || method.hasModifierProperty("native")) {
                return;
            }
            if (method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreDefaultMethods && method.hasModifierProperty("default")) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreEmptyMethods && MethodUtils.isEmpty(method)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)method);
            if (containingClass == null) {
                return;
            }
            for (Condition addin : InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensionList()) {
                if (!addin.value((Object)method)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile || containingClass.hasModifierProperty("static") || containingClass.isInterface())) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_onlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
                return;
            }
            if (this.isExcluded(method) || MethodUtils.hasSuper(method) || MethodUtils.isOverridden(method)) {
                return;
            }
            if (FindSuperElementsHelper.getSiblingInheritedViaSubClass(method) != null) {
                return;
            }
            MethodReferenceVisitor visitor2 = new MethodReferenceVisitor((PsiMember)method);
            method.accept((PsiElementVisitor)visitor2);
            if (!visitor2.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isExcluded(PsiMethod method) {
            return SerializationUtils.isWriteObject(method) || SerializationUtils.isReadObject(method) || SerializationUtils.isWriteReplace(method) || SerializationUtils.isReadResolve(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/performance/MethodMayBeStaticInspection$MethodCanBeStaticVisitor", "visitMethod"));
        }
    }
}

