/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySetIterationMayUseEntrySetInspection
extends BaseInspection {
    private static final CallMatcher ITERABLE_FOR_EACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_KEY_SET = CallMatcher.instanceCall("java.util.Map", "keySet").parameterCount(0);
    private static final CallMatcher MAP_GET = CallMatcher.instanceCall("java.util.Map", "get").parameterTypes("java.lang.Object");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        ReplacementMode mode = (ReplacementMode)((Object)infos[0]);
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.problem.descriptor", mode.myDisplayName);
        if (string == null) {
            KeySetIterationMayUseEntrySetInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new KeySetIterationMapUseEntrySetFix((ReplacementMode)((Object)infos[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new KeySetIterationMayUseEntrySetVisitor();
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiExpression getIteratedExpression(PsiExpression iteratedValue2) {
        PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(iteratedValue2);
        if (variable != null) {
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
            if (VariableAccessUtils.variableIsAssignedAtPoint((PsiVariable)variable, (PsiElement)containingMethod, (PsiElement)iteratedValue2)) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
        }
        return iteratedValue2;
    }

    @Contract(value="null -> null")
    private static PsiReferenceExpression getMapReferenceFromKeySetCall(PsiExpression keySetCandidate) {
        if (!(keySetCandidate instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)keySetCandidate;
        if (!MAP_KEY_SET.test(methodCallExpression)) {
            return null;
        }
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        return (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiReferenceExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "buildErrorString"));
    }

    private static class GetValueFromMapChecker
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable myKey;
        private final PsiReferenceExpression myMapReference;
        private boolean myGetValueFromMap;
        private boolean myKeyUsedExplicitly;
        private boolean myTainted;

        GetValueFromMapChecker(@NotNull PsiReferenceExpression mapReference, @NotNull PsiVariable key2) {
            if (mapReference == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(0);
            }
            if (key2 == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(1);
            }
            this.myMapReference = mapReference;
            this.myKey = key2;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (parent instanceof PsiAssignmentExpression && (expression2.isReferenceTo((PsiElement)this.myKey) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, (PsiExpression)expression2))) {
                this.myTainted = true;
                this.stopWalking();
            }
            if (!expression2.isReferenceTo((PsiElement)this.myKey)) {
                return;
            }
            if (this.isMapGetArgument(expression2)) {
                this.myGetValueFromMap = true;
            } else {
                this.myKeyUsedExplicitly = true;
            }
        }

        private boolean isMapGetArgument(PsiReferenceExpression arg) {
            PsiExpressionList argList = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)arg.getParent()), PsiExpressionList.class);
            if (argList == null || argList.getExpressionCount() != 1) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argList.getParent(), PsiMethodCallExpression.class);
            if (!MAP_GET.test(call)) {
                return false;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, qualifier);
        }

        boolean isKeyUsedExplicitly() {
            return this.myKeyUsedExplicitly;
        }

        boolean isGetValueFromMap() {
            return this.myGetValueFromMap && !this.myTainted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeySetIterationMayUseEntrySetVisitor
    extends BaseInspectionVisitor {
        private KeySetIterationMayUseEntrySetVisitor() {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue2 = ParenthesesUtils.stripParentheses(statement.getIteratedValue());
            PsiExpression iteratedExpression = KeySetIterationMayUseEntrySetInspection.getIteratedExpression(iteratedValue2);
            if (iteratedExpression == null) {
                return;
            }
            PsiParameter parameter2 = statement.getIterationParameter();
            PsiStatement context = statement.getBody();
            if (context == null) {
                return;
            }
            PsiReferenceExpression mapExpression = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(iteratedExpression);
            if (mapExpression == null) {
                return;
            }
            GetValueFromMapChecker checker = new GetValueFromMapChecker(mapExpression, (PsiVariable)parameter2);
            context.accept((PsiElementVisitor)checker);
            if (checker.isGetValueFromMap()) {
                this.registerError((PsiElement)iteratedValue2, new Object[]{checker.isKeyUsedExplicitly() ? ReplacementMode.ENTRY_SET : ReplacementMode.VALUES});
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (!ITERABLE_FOR_EACH.test(call)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(call.getMethodExpression().getQualifierExpression());
            PsiExpression expression2 = KeySetIterationMayUseEntrySetInspection.getIteratedExpression(qualifier);
            PsiReferenceExpression mapExpression = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(expression2);
            if (mapExpression == null) {
                return;
            }
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)arg, PsiLambdaExpression.class);
            if (lambda2 == null) {
                return;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return;
            }
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameter key2 = parameters2[0];
            GetValueFromMapChecker checker = new GetValueFromMapChecker(mapExpression, (PsiVariable)key2);
            body2.accept((PsiElementVisitor)checker);
            if (!checker.isGetValueFromMap()) {
                return;
            }
            this.registerError((PsiElement)qualifier, new Object[]{ReplacementMode.FOR_EACH});
        }
    }

    private static class KeySetIterationMapUseEntrySetFix
    extends InspectionGadgetsFix {
        private final ReplacementMode myMode;

        KeySetIterationMapUseEntrySetFix(ReplacementMode mode) {
            this.myMode = mode;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myMode.myDisplayName});
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.quickfix", new Object[0]);
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression keySetExpression;
            PsiLocalVariable toRemove2;
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                toRemove2 = ExpressionUtils.resolveLocalVariable(expression2);
                if (toRemove2 == null) {
                    return;
                }
                keySetExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)toRemove2.getInitializer());
            } else {
                toRemove2 = null;
                keySetExpression = expression2;
            }
            PsiReferenceExpression mapRef = KeySetIterationMayUseEntrySetInspection.getMapReferenceFromKeySetCall(keySetExpression);
            if (mapRef == null) {
                return;
            }
            if (this.myMode == ReplacementMode.FOR_EACH) {
                KeySetIterationMapUseEntrySetFix.processLambda(project, expression2, mapRef);
            } else {
                KeySetIterationMapUseEntrySetFix.processLoop(project, expression2, mapRef, this.myMode);
            }
            if (toRemove2 != null && ReferencesSearch.search((PsiElement)toRemove2).findFirst() == null) {
                PsiElement statement = toRemove2.getParent();
                if (statement instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)statement).getDeclaredElements().length == 1) {
                    statement.delete();
                } else {
                    toRemove2.delete();
                }
            }
        }

        private static void processLambda(Project project, PsiExpression iteratedValue2, PsiReferenceExpression mapRef) {
            PsiMethodCallExpression forEachCall = ExpressionUtils.getCallForQualifier(iteratedValue2);
            if (!ITERABLE_FOR_EACH.test(forEachCall)) {
                return;
            }
            PsiExpression[] args = forEachCall.getArgumentList().getExpressions();
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiLambdaExpression.class);
            if (lambda2 == null) {
                return;
            }
            PsiParameterList parameterList = lambda2.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiElement lambdaBody = lambda2.getBody();
            if (lambdaBody == null) {
                return;
            }
            PsiParameter keyParameter = Objects.requireNonNull(parameterList.getParameter(0));
            mapRef = (PsiReferenceExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)iteratedValue2, (PsiElement)mapRef);
            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapRef.getType(), (String)"java.util.Map", (int)1, (boolean)true);
            List<PsiExpression> accesses = ParameterAccessCollector.collectParameterAccesses(keyParameter, mapRef, lambdaBody);
            String valueName = KeySetIterationMapUseEntrySetFix.tryReuseValueVariable(lambdaBody, accesses, valueType);
            if (valueName == null) {
                valueName = new VariableNameGenerator(lambdaBody, VariableKind.PARAMETER).byType(valueType).byName("k".equals(keyParameter.getName()) ? "v" : "value").generate(false);
            }
            for (PsiExpression access : accesses) {
                if (!(access instanceof PsiMethodCallExpression) || !access.isValid()) continue;
                new CommentTracker().replaceAndRestoreComments((PsiElement)access, valueName);
            }
            String newLambdaText = "(" + keyParameter.getName() + "," + valueName + ")->" + lambdaBody.getText();
            PsiExpression newLambda = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newLambdaText, (PsiElement)lambda2);
            lambda2.replace((PsiElement)newLambda);
        }

        private static String tryReuseValueVariable(PsiElement scope, List<PsiExpression> accesses, PsiType wantedType) {
            for (PsiExpression access : accesses) {
                PsiLocalVariable var;
                PsiElement varParent;
                PsiElement parent;
                if (!(access instanceof PsiMethodCallExpression) || !((parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)access)) instanceof PsiLocalVariable) || !((varParent = (var = (PsiLocalVariable)parent).getParent()) instanceof PsiDeclarationStatement) || varParent.getParent() != scope || !var.getType().equals(wantedType) || VariableAccessUtils.variableIsAssigned((PsiVariable)var, scope)) continue;
                String valueName = var.getName();
                new CommentTracker().deleteAndRestoreComments((PsiElement)var);
                return valueName;
            }
            return null;
        }

        private static void processLoop(Project project, PsiExpression iteratedValue2, PsiReferenceExpression mapRef, ReplacementMode mode) {
            PsiCodeBlock codeBlock;
            PsiJavaToken brace;
            String replacement;
            PsiModifierList modifierList;
            PsiForeachStatement foreachStatement = (PsiForeachStatement)ObjectUtils.tryCast((Object)ParenthesesUtils.getParentSkipParentheses((PsiElement)iteratedValue2), PsiForeachStatement.class);
            if (foreachStatement == null) {
                return;
            }
            PsiMethodCallExpression newIterationValue = (PsiMethodCallExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)iteratedValue2, mapRef.getText() + "." + mode.myDisplayName);
            mapRef = (PsiReferenceExpression)newIterationValue.getMethodExpression().getQualifierExpression();
            PsiType collectionType = newIterationValue.getType();
            PsiType newParameterType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)collectionType, (String)"java.util.Collection", (int)0, (boolean)true));
            boolean insertCast = false;
            if (newParameterType == null) {
                newParameterType = TypeUtils.getObjectType((PsiElement)foreachStatement);
                insertCast = mode == ReplacementMode.ENTRY_SET;
            }
            PsiParameter keyParameter = foreachStatement.getIterationParameter();
            String keyParameterText = keyParameter.getText();
            String keyTypeText = keyParameter.getType().getCanonicalText();
            PsiStatement body2 = Objects.requireNonNull(foreachStatement.getBody());
            List accesses = ParameterAccessCollector.collectParameterAccesses(keyParameter, mapRef, (PsiElement)body2);
            String loopParameterName = null;
            if (mode == ReplacementMode.VALUES && body2 instanceof PsiBlockStatement) {
                loopParameterName = KeySetIterationMapUseEntrySetFix.tryReuseValueVariable((PsiElement)((PsiBlockStatement)body2).getCodeBlock(), accesses, newParameterType);
            }
            if (loopParameterName == null) {
                loopParameterName = KeySetIterationMapUseEntrySetFix.createNewVariableName((PsiElement)foreachStatement, newParameterType, mode);
            }
            PsiParameter loopParameter = JavaPsiFacade.getElementFactory((Project)project).createParameter(loopParameterName, newParameterType);
            if (keyParameter.hasModifierProperty("final") && (modifierList = loopParameter.getModifierList()) != null) {
                modifierList.setModifierProperty("final", true);
            }
            keyParameter.replace((PsiElement)loopParameter);
            String string = replacement = insertCast ? "((java.util.Map.Entry)" + loopParameterName + ')' : loopParameterName;
            if (body2 instanceof PsiBlockStatement && accesses.stream().filter(access -> !(access instanceof PsiMethodCallExpression)).count() > 1L && (brace = (codeBlock = ((PsiBlockStatement)body2).getCodeBlock()).getLBrace()) != null) {
                String keyVariableText = keyParameterText + "=" + replacement + ".getKey();";
                PsiStatement keyDeclaration = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(keyVariableText, (PsiElement)body2);
                codeBlock.addAfter((PsiElement)keyDeclaration, (PsiElement)brace);
                accesses = (List)StreamEx.of(accesses).select(PsiMethodCallExpression.class).collect(Collectors.toList());
            }
            KeySetIterationMapUseEntrySetFix.replaceParameterAccess(accesses, keyTypeText, replacement, mode);
        }

        private static void replaceParameterAccess(@NotNull List<PsiExpression> accesses, @NotNull String typeText, @NonNls String variableName, @NotNull ReplacementMode mode) {
            if (accesses == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(2);
            }
            if (typeText == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(3);
            }
            if (mode == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(4);
            }
            String keyAccess = '(' + typeText + ')' + variableName + ".getKey()";
            for (PsiExpression access : accesses) {
                if (access instanceof PsiMethodCallExpression) {
                    if (!access.isValid()) continue;
                    String replacement = mode == ReplacementMode.VALUES ? variableName : variableName + ".getValue()";
                    PsiReplacementUtil.replaceExpression(access, replacement);
                    continue;
                }
                assert (mode == ReplacementMode.ENTRY_SET);
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiReplacementUtil.replaceExpressionAndShorten(access, keyAccess);
                if (!RedundantCastUtil.isCastRedundant(typeCastExpression)) continue;
                PsiExpression operand2 = typeCastExpression.getOperand();
                assert (operand2 != null);
                PsiElement parent = typeCastExpression.getParent();
                typeCastExpression.replace((PsiElement)operand2);
                if (!(parent instanceof PsiParenthesizedExpression)) continue;
                ParenthesesUtils.removeParentheses((PsiExpression)parent, false);
            }
        }

        @NotNull
        private static String createNewVariableName(@NotNull PsiElement scope, @NotNull PsiType type2, ReplacementMode mode) {
            if (scope == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(5);
            }
            if (type2 == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(6);
            }
            VariableNameGenerator generator = new VariableNameGenerator(scope, VariableKind.LOCAL_VARIABLE);
            if (mode == ReplacementMode.VALUES) {
                generator.byType(type2).byName("value", "val", "v");
            } else {
                generator.byName("entry", "e").byType(type2);
            }
            String string = generator.generate(true);
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accesses";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewVariableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceParameterAccess";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewVariableName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ParameterAccessCollector
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiReferenceExpression myMapReference;
            private final PsiParameter myParameter;
            private final List<PsiExpression> myParameterAccesses = new ArrayList<PsiExpression>();

            ParameterAccessCollector(PsiParameter parameter2, PsiReferenceExpression mapReference) {
                this.myParameter = parameter2;
                this.myMapReference = mapReference;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null || !expression2.isReferenceTo((PsiElement)this.myParameter)) {
                    return;
                }
                if (!this.collectValueUsage(expression2)) {
                    this.myParameterAccesses.add((PsiExpression)expression2);
                }
            }

            private boolean collectValueUsage(PsiReferenceExpression expression2) {
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
                if (!(parent instanceof PsiExpressionList)) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!MAP_GET.test(methodCallExpression)) {
                    return false;
                }
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodCallExpression.getMethodExpression().getQualifierExpression());
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.myMapReference, (PsiExpression)referenceExpression)) {
                    return false;
                }
                this.myParameterAccesses.add((PsiExpression)methodCallExpression);
                return true;
            }

            List<PsiExpression> getParameterAccesses() {
                Collections.reverse(this.myParameterAccesses);
                return this.myParameterAccesses;
            }

            static List<PsiExpression> collectParameterAccesses(PsiParameter parameter2, PsiReferenceExpression mapReference, PsiElement body2) {
                ParameterAccessCollector collector = new ParameterAccessCollector(parameter2, mapReference);
                body2.accept((PsiElementVisitor)collector);
                return collector.getParameterAccesses();
            }
        }
    }

    private static enum ReplacementMode {
        FOR_EACH("Map.forEach()"),
        VALUES("values()"),
        ENTRY_SET("entrySet()");

        private final String myDisplayName;

        private ReplacementMode(String displayName) {
            this.myDisplayName = displayName;
        }
    }
}

