/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "OverlyNestedMethod";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("nesting.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer nestingDepth = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("nesting.depth.problem.descriptor", nestingDepth);
        if (string == null) {
            NestingDepthInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestingDepthMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NestingDepthInspection", "buildErrorString"));
    }

    private class NestingDepthMethodVisitor
    extends BaseInspectionVisitor {
        private NestingDepthMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NestingDepthMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NestingDepthVisitor visitor2 = new NestingDepthVisitor(NestingDepthInspection.this.getLimit());
            method.accept((PsiElementVisitor)visitor2);
            int count = visitor2.getMaximumDepth();
            if (count <= NestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/NestingDepthInspection$NestingDepthMethodVisitor", "visitMethod"));
        }
    }
}

