/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemOutErrInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    @NotNull
    public String getID() {
        return "UseOfSystemOutOrSystemErr";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.system.out.err.problem.descriptor", new Object[0]);
        if (string == null) {
            SystemOutErrInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemOutErrVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SystemOutErrInspection", "buildErrorString"));
    }

    private static class SystemOutErrVisitor
    extends BaseInspectionVisitor {
        private SystemOutErrVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                SystemOutErrVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression2);
            String name2 = expression2.getReferenceName();
            if (!"out".equals(name2) && !"err".equals(name2)) {
                return;
            }
            PsiElement referent = expression2.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getQualifiedName();
            if (!"java.lang.System".equals(className2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/maturity/SystemOutErrInspection$SystemOutErrVisitor", "visitReferenceExpression"));
        }
    }
}

