/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.JavaLoggingUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutLoggerInspection
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = StringUtil.join(JavaLoggingUtils.DEFAULT_LOGGERS, (String)",");
    public boolean ignoreSuperLoggers = false;
    public final ExternalizableStringSet annotations = new ExternalizableStringSet(new String[0]);
    public final ExternalizableStringSet ignoredClasses = new ExternalizableStringSet("java.lang.Throwable");

    public ClassWithoutLoggerInspection() {
        ClassWithoutLoggerInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public JComponent createOptionsPanel() {
        JPanel loggerPanel = UiUtils.createTreeClassChooserList(this.loggerNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.annotations), InspectionGadgetsBundle.message("ignore.classes.annotated.by", new Object[0]));
        JPanel ignoredClassesPanel = UiUtils.createTreeClassChooserList((Collection<? super String>)((Object)this.ignoredClasses), InspectionGadgetsBundle.message("ignored.class.hierarchies.border.title", new Object[0]), InspectionGadgetsBundle.message("choose.class.hierarchy.to.ignore.title", new Object[0]), new String[0]);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("super.class.logger.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSuperLoggers");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ignoredClassesPanel, "Center");
        panel2.add((Component)checkBox, "South");
        JBTabbedPane tabs = new JBTabbedPane(1);
        tabs.add(InspectionGadgetsBundle.message("class.without.logger.loggers.tab", new Object[0]), (Component)ScrollPaneFactory.createScrollPane((Component)loggerPanel, (boolean)true));
        tabs.add(InspectionGadgetsBundle.message("class.without.logger.ignored.classes.tab", new Object[0]), (Component)ScrollPaneFactory.createScrollPane((Component)panel2, (boolean)true));
        tabs.add(InspectionGadgetsBundle.message("class.without.logger.annotations.tab", new Object[0]), (Component)ScrollPaneFactory.createScrollPane((Component)annotationsListControl, (boolean)true));
        return tabs;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("no.logger.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithoutLoggerInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ClassWithoutLoggerInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        ClassWithoutLoggerInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ClassWithoutLoggerInspection.$$$reportNull$$$0(2);
        }
        this.loggerNamesString = ClassWithoutLoggerInspection.formatString(this.loggerNames);
        this.defaultWriteSettings(element, "annotations", "ignoredClasses");
        this.annotations.writeSettings(element, "annotations");
        this.ignoredClasses.writeSettings(element, "ignoredClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutLoggerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/ClassWithoutLoggerInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/ClassWithoutLoggerInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ClassWithoutLoggerVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                ClassWithoutLoggerVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.getContainingClass() != null) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (ClassWithoutLoggerInspection.this.ignoredClasses.stream().anyMatch(ignoredClass -> InheritanceUtil.isInheritor((PsiClass)aClass, (String)ignoredClass))) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)ClassWithoutLoggerInspection.this.annotations), (int)3)) {
                return;
            }
            PsiField[] psiFieldArray = fields = ClassWithoutLoggerInspection.this.ignoreSuperLoggers ? aClass.getAllFields() : aClass.getFields();
            if (Stream.of(fields).anyMatch(field -> this.isLogger((PsiVariable)field) && PsiUtil.isAccessible((PsiMember)field, (PsiElement)aClass, (PsiClass)aClass))) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return ClassWithoutLoggerInspection.this.loggerNames.contains(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/logging/ClassWithoutLoggerInspection$ClassWithoutLoggerVisitor", "visitClass"));
        }
    }
}

