/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticVoidFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;
    private final String myNewVisibility;

    MakePublicStaticVoidFix(PsiMethod method, boolean makeStatic) {
        this(method, makeStatic, "public");
    }

    MakePublicStaticVoidFix(PsiMethod method, boolean makeStatic, @PsiModifier.ModifierConstant String newVisibility) {
        String presentableVisibility = VisibilityUtil.getVisibilityString((String)newVisibility);
        this.myName = "Change signature of '" + PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)267, (int)2) + "' to '" + (presentableVisibility.isEmpty() ? "" : presentableVisibility + " ") + (makeStatic ? "static " : "") + "void " + method.getName() + "()'";
        this.myMakeStatic = makeStatic;
        this.myNewVisibility = newVisibility;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        final PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        if (method != null) {
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, method, false, this.myNewVisibility, method.getName(), (PsiType)PsiType.VOID, new ParameterInfoImpl[0]){

                protected void performRefactoring(UsageInfo @NotNull [] usages) {
                    if (usages == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.performRefactoring(usages);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)MakePublicStaticVoidFix.this.myMakeStatic);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/siyeh/ig/junit/MakePublicStaticVoidFix$1", "performRefactoring"));
                }
            };
            csp.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("make.public.static.void.fix.family.name", new Object[0]);
        if (string == null) {
            MakePublicStaticVoidFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            MakePublicStaticVoidFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/MakePublicStaticVoidFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

