/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInLoopConditionInspection
extends BaseInspection {
    public boolean ignoreIterationMethods = true;

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(false){

            @Override
            @NotNull
            public String getFamilyName() {
                String string = InspectionGadgetsBundle.message("introduce.variable.may.change.semantics.quickfix", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$1", "getFamilyName"));
            }
        };
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodCallInLoopConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inspection.method.call.in.loop.ignore.known.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreIterationMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspection", "buildErrorString"));
    }

    private class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            this.checkLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkLoop((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement);
            this.checkLoop((PsiConditionalLoopStatement)statement);
        }

        public void checkLoop(@NotNull PsiConditionalLoopStatement statement) {
            PsiExpression condition2;
            if (statement == null) {
                MethodCallInLoopConditionVisitor.$$$reportNull$$$0(3);
            }
            if ((condition2 = statement.getCondition()) == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        private void checkForMethodCalls(PsiExpression condition2) {
            condition2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression2);
                    if (MethodCallInLoopConditionInspection.this.ignoreIterationMethods && (this.isIterationMethod(expression2) || this.isCallToCasMethod(expression2))) {
                        return;
                    }
                    MethodCallInLoopConditionVisitor.this.registerMethodCallError(expression2, new Object[0]);
                }

                private boolean isIterationMethod(@NotNull PsiMethodCallExpression expression2) {
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", (PsiType)PsiType.BOOLEAN, "hasNext", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.ListIterator", (PsiType)PsiType.BOOLEAN, "hasPrevious", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.sql.ResultSet", (PsiType)PsiType.BOOLEAN, "next", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.Enumeration", (PsiType)PsiType.BOOLEAN, "hasMoreElements", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.Queue", null, "poll", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.lang.ref.ReferenceQueue", null, "poll", new PsiType[0]);
                }

                private boolean isCallToCasMethod(@NotNull PsiMethodCallExpression expression2) {
                    String methodName;
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!"weakCompareAndSet".equals(methodName = MethodCallUtils.getMethodName(expression2)) && !"compareAndSet".equals(methodName)) {
                        return false;
                    }
                    PsiMethod method = expression2.resolveMethod();
                    if (method == null) {
                        return false;
                    }
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null) {
                        return false;
                    }
                    String qualifiedName = containingClass.getQualifiedName();
                    return qualifiedName != null && qualifiedName.startsWith("java.util.concurrent.atomic.");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "expression";
                    objectArray2[1] = "com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isIterationMethod";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isCallToCasMethod";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/j2me/MethodCallInLoopConditionInspection$MethodCallInLoopConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

