/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInspection
extends BaseInspection {
    public boolean ignoreAsserts = false;
    public boolean ignoreSystemOuts = false;
    public boolean ignoreSystemErrs = false;
    public boolean ignoreThrowableArguments = false;
    public boolean ignoreConstantInitializers = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreInToString = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        SuppressForTestsScopeFix suppressFix;
        PsiMethod method;
        PsiMethodCallExpression operands2;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression2;
        PsiElement grandParent;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[0];
        ArrayList<InspectionGadgetsFix> result = new ArrayList<InspectionGadgetsFix>();
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)polyadicExpression);
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            DelegatingFix fix2 = StringConcatenationInspection.createAddAnnotationFix((PsiModifierListOwner)variable);
            result.add(fix2);
        } else if (parent instanceof PsiAssignmentExpression) {
            PsiReferenceExpression referenceExpression2;
            PsiElement target2;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiReferenceExpression && (target2 = (referenceExpression2 = (PsiReferenceExpression)lhs).resolve()) instanceof PsiModifierListOwner) {
                PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target2;
                DelegatingFix fix3 = StringConcatenationInspection.createAddAnnotationFix(modifierListOwner);
                result.add(fix3);
            }
        } else if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (qualifierExpression2 = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
            result.add(StringConcatenationInspection.createAddAnnotationFix(modifierListOwner));
        }
        for (PsiMethodCallExpression operand2 : operands2 = polyadicExpression.getOperands()) {
            PsiModifierListOwner element1 = StringConcatenationInspection.getAnnotatableElement((PsiExpression)operand2);
            if (element1 == null) continue;
            DelegatingFix fix4 = StringConcatenationInspection.createAddAnnotationFix(element1);
            result.add(fix4);
        }
        PsiElement expressionParent = PsiTreeUtil.getParentOfType((PsiElement)polyadicExpression, (Class[])new Class[]{PsiReturnStatement.class, PsiExpressionList.class});
        if (!(expressionParent instanceof PsiExpressionList) && expressionParent != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expressionParent, PsiMethod.class)) != null) {
            DelegatingFix fix5 = StringConcatenationInspection.createAddAnnotationFix((PsiModifierListOwner)method);
            result.add(fix5);
        }
        if ((suppressFix = SuppressForTestsScopeFix.build(this, (PsiElement)polyadicExpression)) == null) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
            if (inspectionGadgetsFixArray == null) {
                StringConcatenationInspection.$$$reportNull$$$0(1);
            }
            return inspectionGadgetsFixArray;
        }
        result.add(suppressFix);
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StringConcatenationInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    private static DelegatingFix createAddAnnotationFix(PsiModifierListOwner variable) {
        return new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", variable, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableElement(PsiExpression expression2) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        if (!TypeUtils.isJavaLangString(referenceExpression.getType())) {
            return null;
        }
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof PsiModifierListOwner) || !element.isPhysical()) {
            return null;
        }
        return (PsiModifierListOwner)element;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.assert", new Object[0]), "ignoreAsserts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.system.out", new Object[0]), "ignoreSystemOuts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.system.err", new Object[0]), "ignoreSystemErrs");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.exceptions", new Object[0]), "ignoreThrowableArguments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.constant.initializers", new Object[0]), "ignoreConstantInitializers");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.tostring", new Object[0]), "ignoreInToString");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/StringConcatenationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StringConcatenationVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            PsiMethod method;
            PsiMethodCallExpression methodCallExpression;
            PsiAssertStatement assertStatement;
            PsiExpression[] operands2;
            if (expression2 == null) {
                StringConcatenationVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
                if (!NonNlsUtils.isNonNlsAnnotated(operand2)) continue;
                return;
            }
            if (AnnotationUtil.isInsideAnnotation((PsiElement)expression2)) {
                return;
            }
            if (StringConcatenationInspection.this.ignoreAsserts && (assertStatement = (PsiAssertStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssertStatement.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
                return;
            }
            if ((StringConcatenationInspection.this.ignoreSystemErrs || StringConcatenationInspection.this.ignoreSystemOuts) && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String canonicalText = methodExpression.getCanonicalText();
                if (StringConcatenationInspection.this.ignoreSystemOuts && "System.out.println".equals(canonicalText) || "System.out.print".equals(canonicalText)) {
                    return;
                }
                if (StringConcatenationInspection.this.ignoreSystemErrs && "System.err.println".equals(canonicalText) || "System.err.print".equals(canonicalText)) {
                    return;
                }
            }
            if (StringConcatenationInspection.this.ignoreThrowableArguments && ExceptionUtils.isExceptionArgument((PsiExpression)expression2)) {
                return;
            }
            if (StringConcatenationInspection.this.ignoreConstantInitializers) {
                PsiElement parent = expression2.getParent();
                while (parent instanceof PsiBinaryExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiField) {
                    PsiField field = (PsiField)parent;
                    if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                        return;
                    }
                    PsiClass containingClass = field.getContainingClass();
                    if (containingClass != null && containingClass.isInterface()) {
                        return;
                    }
                }
            }
            if (StringConcatenationInspection.this.ignoreInToString && MethodUtils.isToString(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression2)) {
                return;
            }
            for (int i = 1; i < operands2.length; ++i) {
                PsiJavaToken token;
                PsiExpression operand3 = operands2[i];
                if (!ExpressionUtils.isStringConcatenationOperand(operand3) || (token = expression2.getTokenBeforeOperand(operand3)) == null) continue;
                this.registerError((PsiElement)token, expression2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/internationalization/StringConcatenationInspection$StringConcatenationVisitor", "visitPolyadicExpression"));
        }
    }
}

