/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractMethodWithMissingImplementationsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.with.missing.implementations.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractMethodWithMissingImplementationsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodWithMissingImplementationsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection", "buildErrorString"));
    }

    private static class InheritorFinder
    implements Runnable {
        private final PsiClass aClass;
        private Collection<PsiClass> inheritors = null;

        InheritorFinder(PsiClass aClass) {
            this.aClass = aClass;
        }

        @Override
        public void run() {
            SearchScope searchScope = this.aClass.getUseScope();
            this.inheritors = ClassInheritorsSearch.search((PsiClass)this.aClass, (SearchScope)searchScope, (boolean)true).findAll();
        }

        public Collection<PsiClass> getInheritors() {
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess((Runnable)this, null);
            return this.inheritors;
        }
    }

    private static class AbstractMethodWithMissingImplementationsVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodWithMissingImplementationsVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.getNameIdentifier() == null || !method.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            InheritorFinder inheritorFinder = new InheritorFinder(containingClass);
            for (PsiClass inheritor : inheritorFinder.getInheritors()) {
                if (AbstractMethodWithMissingImplementationsVisitor.hasMatchingImplementation(inheritor, method, containingClass)) continue;
                if (inheritor.isEnum()) {
                    List enumConstants = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inheritor, PsiEnumConstant.class);
                    for (PsiEnumConstant enumConstant : enumConstants) {
                        PsiEnumConstantInitializer initializingClass2 = enumConstant.getInitializingClass();
                        if (initializingClass2 != null && AbstractMethodWithMissingImplementationsVisitor.hasMatchingImplementation((PsiClass)initializingClass2, method, containingClass)) continue;
                        this.registerMethodError(method, new Object[0]);
                        return;
                    }
                    continue;
                }
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean hasMatchingImplementation(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiClass superClass) {
            if (aClass == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(0);
            }
            if (method == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(1);
            }
            if (superClass == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(2);
            }
            if (aClass.hasModifierProperty("abstract") || !aClass.isInheritor(superClass, true)) {
                return true;
            }
            PsiMethod overridingMethod = AbstractMethodWithMissingImplementationsVisitor.findOverridingMethod(aClass, method, superClass);
            if (overridingMethod == null || overridingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (!method.hasModifierProperty("packageLocal")) {
                return true;
            }
            PsiManager manager = overridingMethod.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            return facade.arePackagesTheSame((PsiElement)superClass, (PsiElement)aClass);
        }

        @Nullable
        private static PsiMethod findOverridingMethod(PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiClass superClass) {
            if (method == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(3);
            }
            if (superClass == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(4);
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature signature = method.getSignature(substitutor);
            List pairs = aClass.findMethodsAndTheirSubstitutorsByName(signature.getName(), true);
            for (Pair pair2 : pairs) {
                PsiSubstitutor overridingSubstitutor;
                MethodSignature foundMethodSignature;
                PsiClass containingClass;
                PsiMethod overridingMethod = (PsiMethod)pair2.first;
                if (overridingMethod.hasModifierProperty("abstract") || (containingClass = overridingMethod.getContainingClass()) != null && containingClass.isInterface() && !overridingMethod.hasModifierProperty("default") || !MethodSignatureUtil.isSubsignature((MethodSignature)signature, (MethodSignature)(foundMethodSignature = overridingMethod.getSignature(overridingSubstitutor = (PsiSubstitutor)pair2.second))) || overridingMethod == method) continue;
                return overridingMethod;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection$AbstractMethodWithMissingImplementationsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasMatchingImplementation";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findOverridingMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

