/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class StaticImportInspection
extends BaseInspection {
    public boolean ignoreSingleFieldImports = false;
    public boolean ignoreSingeMethodImports = false;
    public boolean ignoreInTestCode = false;
    public OrderedSet<String> allowedClasses = new OrderedSet();

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        SmartList result = new SmartList();
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)infos[0];
        SuppressForTestsScopeFix fix2 = SuppressForTestsScopeFix.build(this, (PsiElement)importStaticStatement);
        ContainerUtil.addIfNotNull((Collection)result, (Object)fix2);
        PsiClass aClass = importStaticStatement.resolveTargetClass();
        if (aClass != null) {
            String name2 = aClass.getQualifiedName();
            result.add(new IgnoreClassFix(name2, (Collection<? super String>)this.allowedClasses, "Allow static imports for class '" + name2 + "'"));
        }
        result.add(this.buildFix(infos));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StaticImportInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JPanel chooserList = UiUtils.createTreeClassChooserList(this.allowedClasses, "Statically importable Classes", "Choose statically importable class", new String[0]);
        panel2.add((Component)chooserList, constraints);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("ignore.single.field.static.imports.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSingleFieldImports");
        panel2.add((Component)checkBox1, constraints);
        constraints.gridy = 2;
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.single.method.static.imports.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSingeMethodImports");
        panel2.add((Component)checkBox2, constraints);
        return panel2;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.import.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticImportInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/imports/StaticImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticImportVisitor
    extends BaseInspectionVisitor {
        private StaticImportVisitor() {
        }

        public void visitImportStaticStatement(PsiImportStaticStatement statement) {
            super.visitImportStaticStatement(statement);
            if (this.shouldReportImportStatement(statement)) {
                this.registerError((PsiElement)statement, statement);
            }
        }

        private boolean shouldReportImportStatement(PsiImportStaticStatement importStatement) {
            PsiJavaCodeReferenceElement importReference2 = importStatement.getImportReference();
            if (importReference2 == null || importReference2.multiResolve(false).length == 0) {
                return false;
            }
            boolean checked = false;
            for (PsiClass targetClass = importStatement.resolveTargetClass(); targetClass != null; targetClass = targetClass.getContainingClass()) {
                String qualifiedName = targetClass.getQualifiedName();
                if (StaticImportInspection.this.allowedClasses.contains((Object)qualifiedName)) {
                    return false;
                }
                if (checked) break;
                checked = true;
            }
            if (importStatement.isOnDemand()) {
                return true;
            }
            if (StaticImportInspection.this.ignoreSingleFieldImports || StaticImportInspection.this.ignoreSingeMethodImports) {
                JavaResolveResult[] results;
                boolean field = false;
                boolean method = false;
                for (JavaResolveResult result : results = importReference2.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element instanceof PsiField) {
                        field = true;
                        continue;
                    }
                    if (!(element instanceof PsiMethod)) continue;
                    method = true;
                }
                if (field && !method ? StaticImportInspection.this.ignoreSingleFieldImports : method && !field && StaticImportInspection.this.ignoreSingeMethodImports) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class StaticImportFix
    extends InspectionGadgetsFix {
        private StaticImportFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.import.replace.quickfix", new Object[0]);
            if (string == null) {
                StaticImportFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiImportStaticStatement importStatement = (PsiImportStaticStatement)descriptor.getPsiElement();
            PsiJavaCodeReferenceElement importReference2 = importStatement.getImportReference();
            if (importReference2 == null) {
                return;
            }
            JavaResolveResult[] importTargets = importReference2.multiResolve(false);
            if (importTargets.length == 0) {
                return;
            }
            boolean onDemand = importStatement.isOnDemand();
            StaticImportReferenceCollector referenceCollector = new StaticImportReferenceCollector(importTargets, onDemand);
            PsiJavaFile file = (PsiJavaFile)importStatement.getContainingFile();
            file.accept((PsiElementVisitor)referenceCollector);
            List<PsiJavaCodeReferenceElement> references = referenceCollector.getReferences();
            HashMap<PsiJavaCodeReferenceElement, PsiMember> referenceTargetMap = new HashMap<PsiJavaCodeReferenceElement, PsiMember>();
            for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : references) {
                PsiElement target = psiJavaCodeReferenceElement.resolve();
                if (target instanceof PsiEnumConstant && psiJavaCodeReferenceElement instanceof PsiExpression && PsiImplUtil.getSwitchLabel((PsiExpression)psiJavaCodeReferenceElement) != null || !(target instanceof PsiMember)) continue;
                PsiMember member = (PsiMember)target;
                referenceTargetMap.put(psiJavaCodeReferenceElement, member);
            }
            new CommentTracker().deleteAndRestoreComments((PsiElement)importStatement);
            for (Map.Entry entry : referenceTargetMap.entrySet()) {
                StaticImportFix.removeReference((PsiJavaCodeReferenceElement)entry.getKey(), (PsiMember)entry.getValue());
            }
        }

        private static void removeReference(PsiJavaCodeReferenceElement reference, PsiMember target) {
            PsiManager manager = reference.getManager();
            Project project = manager.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiClass aClass = target.getContainingClass();
            if (aClass == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String qualifiedName = aClass.getQualifiedName();
            String text2 = tracker.text((PsiElement)reference);
            String referenceText = qualifiedName + '.' + text2;
            if (reference instanceof PsiReferenceExpression) {
                PsiElement insertedElement = tracker.replaceAndRestoreComments((PsiElement)reference, referenceText);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
            } else {
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByFQClassName(referenceText, reference.getResolveScope());
                PsiElement insertedElement = tracker.replaceAndRestoreComments((PsiElement)reference, (PsiElement)referenceElement);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(insertedElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/StaticImportInspection$StaticImportFix", "getFamilyName"));
        }

        static class StaticImportReferenceCollector
        extends JavaRecursiveElementVisitor {
            private final JavaResolveResult[] importTargets;
            private final boolean onDemand;
            private final List<PsiJavaCodeReferenceElement> references;

            StaticImportReferenceCollector(JavaResolveResult @NotNull [] importTargets, boolean onDemand) {
                if (importTargets == null) {
                    StaticImportReferenceCollector.$$$reportNull$$$0(0);
                }
                this.references = new ArrayList<PsiJavaCodeReferenceElement>();
                this.importTargets = importTargets;
                this.onDemand = onDemand;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (StaticImportReferenceCollector.isFullyQualifiedReference(reference)) {
                    return;
                }
                PsiElement parent = reference.getParent();
                if (parent instanceof PsiImportStatementBase) {
                    return;
                }
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    if (!((parent = parent.getParent()) instanceof PsiImportStatementBase)) continue;
                    return;
                }
                this.checkStaticImportReference(reference);
            }

            private void checkStaticImportReference(PsiJavaCodeReferenceElement reference) {
                if (reference.isQualified()) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMethod || target instanceof PsiClass || target instanceof PsiField)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                if (!member.hasModifierProperty("static")) {
                    return;
                }
                for (JavaResolveResult importTarget : this.importTargets) {
                    PsiElement targetElement = importTarget.getElement();
                    if (targetElement instanceof PsiMethod || targetElement instanceof PsiField) {
                        if (!member.equals(targetElement)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!(targetElement instanceof PsiClass)) continue;
                    if (this.onDemand) {
                        PsiClass containingClass = member.getContainingClass();
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)targetElement), (PsiClass)containingClass, (boolean)true)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!targetElement.equals(member)) continue;
                    this.addReference(reference);
                }
            }

            private void addReference(PsiJavaCodeReferenceElement reference) {
                this.references.add(reference);
            }

            public List<PsiJavaCodeReferenceElement> getReferences() {
                return this.references;
            }

            public static boolean isFullyQualifiedReference(PsiJavaCodeReferenceElement reference) {
                if (!reference.isQualified()) {
                    return false;
                }
                PsiElement directParent = reference.getParent();
                if (directParent instanceof PsiMethodCallExpression || directParent instanceof PsiAssignmentExpression || directParent instanceof PsiVariable) {
                    return false;
                }
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class});
                if (parent != null) {
                    return false;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                String fqName = aClass.getQualifiedName();
                if (fqName == null) {
                    return false;
                }
                return PsiNameHelper.getQualifiedClassName((String)reference.getText(), (boolean)false).equals(fqName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTargets", "com/siyeh/ig/imports/StaticImportInspection$StaticImportFix$StaticImportReferenceCollector", "<init>"));
            }
        }
    }
}

