/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassWithTooManyDependenciesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            ClassWithTooManyDependenciesInspection.$$$reportNull$$$0(3);
        }
        if (refEntity instanceof RefClass) {
            RefClass refClass = (RefClass)refEntity;
            if (refClass.getOwner() instanceof RefClass) {
                return null;
            }
            Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
            int numDependencies = dependencies.size();
            if (numDependencies <= this.limit) {
                return null;
            }
            String errorString = InspectionGadgetsBundle.message("class.with.too.many.dependencies.problem.descriptor", refClass.getName(), numDependencies, this.limit);
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("class.with.too.many.dependencies.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/dependency/ClassWithTooManyDependenciesInspection";
        objectArray[2] = "checkElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

