/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.style.ConditionalModel;
import com.siyeh.ig.style.IfConditionalModel;
import java.util.Objects;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreChainedIf = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "RedundantIfStatement";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), (InspectionProfileEntry)this, "ignoreChainedIf");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        boolean chainedIf = (Boolean)infos[0];
        if (chainedIf) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new TrivialIfFix(), new DelegatingFix(new SetInspectionOptionFix((LocalInspectionTool)this, "ignoreChainedIf", InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), true))};
            if (inspectionGadgetsFixArray == null) {
                TrivialIfInspection.$$$reportNull$$$0(1);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new TrivialIfFix()};
        if (inspectionGadgetsFixArray == null) {
            TrivialIfInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Nullable
    private static String getReplacementText(ConditionalModel model, CommentTracker ct) {
        PsiExpression replacement;
        PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(model.getThenExpression());
        PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(model.getElseExpression());
        if (thenLiteral != null && elseLiteral != null) {
            if (Boolean.TRUE.equals(thenLiteral.getValue()) && Boolean.FALSE.equals(elseLiteral.getValue())) {
                return ct.text((PsiElement)model.getCondition());
            }
            if (Boolean.FALSE.equals(thenLiteral.getValue()) && Boolean.TRUE.equals(elseLiteral.getValue())) {
                return BoolUtils.getNegatedExpressionText(model.getCondition(), ct);
            }
        }
        if ((replacement = TrivialIfInspection.getRedundantComparisonReplacement(model)) != null) {
            return ct.text((PsiElement)replacement);
        }
        return null;
    }

    private static PsiExpression getRedundantComparisonReplacement(@NotNull ConditionalModel model) {
        if (model == null) {
            TrivialIfInspection.$$$reportNull$$$0(3);
        }
        @NotNull PsiExpression thenExpression2 = model.getThenExpression();
        @NotNull PsiExpression elseExpression2 = model.getElseExpression();
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)model.getCondition()), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        IElementType tokenType = binOp.getOperationTokenType();
        boolean equals = tokenType.equals(JavaTokenType.EQEQ);
        if (!equals && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (!ExpressionUtils.isSafelyRecomputableExpression(left) || !ExpressionUtils.isSafelyRecomputableExpression(right)) {
            return null;
        }
        if (TypeConversionUtil.isFloatOrDoubleType((PsiType)left.getType()) && TypeConversionUtil.isFloatOrDoubleType((PsiType)right.getType())) {
            return null;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (equivalence.expressionsAreEquivalent(left, thenExpression2) && equivalence.expressionsAreEquivalent(right, elseExpression2) || equivalence.expressionsAreEquivalent(right, thenExpression2) && equivalence.expressionsAreEquivalent(left, elseExpression2)) {
            return equals ? elseExpression2 : thenExpression2;
        }
        return null;
    }

    private static void simplify(PsiIfStatement statement) {
        CommentTracker ct;
        String text2;
        IfConditionalModel model = IfConditionalModel.from(statement, true);
        if (model != null && (text2 = TrivialIfInspection.getReplacementText(model, ct = new CommentTracker())) != null) {
            if (model.getElseExpression().textMatches((CharSequence)text2) && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)model.getElseBranch(), (boolean)false)) {
                ct.deleteAndRestoreComments((PsiElement)statement);
            } else {
                ct.replace((PsiElement)model.getThenExpression(), text2);
                ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)model.getThenBranch());
                PsiStatement elseBranch = model.getElseBranch();
                if (elseBranch.isValid() && (elseBranch instanceof PsiExpressionStatement || !ControlFlowUtils.isReachable(elseBranch))) {
                    PsiElement sibling = elseBranch.getPrevSibling();
                    if (sibling instanceof PsiWhiteSpace) {
                        sibling.delete();
                    }
                    new CommentTracker().deleteAndRestoreComments((PsiElement)elseBranch);
                }
            }
        }
        if (TrivialIfInspection.isSimplifiableAssert(statement)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement) {
        PsiExpression condition2 = statement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        if (statement.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory((Project)statement.getProject()).createExpressionFromText(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText(), (PsiElement)statement);
        assertCondition.replace((PsiElement)replacementCondition);
        statement.replace((PsiElement)assertStatement);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
                boolean chainedIf;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitIfStatement(ifStatement);
                boolean bl = chainedIf = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ifStatement) instanceof PsiIfStatement || ifStatement.getParent() instanceof PsiIfStatement && ((PsiIfStatement)ifStatement.getParent()).getElseBranch() == ifStatement;
                if (TrivialIfInspection.this.ignoreChainedIf && chainedIf && !this.isOnTheFly()) {
                    return;
                }
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null) {
                    return;
                }
                if (TrivialIfInspection.isTrivial(ifStatement)) {
                    PsiElement anchor = Objects.requireNonNull(ifStatement.getFirstChild());
                    ProblemHighlightType level = TrivialIfInspection.this.ignoreChainedIf && chainedIf ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    boolean addIgnoreFix = chainedIf && !TrivialIfInspection.this.ignoreChainedIf && !InspectionProjectProfileManager.isInformationLevel((String)TrivialIfInspection.this.getShortName(), (PsiElement)ifStatement);
                    this.registerError(anchor, level, new Object[]{addIgnoreFix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$1", "visitIfStatement"));
            }
        };
    }

    private static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        IfConditionalModel model = IfConditionalModel.from(ifStatement, true);
        if (model != null && TrivialIfInspection.getReplacementText(model, new CommentTracker()) != null) {
            return true;
        }
        return TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/TrivialIfInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/TrivialIfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRedundantComparisonReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("trivial.if.fix.family.name", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
        }
    }
}

