/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.CreateMissingSwitchBranchesFix;
import com.siyeh.ig.psiutils.CreateSwitchBranchesUtil;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSwitchStatementWhichMissesCasesInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean ignoreSwitchStatementsWithDefault = true;

    @NotNull
    static String buildErrorString(String enumName, Set<String> names2) {
        if (names2.size() == 1) {
            String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor.single", enumName, names2.iterator().next());
            if (string == null) {
                EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String namesString = CreateSwitchBranchesUtil.formatMissingBranches(names2);
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor", enumName, namesString);
        if (string == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processSwitchBlock((PsiSwitchBlock)statement);
            }

            public void visitSwitchExpression(PsiSwitchExpression expression2) {
                this.processSwitchBlock((PsiSwitchBlock)expression2);
            }

            public void processSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
                PsiExpression expression2;
                if (switchBlock == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)switchBlock.getExpression())) == null) {
                    return;
                }
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                if (aClass == null || !aClass.isEnum()) {
                    return;
                }
                Set constants = (Set)StreamEx.of((Object[])aClass.getAllFields()).select(PsiEnumConstant.class).map(PsiField::getName).toCollection(LinkedHashSet::new);
                if (constants.isEmpty()) {
                    return;
                }
                boolean hasDefault = false;
                ProblemHighlightType highlighting = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                for (PsiSwitchLabelStatementBase child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switchBlock.getBody(), PsiSwitchLabelStatementBase.class)) {
                    if (child.isDefaultCase()) {
                        hasDefault = true;
                        if (!EnumSwitchStatementWhichMissesCasesInspection.this.ignoreSwitchStatementsWithDefault) continue;
                        if (!isOnTheFly) {
                            return;
                        }
                        highlighting = ProblemHighlightType.INFORMATION;
                        continue;
                    }
                    List<PsiEnumConstant> enumConstants = SwitchUtils.findEnumConstants(child);
                    if (enumConstants.isEmpty()) {
                        return;
                    }
                    for (PsiEnumConstant constant : enumConstants) {
                        if (constant.getContainingClass() != aClass) {
                            return;
                        }
                        constants.remove(constant.getName());
                    }
                }
                if (!hasDefault && switchBlock instanceof PsiSwitchExpression) {
                    return;
                }
                if (constants.isEmpty()) {
                    return;
                }
                CommonDataflow.DataflowResult dataflow = CommonDataflow.getDataflowResult(expression2);
                if (dataflow != null) {
                    DfType type2 = dataflow.getDfType(expression2);
                    Set<Object> notValues = type2 instanceof DfAntiConstantType ? ((DfAntiConstantType)type2).getNotValues() : Collections.emptySet();
                    for (Object value2 : notValues) {
                        if (!(value2 instanceof PsiEnumConstant)) continue;
                        constants.remove(((PsiEnumConstant)value2).getName());
                    }
                    Set values = StreamEx.of(dataflow.getExpressionValues(expression2)).select(PsiEnumConstant.class).map(PsiField::getName).toSet();
                    if (!values.isEmpty()) {
                        constants.retainAll(values);
                    }
                }
                if (constants.isEmpty()) {
                    return;
                }
                String message2 = EnumSwitchStatementWhichMissesCasesInspection.buildErrorString(aClass.getQualifiedName(), constants);
                CreateMissingSwitchBranchesFix fix2 = new CreateMissingSwitchBranchesFix(switchBlock, constants);
                if (highlighting == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)EnumSwitchStatementWhichMissesCasesInspection.this.getShortName(), (PsiElement)switchBlock)) {
                    holder.registerProblem((PsiElement)switchBlock, message2, highlighting, new LocalQuickFix[]{fix2});
                } else {
                    int length = switchBlock.getFirstChild().getTextLength();
                    holder.registerProblem((PsiElement)switchBlock, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(0, length), new LocalQuickFix[]{fix2});
                    if (isOnTheFly) {
                        TextRange range = new TextRange(length, switchBlock.getTextLength());
                        holder.registerProblem((PsiElement)switchBlock, message2, ProblemHighlightType.INFORMATION, range, new LocalQuickFix[]{fix2});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switchBlock";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processSwitchBlock";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

