/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ResultSetIndexZeroInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "UseOfIndexZeroInJDBCResultSet";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.resultset.problem.descriptor", new Object[0]);
            if (string == null) {
                ResultSetIndexZeroInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.prepared.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ResultSetIndexZeroInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResultSetIndexZeroVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ResultSetIndexZeroInspection", "buildErrorString"));
    }

    private static class ResultSetIndexZeroVisitor
    extends BaseInspectionVisitor {
        private ResultSetIndexZeroVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            boolean resultSet;
            if (expression2 == null) {
                ResultSetIndexZeroVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            if (methodName.startsWith("get") || methodName.startsWith("update")) {
                resultSet = true;
            } else if (methodName.startsWith("set")) {
                resultSet = false;
            } else {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            Object val = ExpressionUtils.computeConstantExpression(argument);
            if (!(val instanceof Integer) || (Integer)val != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (resultSet) {
                if (TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.sql.ResultSet")) {
                    this.registerError((PsiElement)argument, Boolean.TRUE);
                }
            } else if (arguments.length > 1 && TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.sql.PreparedStatement")) {
                this.registerError((PsiElement)argument, Boolean.FALSE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ResultSetIndexZeroInspection$ResultSetIndexZeroVisitor", "visitMethodCallExpression"));
        }
    }
}

