/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class InconvertibleTypesChecker {
    protected abstract void registerEqualsError(PsiElement var1, @NotNull PsiType var2, @NotNull PsiType var3, boolean var4);

    public void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType leftType, @NotNull PsiType rightType, boolean warnIfNoMutualSubclassFound, boolean onTheFly) {
        PsiElement name2;
        if (expression2 == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(0);
        }
        if (leftType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(1);
        }
        if (rightType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(2);
        }
        if ((name2 = expression2.getReferenceNameElement()) == null) {
            return;
        }
        if (TypeUtils.areConvertible(leftType, rightType) || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            this.deepCheck(leftType, rightType, name2, new HashMap<PsiType, PsiType>(), warnIfNoMutualSubclassFound, onTheFly);
            return;
        }
        this.registerEqualsError(name2, leftType, rightType, false);
    }

    protected void deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, PsiElement highlightLocation, Map<PsiType, PsiType> checked, boolean warnIfNoMutualSubclassFound, boolean onTheFly) {
        PsiType checkedRight;
        if (leftType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(3);
        }
        if (rightType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(4);
        }
        if ((checkedRight = checked.putIfAbsent(leftType, rightType)) != null) {
            if (!checkedRight.equals(rightType)) {
                this.registerEqualsError(highlightLocation, leftType, rightType, false);
            }
            return;
        }
        if (leftType instanceof PsiCapturedWildcardType) {
            leftType = ((PsiCapturedWildcardType)leftType).getUpperBound();
        }
        if (rightType instanceof PsiCapturedWildcardType) {
            rightType = ((PsiCapturedWildcardType)rightType).getUpperBound();
        }
        if (leftType.isAssignableFrom(rightType) || rightType.isAssignableFrom(leftType)) {
            return;
        }
        PsiClass leftClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)leftType);
        PsiClass rightClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rightType);
        if (leftClass == null || rightClass == null) {
            return;
        }
        if (!rightClass.isInterface()) {
            PsiClass tmp = leftClass;
            leftClass = rightClass;
            rightClass = tmp;
        }
        if (leftClass == rightClass || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            PsiType[] rightParameters;
            PsiType[] leftParameters;
            if (leftType instanceof PsiClassType && rightType instanceof PsiClassType && (leftParameters = ((PsiClassType)leftType).getParameters()).length == (rightParameters = ((PsiClassType)rightType).getParameters()).length) {
                int length = leftParameters.length;
                for (int i = 0; i < length; ++i) {
                    PsiType leftParameter = leftParameters[i];
                    PsiType rightParameter = rightParameters[i];
                    if (!TypeUtils.areConvertible(leftParameter, rightParameter) && !TypeUtils.mayBeEqualByContract(leftParameter, rightParameter)) {
                        this.registerEqualsError(highlightLocation, leftType, rightType, false);
                        return;
                    }
                    this.deepCheck(leftParameter, rightParameter, highlightLocation, checked, warnIfNoMutualSubclassFound, onTheFly);
                }
            }
        } else if (TypeUtils.cannotBeEqualByContract(leftType, rightType)) {
            this.registerEqualsError(highlightLocation, leftType, rightType, false);
        } else if (warnIfNoMutualSubclassFound && !InheritanceUtil.existsMutualSubclass(leftClass, rightClass, onTheFly)) {
            this.registerEqualsError(highlightLocation, leftType, rightType, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/InconvertibleTypesChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deepCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

