/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreResultOfCallInspection
extends BaseInspection {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher COLLECTOR_TO_COLLECTION = CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1);
    private static final CallMapper<String> KNOWN_EXCEPTIONAL_SIDE_EFFECTS = new CallMapper<String>().register((CallMatcher)CallMatcher.staticCall("java.util.regex.Pattern", "compile"), "java.util.regex.PatternSyntaxException").register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Integer", "parseInt", "valueOf"), CallMatcher.staticCall("java.lang.Long", "parseLong", "valueOf"), CallMatcher.staticCall("java.lang.Double", "parseDouble", "valueOf"), CallMatcher.staticCall("java.lang.Float", "parseFloat", "valueOf")), "java.lang.NumberFormatException").register((CallMatcher)CallMatcher.instanceCall("java.lang.Class", "getMethod", "getDeclaredMethod", "getConstructor", "getDeclaredConstructor"), "java.lang.NoSuchMethodException").register((CallMatcher)CallMatcher.instanceCall("java.lang.Class", "getField", "getDeclaredField"), "java.lang.NoSuchFieldException");
    private static final Set<String> IGNORE_ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.assertj.core.util.CanIgnoreReturnValue", "com.google.errorprone.annotations.CanIgnoreReturnValue"});
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(true, "callCheckString").add("java.io.File", ".*").add("java.io.InputStream", "read|skip|available|markSupported").add("java.io.Reader", "read|skip|ready|markSupported").add("java.lang.Boolean", ".*").add("java.lang.Byte", ".*").add("java.lang.Character", ".*").add("java.lang.Double", ".*").add("java.lang.Float", ".*").add("java.lang.Integer", ".*").add("java.lang.Long", ".*").add("java.lang.Math", ".*").add("java.lang.Object", "equals|hashCode|toString").add("java.lang.Short", ".*").add("java.lang.StrictMath", ".*").add("java.lang.String", ".*").add("java.lang.Thread", "interrupted").add("java.math.BigInteger", ".*").add("java.math.BigDecimal", ".*").add("java.net.InetAddress", ".*").add("java.net.URI", ".*").add("java.util.Arrays", ".*").add("java.util.List", "of").add("java.util.Set", "of").add("java.util.Map", "of|ofEntries|entry").add("java.util.Collections", "(?!addAll).*").add("java.util.UUID", ".*").add("java.util.regex.Matcher", "pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparentBounds|hasAnchoringBounds|hitEnd|requireEnd").add("java.util.regex.Pattern", ".*").add("java.util.stream.BaseStream", ".*").finishDefault();
    public boolean m_reportAllNonLibraryCalls = false;

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.myMethodMatcher.getClassNames(), this.myMethodMatcher.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("result.of.method.call.ignored.method.column.title", new Object[0])}));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose class", new String[0]);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("result.of.method.call.ignored.non.library.option", new Object[0]), (InspectionProfileEntry)this, "m_reportAllNonLibraryCalls");
        panel2.add((Component)tablePanel, "Center");
        panel2.add((Component)checkBox, "South");
        return panel2;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className2 = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className2);
        if (string == null) {
            IgnoreResultOfCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IgnoreResultOfCallInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IgnoreResultOfCallInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/IgnoreResultOfCallInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/IgnoreResultOfCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement resolve2;
            if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)) && (resolve2 = expression2.resolve()) instanceof PsiMethod) {
                this.visitCalledExpression((PsiExpression)expression2, (PsiMethod)resolve2, null);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
                PsiMethod method = expression2.resolveMethod();
                if (method == null || method.isConstructor()) {
                    return;
                }
                this.visitCalledExpression((PsiExpression)expression2, method, expression2.getParent());
            }
        }

        private void visitCalledExpression(PsiExpression call, PsiMethod method, @Nullable PsiElement errorContainer) {
            if (this.shouldReport(call, method, errorContainer)) {
                this.registerMethodCallOrRefError(call, method.getContainingClass());
            }
        }

        private boolean shouldReport(PsiExpression call, PsiMethod method, @Nullable PsiElement errorContainer) {
            PsiMethod sourceMethod;
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals((Object)returnType) || TypeUtils.typeEquals("java.lang.Void", returnType)) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            if (errorContainer != null && PsiUtilCore.hasErrorElementChild((PsiElement)errorContainer)) {
                return false;
            }
            if (PropertyUtil.isSimpleGetter(method)) {
                return !this.isIgnored(method, null);
            }
            if (method instanceof PsiCompiledElement && (sourceMethod = (PsiMethod)ObjectUtils.tryCast((Object)method.getNavigationElement(), PsiMethod.class)) != null && PropertyUtil.isSimpleGetter(sourceMethod)) {
                return !this.isIgnored(method, null);
            }
            if (IgnoreResultOfCallInspection.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                return !this.isIgnored(method, null);
            }
            if (this.isKnownExceptionalSideEffectCaught(call)) {
                return false;
            }
            if (this.isPureMethod(method, call)) {
                return !this.isIgnored(method, null);
            }
            PsiAnnotation annotation = this.findAnnotationInTree((PsiElement)method, null, Collections.singleton("javax.annotation.CheckReturnValue"));
            if (annotation == null) {
                annotation = this.getAnnotationByShortNameCheckReturnValue(method);
            }
            if (!IgnoreResultOfCallInspection.this.myMethodMatcher.matches(method) && annotation == null) {
                return false;
            }
            if (this.isHardcodedException(call)) {
                return false;
            }
            return !this.isIgnored(method, annotation);
        }

        private boolean isIgnored(@NotNull PsiMethod method, @Nullable PsiAnnotation annotation) {
            if (method == null) {
                IgnoreResultOfCallVisitor.$$$reportNull$$$0(0);
            }
            PsiElement owner2 = annotation == null ? null : (PsiElement)annotation.getOwner();
            return this.findAnnotationInTree((PsiElement)method, owner2, IGNORE_ANNOTATIONS) != null;
        }

        private PsiAnnotation getAnnotationByShortNameCheckReturnValue(PsiMethod method) {
            for (PsiAnnotation psiAnnotation : method.getAnnotations()) {
                String qualifiedName = psiAnnotation.getQualifiedName();
                if (qualifiedName == null || !"CheckReturnValue".equals(StringUtil.getShortName((String)qualifiedName))) continue;
                return psiAnnotation;
            }
            return null;
        }

        private boolean isKnownExceptionalSideEffectCaught(PsiExpression call) {
            String exception = null;
            if (call instanceof PsiMethodCallExpression) {
                exception = (String)KNOWN_EXCEPTIONAL_SIDE_EFFECTS.mapFirst((PsiMethodCallExpression)call);
            } else if (call instanceof PsiMethodReferenceExpression) {
                exception = (String)KNOWN_EXCEPTIONAL_SIDE_EFFECTS.mapFirst((PsiMethodReferenceExpression)call);
            }
            if (exception == null) {
                return false;
            }
            PsiClass exceptionClass = JavaPsiFacade.getInstance((Project)call.getProject()).findClass(exception, call.getResolveScope());
            if (exceptionClass == null) {
                return false;
            }
            PsiTryStatement parentTry = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiTryStatement.class);
            if (parentTry == null || !PsiTreeUtil.isAncestor((PsiElement)parentTry.getTryBlock(), (PsiElement)call, (boolean)true)) {
                return false;
            }
            return ExceptionUtils.getExceptionTypesHandled(parentTry).stream().anyMatch(type2 -> InheritanceUtil.isInheritor((PsiClass)exceptionClass, (String)type2.getCanonicalText()));
        }

        private boolean isHardcodedException(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (STREAM_COLLECT.test(call)) {
                PsiExpression body2;
                PsiLambdaExpression lambda2;
                PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                if (COLLECTOR_TO_COLLECTION.test(collector) && (lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)collector.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class)) != null && (body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()))) instanceof PsiReferenceExpression && ((PsiReferenceExpression)body2).resolve() instanceof PsiVariable) {
                    return true;
                }
            }
            return false;
        }

        private boolean isPureMethod(PsiMethod method, PsiExpression call) {
            boolean honorInferred = Registry.is((String)"ide.ignore.call.result.inspection.honor.inferred.pure");
            if (!honorInferred && !JavaMethodContractUtil.hasExplicitContractAnnotation(method)) {
                return false;
            }
            if (!JavaMethodContractUtil.isPure(method) || this.hasTrivialReturnValue(method)) {
                return false;
            }
            if (!SideEffectChecker.mayHaveExceptionalSideEffect(method)) {
                return true;
            }
            if (!(call instanceof PsiCallExpression) || JavaMethodContractUtil.getMethodCallContracts(method, null).isEmpty()) {
                return false;
            }
            CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(call);
            return result != null && result.cannotFailByContract((PsiCallExpression)call);
        }

        private boolean hasTrivialReturnValue(PsiMethod method) {
            List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
            ContractReturnValue nonFailingReturnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
            return nonFailingReturnValue != null && (nonFailingReturnValue.equals(ContractReturnValue.returnThis()) || nonFailingReturnValue instanceof ContractReturnValue.ParameterReturnValue);
        }

        private void registerMethodCallOrRefError(PsiExpression call, PsiClass aClass) {
            if (call instanceof PsiMethodCallExpression) {
                this.registerMethodCallError((PsiMethodCallExpression)call, aClass);
            } else if (call instanceof PsiMethodReferenceExpression) {
                this.registerError((PsiElement)ObjectUtils.notNull((Object)((PsiMethodReferenceExpression)call).getReferenceNameElement(), (Object)call), aClass);
            }
        }

        @Nullable
        private PsiAnnotation findAnnotationInTree(PsiElement element, @Nullable PsiElement stop, @NotNull Set<String> fqAnnotationNames) {
            if (fqAnnotationNames == null) {
                IgnoreResultOfCallVisitor.$$$reportNull$$$0(1);
            }
            while (element != null) {
                PsiModifierListOwner modifierListOwner;
                PsiAnnotation annotation;
                if (element == stop) {
                    return null;
                }
                if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)(modifierListOwner = (PsiModifierListOwner)element), fqAnnotationNames)) != null) {
                    return annotation;
                }
                if (element instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)element;
                    String packageName = classOwner.getPackageName();
                    PsiPackage aPackage = JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(packageName);
                    if (aPackage == null) {
                        return null;
                    }
                    PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, fqAnnotationNames);
                    if (annotation2 != null) {
                        VirtualFile currentClassRoot;
                        ProjectFileIndex projectFileIndex;
                        VirtualFile annotationClassRoot;
                        VirtualFile annotationFile = PsiUtilCore.getVirtualFile((PsiElement)annotation2);
                        VirtualFile currentFile = classOwner.getVirtualFile();
                        if (annotationFile != null && currentFile != null && !Objects.equals(annotationClassRoot = (projectFileIndex = ProjectFileIndex.getInstance((Project)element.getProject())).getClassRootForFile(annotationFile), currentClassRoot = projectFileIndex.getClassRootForFile(currentFile))) {
                            return null;
                        }
                    }
                    return annotation2;
                }
                element = element.getContext();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqAnnotationNames";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/IgnoreResultOfCallInspection$IgnoreResultOfCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnored";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findAnnotationInTree";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

