/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;

public abstract class ElementPresentation {
    private final Noun myKind;

    protected ElementPresentation(Noun kind2) {
        this.myKind = kind2;
    }

    public static ElementPresentation forElement(PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return new InvalidPresentation();
        }
        if (psiElement instanceof PsiDirectory) {
            return new ForDirectory((PsiDirectory)psiElement);
        }
        if (psiElement instanceof PsiFile) {
            return new ForFile((PsiFile)psiElement);
        }
        if (psiElement instanceof PsiPackage) {
            return new ForPackage((PsiPackage)psiElement);
        }
        if (psiElement instanceof XmlTag) {
            return new ForXmlTag((XmlTag)psiElement);
        }
        if (psiElement instanceof PsiAnonymousClass) {
            return new ForAnonymousClass((PsiAnonymousClass)psiElement);
        }
        if (psiElement instanceof PsiClass) {
            return new ForClass((PsiClass)psiElement);
        }
        if (psiElement instanceof PsiMethod) {
            return new ForMethod((PsiMethod)psiElement);
        }
        if (psiElement instanceof PsiField) {
            return new ForField((PsiField)psiElement);
        }
        return new ForGeneralElement(psiElement);
    }

    public static ElementPresentation forVirtualFile(VirtualFile file) {
        return new ForVirtualFile(file);
    }

    private static boolean validNotNull(VirtualFile virtualFile) {
        return virtualFile != null && virtualFile.isValid();
    }

    public abstract String getQualifiedName();

    public Noun getKind() {
        return this.myKind;
    }

    public abstract String getName();

    public abstract String getComment();

    public String getNameWithFQComment() {
        String comment = this.getComment();
        String result = this.getName();
        if (comment.trim().length() == 0) {
            return result;
        }
        return result + " (" + comment + ")";
    }

    private static class ForVirtualFile
    extends ElementPresentation {
        private final VirtualFile myFile;

        ForVirtualFile(VirtualFile file) {
            super(file.isDirectory() ? Noun.DIRECTORY : Noun.FILE);
            this.myFile = file;
        }

        @Override
        public String getComment() {
            String name2 = this.myFile.getName();
            if (!this.myFile.isValid()) {
                return name2;
            }
            VirtualFile parent = this.myFile.getParent();
            if (parent == null) {
                return name2;
            }
            return parent.getPresentableUrl();
        }

        @Override
        public String getName() {
            return this.myFile.getName();
        }

        @Override
        public String getQualifiedName() {
            if (!this.myFile.isValid()) {
                return this.myFile.getName();
            }
            return this.myFile.getPresentableUrl();
        }
    }

    private static class ForXmlTag
    extends ElementPresentation {
        private final XmlTag myXmlTag;

        ForXmlTag(XmlTag xmlTag) {
            super(Noun.XML_TAG);
            this.myXmlTag = xmlTag;
        }

        @Override
        public String getQualifiedName() {
            return "<" + this.myXmlTag.getLocalName() + ">";
        }

        @Override
        public String getName() {
            return this.getQualifiedName();
        }

        @Override
        public String getComment() {
            return "";
        }
    }

    private static class ForGeneralElement
    extends ElementPresentation {
        private final PsiElement myPsiElement;

        ForGeneralElement(PsiElement psiElement) {
            super(Noun.FRAGMENT);
            this.myPsiElement = psiElement;
        }

        @Override
        public String getQualifiedName() {
            PsiFile containingFile = this.myPsiElement.getContainingFile();
            if (containingFile != null) {
                return PsiBundle.message((String)"code.from.context.display", (Object[])new Object[]{ForGeneralElement.forElement((PsiElement)containingFile).getQualifiedName()});
            }
            return PsiBundle.message((String)"code.display", (Object[])new Object[0]);
        }

        @Override
        public String getName() {
            return this.getQualifiedName();
        }

        @Override
        public String getComment() {
            return "";
        }
    }

    private static class ForField
    extends ElementPresentation {
        private final PsiField myPsiField;

        ForField(PsiField psiField) {
            super(Noun.FIELD);
            this.myPsiField = psiField;
        }

        @Override
        public String getQualifiedName() {
            PsiClass psiClass = this.myPsiField.getContainingClass();
            String name2 = this.myPsiField.getName();
            if (psiClass != null) {
                return ForField.forElement((PsiElement)psiClass).getQualifiedName() + "." + name2;
            }
            return name2;
        }

        @Override
        public String getName() {
            PsiClass psiClass = this.myPsiField.getContainingClass();
            String name2 = this.myPsiField.getName();
            if (psiClass == null) {
                return name2;
            }
            return ForField.forElement((PsiElement)psiClass).getName() + "." + name2;
        }

        @Override
        public String getComment() {
            PsiClass psiClass = this.myPsiField.getContainingClass();
            if (psiClass == null) {
                return "";
            }
            return ForField.forElement((PsiElement)psiClass).getComment();
        }
    }

    private static class ForMethod
    extends ElementPresentation {
        private static final int FQ_OPTIONS = 6401;
        private static final int NAME_OPTIONS = 4353;
        private final PsiMethod myPsiMethod;

        ForMethod(PsiMethod psiMethod) {
            super(Noun.METHOD);
            this.myPsiMethod = psiMethod;
        }

        @Override
        public String getQualifiedName() {
            return PsiFormatUtil.formatMethod((PsiMethod)this.myPsiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6401, (int)2);
        }

        @Override
        public String getName() {
            return PsiFormatUtil.formatMethod((PsiMethod)this.myPsiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
        }

        @Override
        public String getComment() {
            PsiClass containingClass = this.myPsiMethod.getContainingClass();
            if (containingClass == null) {
                return "";
            }
            return ForMethod.forElement((PsiElement)containingClass).getComment();
        }
    }

    private static class ForClass
    extends ElementPresentation {
        private static final Logger LOG = Logger.getInstance(ForClass.class);
        private final PsiClass myPsiClass;

        ForClass(PsiClass psiClass) {
            super(Noun.CLASS);
            this.myPsiClass = psiClass;
        }

        @Override
        public String getQualifiedName() {
            return this.myPsiClass.getQualifiedName();
        }

        @Override
        public String getName() {
            return this.myPsiClass.getName();
        }

        @Override
        public String getComment() {
            PsiFile file = this.myPsiClass.getContainingFile();
            PsiDirectory dir = file.getContainingDirectory();
            if (dir == null) {
                LOG.info("psiClass: " + this.myPsiClass + "; in file: " + file);
                return "";
            }
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(dir);
            if (psiPackage == null) {
                return "";
            }
            return ForClass.forElement((PsiElement)psiPackage).getQualifiedName();
        }
    }

    private static class ForAnonymousClass
    extends ElementPresentation {
        private final PsiAnonymousClass myPsiAnonymousClass;

        ForAnonymousClass(PsiAnonymousClass psiAnonymousClass) {
            super(Noun.FRAGMENT);
            this.myPsiAnonymousClass = psiAnonymousClass;
        }

        @Override
        public String getQualifiedName() {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myPsiAnonymousClass, PsiClass.class);
            if (psiClass != null) {
                return JavaPsiBundle.message((String)"anonymous.class.context.display", (Object[])new Object[]{ForAnonymousClass.forElement((PsiElement)psiClass).getQualifiedName()});
            }
            return PsiBundle.message((String)"anonymous.class.display", (Object[])new Object[0]);
        }

        @Override
        public String getName() {
            return this.getQualifiedName();
        }

        @Override
        public String getComment() {
            return "";
        }
    }

    public static class ForPackage
    extends ElementPresentation {
        private final PsiPackage myPsiPackage;

        public ForPackage(PsiPackage psiPackage) {
            super(Noun.PACKAGE);
            this.myPsiPackage = psiPackage;
        }

        @Override
        public String getQualifiedName() {
            String qualifiedName = this.myPsiPackage.getQualifiedName();
            if (qualifiedName.length() == 0) {
                return PsiBundle.message((String)"default.package.presentation", (Object[])new Object[0]);
            }
            return qualifiedName;
        }

        @Override
        public String getName() {
            return this.getQualifiedName();
        }

        @Override
        public String getComment() {
            return "";
        }
    }

    private static class ForFile
    extends ElementPresentation {
        private final PsiFile myFile;

        ForFile(PsiFile file) {
            super(Noun.FILE);
            this.myFile = file;
        }

        @Override
        public String getQualifiedName() {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            if (ElementPresentation.validNotNull(virtualFile)) {
                return virtualFile.getPresentableUrl();
            }
            return this.myFile.getName();
        }

        @Override
        public String getName() {
            return this.myFile.getName();
        }

        @Override
        public String getComment() {
            PsiDirectory directory = this.myFile.getContainingDirectory();
            if (directory == null) {
                return "";
            }
            return ElementPresentation.forElement((PsiElement)directory).getQualifiedName();
        }
    }

    private static class ForDirectory
    extends ElementPresentation {
        private final PsiDirectory myPsiDirectory;

        ForDirectory(PsiDirectory psiDirectory) {
            super(Noun.DIRECTORY);
            this.myPsiDirectory = psiDirectory;
        }

        @Override
        public String getQualifiedName() {
            VirtualFile virtualFile = this.myPsiDirectory.getVirtualFile();
            if (ElementPresentation.validNotNull(virtualFile)) {
                return virtualFile.getPresentableUrl();
            }
            return this.myPsiDirectory.getName();
        }

        @Override
        public String getName() {
            return this.myPsiDirectory.getName();
        }

        @Override
        public String getComment() {
            PsiDirectory parentDirectory = this.myPsiDirectory.getParentDirectory();
            if (parentDirectory == null) {
                return "";
            }
            return ElementPresentation.forElement((PsiElement)parentDirectory).getQualifiedName();
        }
    }

    private static class InvalidPresentation
    extends ElementPresentation {
        InvalidPresentation() {
            super(new Noun(-1));
        }

        @Override
        public String getComment() {
            return "";
        }

        @Override
        public String getName() {
            return "INVALID";
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }
    }

    public static class Noun {
        private final int myTypeNum;
        public static final Noun DIRECTORY = new Noun(0);
        public static final Noun PACKAGE = new Noun(1);
        public static final Noun FILE = new Noun(2);
        public static final Noun CLASS = new Noun(3);
        public static final Noun METHOD = new Noun(4);
        public static final Noun FIELD = new Noun(5);
        public static final Noun FRAGMENT = new Noun(6);
        public static final Noun XML_TAG = new Noun(7);

        public Noun(int typeNum) {
            this.myTypeNum = typeNum;
        }

        public int getTypeNum() {
            return this.myTypeNum;
        }
    }
}

