/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.ThreadOperation;
import com.intellij.unscramble.ThreadState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadDumpParser {
    private static final Pattern ourThreadStartPattern = Pattern.compile("^\"(.+)\".+(prio=\\d+ (?:os_prio=[^\\s]+ )?.*tid=[^\\s]+ nid=[^\\s]+|[Ii][Dd]=\\d+) ([^\\[]+)");
    private static final Pattern ourForcedThreadStartPattern = Pattern.compile("^Thread (\\d+): \\(state = (.+)\\)");
    private static final Pattern ourYourkitThreadStartPattern = Pattern.compile("(.+) \\[([A-Z_, ]*)]");
    private static final Pattern ourYourkitThreadStartPattern2 = Pattern.compile("(.+) (?:State:)? (.+) CPU usage on sample: .+");
    private static final Pattern ourThreadStatePattern = Pattern.compile("java\\.lang\\.Thread\\.State: (.+) \\((.+)\\)");
    private static final Pattern ourThreadStatePattern2 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+)");
    private static final Pattern ourWaitingForLockPattern = Pattern.compile("- waiting (on|to lock) <(.+)>");
    private static final Pattern ourParkingToWaitForLockPattern = Pattern.compile("- parking to wait for {2}<(.+)>");
    @NonNls
    private static final String PUMP_EVENT = "java.awt.EventDispatchThread.pumpOneEventForFilters";
    private static final Pattern ourIdleTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at java\\.util\\.TimerThread\\.mainLoop");
    private static final Pattern ourIdleSwingTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at javax\\.swing\\.TimerQueue\\.run");
    private static final String AT_JAVA_LANG_OBJECT_WAIT = "at java.lang.Object.wait(";

    private ThreadDumpParser() {
    }

    @NotNull
    public static List<ThreadState> parse(String threadDump) {
        String line;
        ArrayList<ThreadState> result = new ArrayList<ThreadState>();
        StringBuilder lastThreadStack = new StringBuilder();
        ThreadState lastThreadState = null;
        boolean expectingThreadState = false;
        boolean haveNonEmptyStackTrace = false;
        Iterator<Object> iterator = StringUtil.tokenize((String)threadDump, (String)"\r\n").iterator();
        while (iterator.hasNext() && !(line = (String)iterator.next()).startsWith("============") && !line.contains("Java-level deadlock")) {
            ThreadState state = ThreadDumpParser.tryParseThreadStart(line.trim());
            if (state != null) {
                if (lastThreadState != null) {
                    lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
                }
                lastThreadState = state;
                result.add(lastThreadState);
                lastThreadStack.setLength(0);
                haveNonEmptyStackTrace = false;
                lastThreadStack.append(line).append("\n");
                expectingThreadState = true;
                continue;
            }
            boolean parsedThreadState = false;
            if (expectingThreadState) {
                expectingThreadState = false;
                parsedThreadState = ThreadDumpParser.tryParseThreadState(line, lastThreadState);
            }
            lastThreadStack.append(line).append("\n");
            if (parsedThreadState || !line.trim().startsWith("at")) continue;
            haveNonEmptyStackTrace = true;
        }
        if (lastThreadState != null) {
            lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
        }
        for (ThreadState threadState : result) {
            ThreadDumpParser.inferThreadStateDetail(threadState);
            String lockId = ThreadDumpParser.findWaitingForLock(threadState.getStackTrace());
            ThreadState lockOwner = ThreadDumpParser.findLockOwner(result, lockId, true);
            if (lockOwner == null) {
                lockOwner = ThreadDumpParser.findLockOwner(result, lockId, false);
            }
            if (lockOwner == null) continue;
            if (threadState.isAwaitedBy(lockOwner)) {
                threadState.addDeadlockedThread(lockOwner);
                lockOwner.addDeadlockedThread(threadState);
            }
            lockOwner.addWaitingThread(threadState);
        }
        ThreadDumpParser.sortThreads(result);
        ArrayList<ThreadState> arrayList = result;
        if (arrayList == null) {
            ThreadDumpParser.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    private static ThreadState findLockOwner(List<? extends ThreadState> result, @Nullable String lockId, boolean ignoreWaiting) {
        if (lockId == null) {
            return null;
        }
        String marker = "- locked <" + lockId + ">";
        for (ThreadState threadState : result) {
            String trace = threadState.getStackTrace();
            if (!trace.contains(marker) || ignoreWaiting && trace.contains(AT_JAVA_LANG_OBJECT_WAIT)) continue;
            return threadState;
        }
        return null;
    }

    public static void sortThreads(List<? extends ThreadState> result) {
        Collections.sort(result, (o1, o2) -> ThreadDumpParser.getInterestLevel(o2) - ThreadDumpParser.getInterestLevel(o1));
    }

    @Nullable
    private static String findWaitingForLock(String stackTrace) {
        Matcher m = ourWaitingForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(2);
        }
        m = ourParkingToWaitForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static int getInterestLevel(ThreadState state) {
        if (state.isEmptyStackTrace()) {
            return -10;
        }
        if (state.isKnownJDKThread()) {
            return -5;
        }
        if (state.isSleeping()) {
            return -2;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return -1;
        }
        return state.getStackDepth();
    }

    static boolean isKnownJdkThread(@NotNull String stackTrace) {
        if (stackTrace == null) {
            ThreadDumpParser.$$$reportNull$$$0(1);
        }
        return stackTrace.contains("java.lang.ref.Reference$ReferenceHandler.run") || stackTrace.contains("java.lang.ref.Finalizer$FinalizerThread.run") || stackTrace.contains("sun.awt.AWTAutoShutdown.run") || stackTrace.contains("sun.java2d.Disposer.run") || stackTrace.contains("sun.awt.windows.WToolkit.eventLoop") || ourIdleTimerThreadPattern.matcher(stackTrace).find() || ourIdleSwingTimerThreadPattern.matcher(stackTrace).find();
    }

    public static void inferThreadStateDetail(ThreadState threadState) {
        String stackTrace = threadState.getStackTrace();
        if (stackTrace.contains("at java.net.PlainSocketImpl.socketAccept") || stackTrace.contains("at java.net.PlainDatagramSocketImpl.receive") || stackTrace.contains("at java.net.SocketInputStream.socketRead") || stackTrace.contains("at java.net.PlainSocketImpl.socketConnect")) {
            threadState.setOperation(ThreadOperation.Socket);
        } else if (stackTrace.contains("at java.io.FileInputStream.readBytes")) {
            threadState.setOperation(ThreadOperation.IO);
        } else if (stackTrace.contains("at java.lang.Thread.sleep")) {
            String javaThreadState = threadState.getJavaThreadState();
            if (!Thread.State.RUNNABLE.name().equals(javaThreadState)) {
                threadState.setThreadStateDetail("sleeping");
            }
        }
        if (threadState.isEDT()) {
            if (stackTrace.contains("java.awt.EventQueue.getNextEvent")) {
                threadState.setThreadStateDetail("idle");
            }
            int modality = 0;
            int pos = 0;
            while ((pos = stackTrace.indexOf(PUMP_EVENT, pos)) >= 0) {
                ++modality;
                pos += PUMP_EVENT.length();
            }
            threadState.setExtraState("modality level " + modality);
        }
    }

    @Nullable
    private static ThreadState tryParseThreadStart(String line) {
        Matcher m = ourThreadStartPattern.matcher(line);
        if (m.find()) {
            ThreadState state = new ThreadState(m.group(1), m.group(3));
            if (line.contains(" daemon ")) {
                state.setDaemon(true);
            }
            return state;
        }
        m = ourForcedThreadStartPattern.matcher(line);
        if (m.matches()) {
            return new ThreadState(m.group(1), m.group(2));
        }
        boolean daemon = line.contains(" [DAEMON]");
        if (daemon) {
            line = StringUtil.replace((String)line, (String)" [DAEMON]", (String)"");
        }
        if ((m = ThreadDumpParser.matchYourKit(line)) != null) {
            ThreadState state = new ThreadState(m.group(1), m.group(2));
            state.setDaemon(daemon);
            return state;
        }
        return null;
    }

    @Nullable
    private static Matcher matchYourKit(String line) {
        Matcher m;
        if (line.contains("[") && (m = ourYourkitThreadStartPattern.matcher(line)).matches()) {
            return m;
        }
        if (line.contains("CPU usage on sample:") && (m = ourYourkitThreadStartPattern2.matcher(line)).matches()) {
            return m;
        }
        return null;
    }

    private static boolean tryParseThreadState(String line, ThreadState threadState) {
        Matcher m = ourThreadStatePattern.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            threadState.setThreadStateDetail(m.group(2).trim());
            return true;
        }
        m = ourThreadStatePattern2.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/unscramble/ThreadDumpParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/unscramble/ThreadDumpParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownJdkThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

