/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.HierarchyNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SingleNodeIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMatchingVisitor
extends JavaElementVisitor {
    public static final String[] MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "strictfp", "transient", "volatile", "default"};
    private final GlobalMatchingVisitor myMatchingVisitor;
    private PsiClass myClazz;

    public JavaMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(0);
        }
        PsiComment other = null;
        if (!(this.myMatchingVisitor.getElement() instanceof PsiComment)) {
            if (this.myMatchingVisitor.getElement() instanceof PsiMember) {
                other = (PsiComment)ObjectUtils.tryCast((Object)this.myMatchingVisitor.getElement().getFirstChild(), PsiComment.class);
            }
        } else {
            other = (PsiComment)this.myMatchingVisitor.getElement();
        }
        if (!this.myMatchingVisitor.setResult(other != null)) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)comment.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            IElementType tokenType = other.getTokenType();
            int length = other.getTextLength();
            int start = tokenType == JavaDocTokenType.DOC_COMMENT_START ? 3 : 2;
            int end = tokenType == JavaTokenType.END_OF_LINE_COMMENT || length < 4 ? length : length - 2;
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            RegExpPredicate predicate = substitutionHandler.findRegExpPredicate();
            if (predicate != null) {
                predicate.setNodeTextGenerator(e -> JavaMatchUtil.getCommentText((PsiComment)e).trim());
                this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)other, this.myMatchingVisitor.getMatchContext()));
            } else {
                this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)other, start, end, this.myMatchingVisitor.getMatchContext()));
            }
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)comment, (PsiElement)other, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize((String)JavaMatchUtil.getCommentText(comment)), StructuralSearchUtil.normalize((String)JavaMatchUtil.getCommentText(other))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitModifierList(PsiModifierList list) {
        PsiModifierList other = (PsiModifierList)this.myMatchingVisitor.getElement();
        for (String modifier : MODIFIERS) {
            if (this.myMatchingVisitor.setResult(!list.hasModifierProperty(modifier) || other.hasModifierProperty(modifier))) continue;
            return;
        }
        Object[] annotations = list.getAnnotations();
        if (annotations.length > 0) {
            Set annotationSet = ContainerUtil.set((Object[])annotations);
            for (Object annotation : annotations) {
                PsiNameValuePair[] attributes;
                PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
                if (nameReferenceElement == null || !"Modifier".equals(nameReferenceElement.getText())) continue;
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                for (PsiNameValuePair pair2 : attributes = parameterList.getAttributes()) {
                    PsiAnnotationMemberValue value2 = pair2.getValue();
                    if (value2 == null) continue;
                    if (value2 instanceof PsiArrayInitializerMemberValue) {
                        boolean matchedOne = false;
                        for (PsiAnnotationMemberValue v : ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                            if (!JavaMatchingVisitor.annotationValueMatchesModifierList(other, v)) continue;
                            matchedOne = true;
                            break;
                        }
                        if (this.myMatchingVisitor.setResult(matchedOne)) continue;
                        return;
                    }
                    if (this.myMatchingVisitor.setResult(JavaMatchingVisitor.annotationValueMatchesModifierList(other, value2))) continue;
                    return;
                }
                annotationSet.remove(annotation);
            }
            if (!annotationSet.isEmpty()) {
                Object[] otherAnnotations = other.getAnnotations();
                SmartList unmatchedElements = new SmartList(otherAnnotations);
                this.myMatchingVisitor.getMatchContext().pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitModifierList$1((List)unmatchedElements, arg_0));
                try {
                    this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotationSet.toArray(PsiAnnotation.EMPTY_ARRAY), (PsiElement[])otherAnnotations));
                    other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
                }
                finally {
                    this.myMatchingVisitor.getMatchContext().popMatchedElementsListener();
                }
            }
        }
    }

    private static boolean annotationValueMatchesModifierList(PsiModifierList list, PsiAnnotationMemberValue value2) {
        String name2 = StringUtil.unquoteString((String)value2.getText());
        if ("Instance".equals(name2)) {
            return !list.hasModifierProperty("static") && !list.hasModifierProperty("abstract") && list.getParent() instanceof PsiMember;
        }
        return list.hasModifierProperty(name2) && (!"packageLocal".equals(name2) || list.getParent() instanceof PsiMember);
    }

    public void visitDocTag(PsiDocTag tag) {
        PsiDocTag other = (PsiDocTag)this.myMatchingVisitor.getElement();
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern.isTypedVar(tag.getNameElement());
        if (!isTypedVar && !this.myMatchingVisitor.setResult(tag.getName().equals(other.getName()))) {
            return;
        }
        PsiDocTagValue psiDocTagValue = tag.getValueElement();
        boolean isTypedValue = false;
        if (psiDocTagValue != null) {
            PsiElement[] children = psiDocTagValue.getChildren();
            if (children.length == 1) {
                psiDocTagValue = children[0];
            }
            if ((isTypedValue = pattern.isTypedVar((PsiElement)psiDocTagValue)) && (other.getValueElement() != null ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)psiDocTagValue, (PsiElement)other.getValueElement())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.allowsAbsenceOfMatch((PsiElement)psiDocTagValue)))) {
                return;
            }
        }
        if (!isTypedValue && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((NodeIterator)new DocValuesIterator(tag.getFirstChild()), (NodeIterator)new DocValuesIterator(other.getFirstChild())))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(tag.getNameElement(), other.getNameElement()));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        PsiDocTag[] tags;
        PsiDocComment other;
        if (this.myMatchingVisitor.getElement() instanceof PsiDocCommentOwner) {
            other = ((PsiDocCommentOwner)this.myMatchingVisitor.getElement()).getDocComment();
            if (!this.myMatchingVisitor.setResult(other != null)) {
                return;
            }
        } else {
            other = (PsiDocComment)this.myMatchingVisitor.getElement();
            if (!this.myMatchingVisitor.setResult(!(this.myMatchingVisitor.getElement().getParent() instanceof PsiDocCommentOwner))) {
                return;
            }
        }
        if ((tags = comment.getTags()).length > 0 && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tags, (PsiElement[])other.getTags()))) {
            return;
        }
        this.visitComment((PsiComment)comment);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(1);
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(element, this.myMatchingVisitor.getElement()));
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiArrayInitializerExpression other = this.getExpression(PsiArrayInitializerExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression2.getInitializers(), (PsiElement[])other.getInitializers()));
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        PsiClassInitializer other = (PsiClassInitializer)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)initializer.getModifierList(), (PsiElement)other.getModifierList()) && this.myMatchingVisitor.matchSons((PsiElement)initializer.getBody(), (PsiElement)other.getBody()));
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)block, this.myMatchingVisitor.getElement()));
    }

    public void visitJavaToken(PsiJavaToken token) {
        PsiElement other = this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult((!(other instanceof PsiJavaToken) || token.getTokenType() == ((PsiJavaToken)other).getTokenType()) && (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)token) ? this.myMatchingVisitor.handleTypedElement((PsiElement)token, other) : this.myMatchingVisitor.matchText((PsiElement)token, other)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAnnotation(PsiAnnotation annotation) {
        PsiAnnotation other = (PsiAnnotation)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)annotation.getNameReferenceElement(), (PsiElement)other.getNameReferenceElement()))) {
            return;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length == 0) {
            return;
        }
        Object[] otherAttributes = other.getParameterList().getAttributes();
        SmartList unmatchedElements = new SmartList(otherAttributes);
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitAnnotation$2((List)unmatchedElements, arg_0));
        try {
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])attributes, (PsiElement[])otherAttributes)) && !unmatchedElements.isEmpty()) {
                other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
        finally {
            context.popMatchedElementsListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitNameValuePair(PsiNameValuePair pair2) {
        PsiNameValuePair other = (PsiNameValuePair)this.myMatchingVisitor.getElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        PsiIdentifier nameIdentifier = pair2.getNameIdentifier();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
        if (nameIdentifier != null) {
            context.pushResult();
        }
        PsiIdentifier otherIdentifier = other.getNameIdentifier();
        try {
            PsiAnnotationMemberValue value2 = pair2.getValue();
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)value2, (PsiElement)other.getValue()))) {
                if (nameIdentifier != null) {
                    this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText(nameIdentifier.getText(), otherIdentifier == null ? "value" : otherIdentifier.getText()));
                } else {
                    this.myMatchingVisitor.setResult(otherIdentifier == null || "value".equals(otherIdentifier.getText()));
                }
            }
        }
        finally {
            PsiIdentifier matchNode;
            if (otherIdentifier != null) {
                matchNode = otherIdentifier;
            } else {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                PsiAnnotation annotation = (PsiAnnotation)factory.createStatementFromText("@Anno(value=\"\")", (PsiElement)other).getFirstChild().getFirstChild();
                matchNode = annotation.getParameterList().getAttributes()[0].getNameIdentifier();
            }
            if (nameIdentifier != null) {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)matchNode);
            }
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiArrayInitializerMemberValue otherInitializer = (PsiArrayInitializerMemberValue)this.myMatchingVisitor.getElement();
        PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])initializers, (PsiElement[])otherInitializer.getInitializers()));
    }

    private boolean checkHierarchy(PsiMember element, PsiMember patternElement) {
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)patternElement);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            if (!substitutionHandler.isSubtype()) {
                if (substitutionHandler.isStrictSubtype()) {
                    return element.getContainingClass() != this.myClazz;
                }
            } else {
                return true;
            }
        }
        return this.myClazz == null || element.getContainingClass() == this.myClazz;
    }

    public void visitField(PsiField field) {
        PsiField other = this.getElement(PsiField.class);
        if (other == null) {
            return;
        }
        PsiDocComment comment = field.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)field))) {
            return;
        }
        super.visitField(field);
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        PsiEnumConstant other = this.getElement(PsiEnumConstant.class);
        if (other == null) {
            return;
        }
        PsiExpressionList argumentList = enumConstant.getArgumentList();
        if (argumentList != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)argumentList, (PsiElement)other.getArgumentList()))) {
            return;
        }
        PsiEnumConstantInitializer enumConstantInitializer = enumConstant.getInitializingClass();
        if (enumConstantInitializer != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)enumConstantInitializer, (PsiElement)other.getInitializingClass()))) {
            return;
        }
        super.visitEnumConstant(enumConstant);
    }

    public void visitAnonymousClass(PsiAnonymousClass clazz) {
        PsiAnonymousClass other = this.getElement(PsiAnonymousClass.class);
        if (other == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = clazz.getBaseClassReference();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)classReference2);
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.match((PsiElement)clazz.getBaseClassReference(), (PsiElement)other.getBaseClassReference())) && this.myMatchingVisitor.matchSons((PsiElement)clazz.getArgumentList(), (PsiElement)other.getArgumentList()) && this.matchClasses((PsiClass)clazz, (PsiClass)other)) && isTypedVar) {
            this.myMatchingVisitor.setResult(classReference2 instanceof LightElement || this.matchType((PsiElement)classReference2, (PsiElement)other.getBaseClassReference()));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiLambdaExpression other = this.getExpression(PsiLambdaExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        PsiParameterList parameterList1 = expression2.getParameterList();
        if (!this.myMatchingVisitor.setResult(parameterList1.isEmpty() || this.myMatchingVisitor.matchSons((PsiElement)parameterList1, (PsiElement)other.getParameterList()))) {
            return;
        }
        PsiElement body1 = JavaMatchingVisitor.getElementToMatch(expression2.getBody());
        if (body1 == null) {
            return;
        }
        PsiElement body2 = JavaMatchingVisitor.getElementToMatch(other.getBody());
        if (body1 instanceof PsiExpression && body2 instanceof PsiStatement) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(body1.getParent(), body2));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(body1, body2));
        }
    }

    private static PsiElement getElementToMatch(PsiElement element) {
        if (element instanceof PsiCodeBlock) {
            List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
            if (list.isEmpty()) {
                return null;
            }
            element = (PsiElement)list.get(0);
            if (list.size() > 1) {
                return element;
            }
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiReturnStatement) {
            element = ((PsiReturnStatement)element).getReturnValue();
        }
        return element;
    }

    private boolean matchInAnyOrder(PsiReferenceList patternElements, PsiReferenceList matchElements) {
        if (patternElements == null) {
            return this.myMatchingVisitor.isLeftLooseMatching() || matchElements == null;
        }
        return this.myMatchingVisitor.matchInAnyOrder((PsiElement[])patternElements.getReferenceElements(), (PsiElement[])(matchElements != null ? matchElements.getReferenceElements() : PsiElement.EMPTY_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchClasses(PsiClass patternClass, PsiClass matchClass) {
        PsiClass saveClazz = this.myClazz;
        this.myClazz = matchClass;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        JavaCompiledPattern javaPattern = (JavaCompiledPattern)context.getPattern();
        THashSet matchedElements = new THashSet();
        context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$matchClasses$3((Set)matchedElements, arg_0));
        try {
            PsiClassInitializer[] initializers2;
            PsiClassInitializer[] initializers;
            PsiClass[] nestedClasses;
            PsiMethod[] methods;
            PsiField[] fields;
            boolean accepted;
            boolean templateIsInterface = patternClass.isInterface();
            if (templateIsInterface && !matchClass.isInterface()) {
                boolean bl = false;
                return bl;
            }
            if (templateIsInterface && patternClass.isAnnotationType() && !matchClass.isAnnotationType()) {
                boolean bl = false;
                return bl;
            }
            if (patternClass.isEnum() && !matchClass.isEnum()) {
                boolean bl = false;
                return bl;
            }
            if (patternClass instanceof PsiTypeParameter != matchClass instanceof PsiTypeParameter) {
                boolean bl = false;
                return bl;
            }
            if (!this.matchInAnyOrder(patternClass.getExtendsList(), matchClass.getExtendsList())) {
                boolean bl = false;
                return bl;
            }
            PsiReferenceList implementsList = patternClass.getImplementsList();
            if (implementsList != null && !this.matchInAnyOrder(implementsList, matchClass.getImplementsList())) {
                PsiReferenceList anotherExtendsList = matchClass.getExtendsList();
                PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
                accepted = false;
                if (referenceElements.length > 0 && anotherExtendsList != null) {
                    HierarchyNodeIterator iterator = new HierarchyNodeIterator((PsiElement)matchClass, true, true, false);
                    accepted = this.myMatchingVisitor.matchInAnyOrder((NodeIterator)new ArrayBackedNodeIterator((PsiElement[])referenceElements), (NodeIterator)iterator);
                }
                if (!accepted) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((fields = (PsiField[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiField.class)) != null) {
                PsiField[] fields2;
                PsiField[] psiFieldArray = fields2 = javaPattern.isRequestsSuperFields() ? matchClass.getAllFields() : matchClass.getFields();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])fields, (PsiElement[])fields2)) {
                    accepted = false;
                    return accepted;
                }
            }
            if ((methods = (PsiMethod[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiMethod.class)) != null) {
                PsiMethod[] methods2;
                PsiMethod[] psiMethodArray = methods2 = javaPattern.isRequestsSuperMethods() ? matchClass.getAllMethods() : matchClass.getMethods();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])methods, (PsiElement[])methods2)) {
                    boolean iterator = false;
                    return iterator;
                }
            }
            if ((nestedClasses = (PsiClass[])PsiTreeUtil.getChildrenOfType((PsiElement)patternClass, PsiClass.class)) != null) {
                PsiClass[] nestedClasses2;
                PsiClass[] psiClassArray = nestedClasses2 = javaPattern.isRequestsSuperInners() ? matchClass.getAllInnerClasses() : matchClass.getInnerClasses();
                if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])nestedClasses, (PsiElement[])nestedClasses2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if ((initializers = patternClass.getInitializers()).length > 0 && !this.myMatchingVisitor.matchInAnyOrder((PsiElement[])initializers, (PsiElement[])(initializers2 = matchClass.getInitializers()))) {
                boolean bl = false;
                return bl;
            }
            SmartList unmatchedElements = new SmartList((Collection)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)matchClass, PsiMember.class));
            unmatchedElements.removeAll((Collection<?>)matchedElements);
            MatchingHandler unmatchedSubstitutionHandler = null;
            for (PsiElement element = patternClass.getLBrace(); element != null; element = element.getNextSibling()) {
                if (!(element instanceof PsiTypeElement) || !(element.getNextSibling() instanceof PsiErrorElement)) continue;
                unmatchedSubstitutionHandler = javaPattern.getHandler(element);
                break;
            }
            if (unmatchedSubstitutionHandler instanceof SubstitutionHandler) {
                SubstitutionHandler handler = (SubstitutionHandler)unmatchedSubstitutionHandler;
                for (PsiElement element : unmatchedElements) {
                    handler.handle(element, context);
                }
            } else {
                matchClass.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.myClazz = saveClazz;
            context.popMatchedElementsListener();
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (matchElement instanceof PsiBlockStatement) {
                PsiCodeBlock codeBlock = ((PsiBlockStatement)matchElement).getCodeBlock();
                if (patternElement instanceof PsiBlockStatement || codeBlock.getStatementCount() == 1) {
                    matchElement = codeBlock.getFirstChild();
                }
            }
            if (patternElement instanceof PsiBlockStatement) {
                patternElement = ((PsiBlockStatement)patternElement).getCodeBlock().getFirstChild();
            }
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        PsiArrayAccessExpression other = this.getExpression(PsiArrayAccessExpression.class, (PsiExpression)expression2);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getArrayExpression(), (PsiElement)other.getArrayExpression()) && this.myMatchingVisitor.match((PsiElement)expression2.getIndexExpression(), (PsiElement)other.getIndexExpression()));
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        if (this.getExpression(PsiMethodReferenceExpression.class, (PsiExpression)expression2) == null) {
            return;
        }
        super.visitMethodReferenceExpression(expression2);
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        PsiElement target;
        boolean multiMatch;
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        MatchingHandler _handler = pattern.getHandlerSimple(reference.getReferenceNameElement());
        boolean special = false;
        if (_handler == null) {
            _handler = pattern.getHandlerSimple((PsiElement)reference);
            special = reference.resolve() != null;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiExpression qualifier = reference.getQualifierExpression();
        if (_handler instanceof SubstitutionHandler && (qualifier == null || special)) {
            SubstitutionHandler handler = (SubstitutionHandler)_handler;
            if (handler.isSubtype() || handler.isStrictSubtype()) {
                if (this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy((PsiElement)reference, other, handler))) {
                    handler.addResult(other, this.myMatchingVisitor.getMatchContext());
                }
            } else {
                PsiElement deparenthesized;
                Object object = deparenthesized = other instanceof PsiExpression && context.getOptions().isLooseMatching() ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other)) : other;
                if (this.myMatchingVisitor.setResult(handler.validate(deparenthesized, context))) {
                    handler.addResult(other, context);
                }
            }
            return;
        }
        boolean bl = multiMatch = other != null && reference.getContainingFile() == other.getContainingFile();
        if (!(other instanceof PsiReferenceExpression)) {
            this.myMatchingVisitor.setResult(multiMatch && this.myMatchingVisitor.matchText((PsiElement)reference, other));
            return;
        }
        PsiReferenceExpression reference2 = (PsiReferenceExpression)other;
        PsiExpression qualifier2 = reference2.getQualifierExpression();
        if (multiMatch && (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (qualifier2 == null || qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) && (target = reference.resolve()) != null) {
            this.myMatchingVisitor.setResult(target == reference2.resolve());
            return;
        }
        if (qualifier == null && qualifier2 == null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(reference.getReferenceNameElement(), reference2.getReferenceNameElement()));
            return;
        }
        if (this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiMethodCallExpression) && qualifier != null)) {
            PsiElement referenceElement = reference.getReferenceNameElement();
            PsiElement referenceElement2 = reference2.getReferenceNameElement();
            if (pattern.isTypedVar(referenceElement) ? !this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(referenceElement, referenceElement2)) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(referenceElement, referenceElement2))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(qualifier instanceof PsiThisExpression && qualifier2 == null || this.myMatchingVisitor.matchOptionally((PsiElement)qualifier, (PsiElement)qualifier2))) {
                return;
            }
            if (qualifier2 == null) {
                this.myMatchingVisitor.setResult(JavaMatchingVisitor.matchImplicitQualifier(qualifier, other, context));
            }
        }
    }

    private static int getArrayDimensions(PsiElement element) {
        if (element == null) {
            return 0;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType type2 = variable.getType();
            return type2.getArrayDimensions();
        }
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            PsiType type3 = method.getReturnType();
            return type3 == null ? 0 : type3.getArrayDimensions();
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiType type4 = typeElement.getType();
            return type4.getArrayDimensions();
        }
        return 0;
    }

    private static PsiTypeElement getInnermostComponentTypeElement(PsiTypeElement typeElement) {
        PsiElement child = typeElement.getFirstChild();
        while (child instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)child;
            child = typeElement.getFirstChild();
        }
        return typeElement;
    }

    private static PsiElement getInnermostComponent(PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        if (!(element instanceof PsiTypeElement)) {
            return element;
        }
        PsiTypeElement typeElement = (PsiTypeElement)element;
        if (typeElement.getType() instanceof PsiDisjunctionType) {
            return typeElement;
        }
        if (typeElement.isInferredType()) {
            PsiType type2 = typeElement.getType();
            if (type2 == PsiType.NULL || type2 instanceof PsiLambdaParameterType) {
                return typeElement;
            }
            String canonicalText = type2.getCanonicalText();
            typeElement = JavaPsiFacade.getElementFactory((Project)typeElement.getProject()).createTypeElementFromText(canonicalText, (PsiElement)typeElement);
        }
        return (referenceElement = typeElement.getInnermostComponentReferenceElement()) != null ? referenceElement : JavaMatchingVisitor.getInnermostComponentTypeElement(typeElement);
    }

    private static PsiTypeElement[] getTypeParameters(PsiJavaCodeReferenceElement referenceElement, Boolean replaceDiamondWithExplicitTypes) {
        PsiReferenceParameterList referenceElementParameterList = referenceElement.getParameterList();
        if (referenceElementParameterList == null) {
            return null;
        }
        PsiTypeElement[] typeParameterElements = referenceElementParameterList.getTypeParameterElements();
        if (typeParameterElements.length != 1 || replaceDiamondWithExplicitTypes == Boolean.FALSE) {
            return typeParameterElements;
        }
        PsiType type2 = typeParameterElements[0].getType();
        if (!(type2 instanceof PsiDiamondType)) {
            return typeParameterElements;
        }
        if (replaceDiamondWithExplicitTypes == null) {
            return null;
        }
        PsiDiamondType diamondType = (PsiDiamondType)type2;
        PsiDiamondType.DiamondInferenceResult inferenceResult = diamondType.resolveInferredTypes();
        StringBuilder text2 = new StringBuilder(referenceElement.getQualifiedName());
        text2.append('<');
        boolean comma = false;
        for (PsiType inferredType : inferenceResult.getInferredTypes()) {
            if (comma) {
                text2.append(',');
            } else {
                comma = true;
            }
            text2.append(inferredType.getCanonicalText());
        }
        text2.append('>');
        PsiJavaCodeReferenceElement newReferenceElement = JavaPsiFacade.getElementFactory((Project)referenceElement.getProject()).createReferenceFromText(text2.toString(), (PsiElement)referenceElement);
        PsiReferenceParameterList newParameterList = newReferenceElement.getParameterList();
        return newParameterList == null ? null : newParameterList.getTypeParameterElements();
    }

    private Boolean shouldReplaceDiamondWithExplicitTypes(PsiElement element) {
        SubstitutionHandler substitutionHandler;
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return Boolean.TRUE;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return Boolean.TRUE;
        }
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        if (elements.length != 1) {
            return Boolean.TRUE;
        }
        PsiTypeElement typeElement = elements[0];
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)typeElement);
        if (handler instanceof SubstitutionHandler && (substitutionHandler = (SubstitutionHandler)handler).getMinOccurs() > 0) {
            return null;
        }
        return !(typeElement.getType() instanceof PsiDiamondType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchType(PsiElement patternType, PsiElement matchedType) {
        boolean caseSensitive;
        String text2;
        String text3;
        boolean equalsIgnorePackage;
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement patternElement = JavaMatchingVisitor.getInnermostComponent(patternType);
        PsiElement matchedElement = patternElement instanceof PsiTypeElement && ((PsiTypeElement)patternElement).isInferredType() ? matchedType : JavaMatchingVisitor.getInnermostComponent(matchedType);
        PsiTypeElement[] typeParameters = null;
        if (matchedElement instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)matchedElement;
            typeParameters = JavaMatchingVisitor.getTypeParameters(referenceElement, this.shouldReplaceDiamondWithExplicitTypes(patternElement));
        } else if (matchedElement instanceof PsiTypeParameter) {
            matchedElement = ((PsiTypeParameter)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiClass && ((PsiClass)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiClass)matchedElement).getTypeParameters();
            matchedElement = ((PsiClass)matchedElement).getNameIdentifier();
        } else if (matchedElement instanceof PsiMethod && ((PsiMethod)matchedElement).hasTypeParameters()) {
            typeParameters = ((PsiMethod)matchedElement).getTypeParameters();
            matchedElement = ((PsiMethod)matchedElement).getNameIdentifier();
        }
        if (patternElement instanceof PsiTypeElement && matchedElement instanceof PsiTypeElement) {
            PsiType type1 = ((PsiTypeElement)patternElement).getType();
            PsiType type2 = ((PsiTypeElement)matchedElement).getType();
            if (type1 instanceof PsiWildcardType && type2 instanceof PsiWildcardType) {
                PsiWildcardType wildcardType1 = (PsiWildcardType)type1;
                PsiWildcardType wildcardType2 = (PsiWildcardType)type2;
                if (wildcardType1.equals((Object)wildcardType2)) {
                    return true;
                }
                if (wildcardType1.isExtends() && (wildcardType2.isExtends() || !wildcardType2.isBounded())) {
                    if (wildcardType2.isExtends()) {
                        return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                    }
                    if (!wildcardType2.isBounded()) {
                        return this.myMatchingVisitor.matchOptionally(patternElement.getLastChild(), null);
                    }
                } else if (wildcardType1.isSuper() && wildcardType2.isSuper()) {
                    return this.myMatchingVisitor.match(patternElement.getLastChild(), matchedElement.getLastChild());
                }
            }
        }
        if (patternElement instanceof PsiJavaCodeReferenceElement) {
            PsiTypeElement[] elements;
            referenceElement = (PsiJavaCodeReferenceElement)patternElement;
            PsiReferenceParameterList list = referenceElement.getParameterList();
            boolean typeParametersMatched = false;
            if (list != null && (elements = list.getTypeParameterElements()).length > 0) {
                typeParametersMatched = true;
                if (!this.myMatchingVisitor.matchSequentially((PsiElement[])elements, (PsiElement[])(typeParameters == null ? PsiElement.EMPTY_ARRAY : typeParameters))) {
                    return false;
                }
            }
            patternElement = referenceElement.getReferenceNameElement();
            if (typeParametersMatched && matchedElement instanceof PsiJavaCodeReferenceElement) {
                matchedElement = ((PsiJavaCodeReferenceElement)matchedElement).getReferenceNameElement();
            }
        }
        final int matchedArrayDimensions = JavaMatchingVisitor.getArrayDimensions(matchedType);
        int patternArrayDimensions = JavaMatchingVisitor.getArrayDimensions(patternType);
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(patternElement)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(patternElement);
            RegExpPredicate regExpPredicate = null;
            boolean fullTypeResult = false;
            if (patternArrayDimensions != 0) {
                if (patternArrayDimensions != matchedArrayDimensions) {
                    return false;
                }
            } else if (matchedArrayDimensions != 0) {
                regExpPredicate = handler.findRegExpPredicate();
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(new RegExpPredicate.NodeTextGenerator(){

                        public String getText(PsiElement element) {
                            StringBuilder builder = new StringBuilder(StructuralSearchUtil.getMeaningfulText((PsiElement)element));
                            for (int i = 0; i < matchedArrayDimensions; ++i) {
                                builder.append("[]");
                            }
                            return builder.toString();
                        }
                    });
                }
                fullTypeResult = true;
            }
            try {
                boolean result;
                boolean bl = result = handler.isSubtype() || handler.isStrictSubtype() ? this.checkMatchWithinHierarchy(patternElement, matchedElement, handler) : handler.validate(matchedElement, this.myMatchingVisitor.getMatchContext());
                if (result) {
                    handler.addResult(fullTypeResult ? matchedType : matchedElement, this.myMatchingVisitor.getMatchContext());
                }
                boolean bl2 = result;
                return bl2;
            }
            finally {
                if (regExpPredicate != null) {
                    regExpPredicate.setNodeTextGenerator(null);
                }
            }
        }
        if (matchedArrayDimensions != patternArrayDimensions) {
            return false;
        }
        if (patternElement instanceof PsiIdentifier && (parent = patternElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            patternElement = parent;
        }
        if (matchedElement instanceof PsiIdentifier && (parent = matchedElement.getParent()) instanceof PsiJavaCodeReferenceElement) {
            matchedElement = parent;
        }
        if ((equalsIgnorePackage = MatchUtils.compareWithNoDifferenceToPackage((String)(text3 = JavaMatchingVisitor.getText(patternElement)), (String)(text2 = JavaMatchingVisitor.getText(matchedElement)), (!(caseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch()) ? 1 : 0) != 0)) || !(matchedElement instanceof PsiJavaReference)) {
            return equalsIgnorePackage;
        }
        PsiElement element2 = ((PsiJavaReference)matchedElement).resolve();
        if (!(element2 instanceof PsiClass)) {
            return false;
        }
        String name2 = ((PsiClass)element2).getQualifiedName();
        return caseSensitive ? text3.equals(name2) : text3.equalsIgnoreCase(name2);
    }

    @Contract(pure=true)
    private static String getText(@NotNull PsiElement element) {
        int index;
        String result;
        if (element == null) {
            JavaMatchingVisitor.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass) {
            result = ((PsiClass)element).getQualifiedName();
            if (result == null) {
                result = element.getText();
            }
        } else {
            result = element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).getCanonicalText() : element.getText();
        }
        return (index = result.indexOf(60)) == -1 ? result : result.substring(0, index);
    }

    private boolean checkMatchWithinHierarchy(PsiElement patternElement, PsiElement matchElement, SubstitutionHandler handler) {
        PsiElement patternGrandParent;
        boolean includeInterfaces = true;
        boolean includeClasses = true;
        PsiElement patternParent = patternElement.getParent();
        if (patternParent instanceof PsiReferenceList && (patternGrandParent = patternParent.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)patternGrandParent;
            if (patternParent == psiClass.getExtendsList()) {
                includeInterfaces = psiClass.isInterface();
            } else if (patternParent == psiClass.getImplementsList()) {
                includeClasses = false;
            }
        }
        HierarchyNodeIterator nodes = new HierarchyNodeIterator(matchElement, includeClasses, includeInterfaces);
        if (handler.isStrictSubtype()) {
            nodes.advance();
        }
        boolean negated = handler.getPredicate() instanceof NotPredicate;
        while (nodes.hasNext() && negated == handler.validate(nodes.current(), this.myMatchingVisitor.getMatchContext())) {
            nodes.advance();
        }
        return negated != nodes.hasNext();
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        PsiConditionalExpression other = this.getExpression(PsiConditionalExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getCondition(), (PsiElement)other.getCondition()) && this.myMatchingVisitor.matchSons((PsiElement)expression2, (PsiElement)other));
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        PsiPolyadicExpression other = this.getExpression(PsiPolyadicExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        if (this.myMatchingVisitor.setResult(expression2.getOperationTokenType().equals(other.getOperationTokenType()))) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])expression2.getOperands(), (PsiElement[])other.getOperands()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitVariable(PsiVariable var) {
        String name2;
        PsiIdentifier identifier;
        boolean isTypedVar;
        PsiIdentifier nameIdentifier;
        PsiVariable other;
        block14: {
            String name3;
            PsiIdentifier identifier2;
            block13: {
                String name4;
                PsiIdentifier identifier3;
                other = (PsiVariable)this.myMatchingVisitor.getElement();
                MatchContext context = this.myMatchingVisitor.getMatchContext();
                nameIdentifier = var.getNameIdentifier();
                isTypedVar = context.getPattern().isTypedVar((PsiElement)nameIdentifier);
                context.pushResult();
                try {
                    if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)nameIdentifier, (PsiElement)other.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)var.getModifierList(), (PsiElement)other.getModifierList()))) break block13;
                }
                catch (Throwable throwable) {
                    String name5;
                    PsiIdentifier identifier4;
                    Object object = identifier4 = other instanceof PsiReceiverParameter ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                    if (identifier4 == null && (name5 = other.getName()) != null) {
                        PsiIdentifier fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name5);
                        this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                    } else {
                        this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier4);
                    }
                    throw throwable;
                }
                Object object = identifier3 = other instanceof PsiReceiverParameter ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
                if (identifier3 == null && (name4 = other.getName()) != null) {
                    PsiIdentifier fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name4);
                    this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
                } else {
                    this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier3);
                }
                return;
            }
            PsiTypeElement typeElement1 = var.getTypeElement();
            if (typeElement1 == null) break block14;
            PsiTypeElement typeElement2 = other.getTypeElement();
            if (typeElement2 == null) {
                typeElement2 = JavaPsiFacade.getElementFactory((Project)other.getProject()).createTypeElement(other.getType());
            }
            if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)typeElement1, (PsiElement)typeElement2))) break block14;
            Object object = identifier2 = other instanceof PsiReceiverParameter ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
            if (identifier2 == null && (name3 = other.getName()) != null) {
                PsiIdentifier fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name3);
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
            } else {
                this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier2);
            }
            return;
        }
        PsiExpression initializer = var.getInitializer();
        PsiExpression var2Initializer = other.getInitializer();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)initializer, (PsiElement)var2Initializer));
        Object object = identifier = other instanceof PsiReceiverParameter ? ((PsiReceiverParameter)other).getIdentifier() : other.getNameIdentifier();
        if (identifier == null && (name2 = other.getName()) != null) {
            PsiIdentifier fakeIdentifier = JavaPsiFacade.getElementFactory((Project)other.getProject()).createIdentifier(name2);
            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)fakeIdentifier);
        } else {
            this.myMatchingVisitor.scopeMatch((PsiElement)nameIdentifier, isTypedVar, (PsiElement)identifier);
        }
    }

    private void matchArrayOrArguments(PsiNewExpression patternExpression, PsiNewExpression matchExpression) {
        PsiExpression[] dimensions2;
        PsiExpression[] dimensions1;
        PsiType type1 = patternExpression.getType();
        PsiType type2 = matchExpression.getType();
        if (!this.myMatchingVisitor.setResult(type1 != null && type2 != null && type1.getArrayDimensions() == type2.getArrayDimensions())) {
            return;
        }
        PsiArrayInitializerExpression initializer1 = patternExpression.getArrayInitializer();
        PsiArrayInitializerExpression initializer2 = matchExpression.getArrayInitializer();
        if (initializer1 != null) {
            if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)initializer1, (PsiElement)initializer2))) {
                return;
            }
        } else if (initializer2 != null) {
            this.myMatchingVisitor.setResult(JavaMatchingVisitor.areZeroLiterals(patternExpression.getArrayDimensions()) && initializer2.getInitializers().length == 0);
            return;
        }
        if (!this.myMatchingVisitor.setResult((dimensions1 = patternExpression.getArrayDimensions()).length == (dimensions2 = matchExpression.getArrayDimensions()).length)) {
            return;
        }
        if (dimensions1.length != 0) {
            for (int i = 0; i < dimensions1.length; ++i) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)dimensions1[i], (PsiElement)dimensions2[i]))) continue;
                return;
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)patternExpression.getArgumentList(), (PsiElement)matchExpression.getArgumentList()) && this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)patternExpression, (PsiCallExpression)matchExpression)));
        }
    }

    private static boolean areZeroLiterals(PsiExpression[] expressions2) {
        for (PsiExpression expression2 : expressions2) {
            if (expression2 instanceof PsiLiteralExpression && expression2.getText().equals("0")) continue;
            return false;
        }
        return true;
    }

    private static boolean matchImplicitQualifier(PsiExpression qualifier, PsiElement reference, MatchContext context) {
        PsiMethod target;
        Object object = target = reference instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)reference).resolveMethod() : ((PsiReference)reference).resolve();
        if (target instanceof PsiMember && qualifier instanceof PsiThisExpression) {
            return !((PsiMember)target).hasModifierProperty("static") && (target instanceof PsiField || target instanceof PsiMethod);
        }
        MatchingHandler matchingHandler = context.getPattern().getHandler((PsiElement)qualifier);
        if (!(matchingHandler instanceof SubstitutionHandler)) {
            return false;
        }
        SubstitutionHandler substitutionHandler = (SubstitutionHandler)matchingHandler;
        if (target instanceof PsiModifierListOwner && ((PsiModifierListOwner)target).hasModifierProperty("static")) {
            return substitutionHandler.handle(PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class), context);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
        PsiExpression implicitReference = factory.createExpressionFromText("this", reference);
        return substitutionHandler.handle((PsiElement)implicitReference, context);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        PsiMethodCallExpression other = this.getExpression(PsiMethodCallExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        PsiReferenceExpression ref1 = expression2.getMethodExpression();
        PsiReferenceExpression ref2 = other.getMethodExpression();
        PsiElement patternMethodName = ref1.getReferenceNameElement();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar(patternMethodName);
        if (!isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(patternMethodName, ref2.getReferenceNameElement()))) {
            return;
        }
        PsiExpression patternQualifier = ref1.getQualifierExpression();
        PsiExpression matchedQualifier = ref2.getQualifierExpression();
        if (!this.myMatchingVisitor.setResult(patternQualifier instanceof PsiThisExpression && matchedQualifier == null || this.myMatchingVisitor.matchOptionally((PsiElement)patternQualifier, (PsiElement)matchedQualifier))) {
            return;
        }
        if (patternQualifier != null && matchedQualifier == null && !this.myMatchingVisitor.setResult(JavaMatchingVisitor.matchImplicitQualifier(patternQualifier, (PsiElement)other, context))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expression2.getArgumentList(), (PsiElement)other.getArgumentList()))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchTypeParameters((PsiCallExpression)expression2, (PsiCallExpression)other))) {
            return;
        }
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(patternMethodName, ref2.getReferenceNameElement()));
        }
    }

    private boolean matchTypeParameters(PsiCallExpression call1, PsiCallExpression call2) {
        PsiReferenceParameterList patternParameterList = call1.getTypeArgumentList();
        PsiTypeElement[] patternTypeElements = patternParameterList.getTypeParameterElements();
        if (patternTypeElements.length == 0) {
            return true;
        }
        PsiReferenceParameterList matchedParameterList = call2.getTypeArgumentList();
        if (matchedParameterList.getFirstChild() == null && this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            JavaResolveResult resolveResult = call2.resolveMethodGenerics();
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return false;
            }
            PsiTypeParameterList typeParameterList = targetMethod.getTypeParameterList();
            if (typeParameterList == null) {
                return false;
            }
            PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            matchedParameterList = (PsiReferenceParameterList)matchedParameterList.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType type2 = substitutor.substitute(typeParameter);
                if (type2 == null) {
                    return false;
                }
                PsiTypeElement matchedTypeElement = JavaPsiFacade.getElementFactory((Project)call1.getProject()).createTypeElement(type2);
                matchedParameterList.add((PsiElement)matchedTypeElement);
            }
        }
        PsiTypeElement[] matchedTypeElements = matchedParameterList.getTypeParameterElements();
        return this.myMatchingVisitor.matchSequentially((PsiElement[])patternTypeElements, (PsiElement[])matchedTypeElements);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiExpressionStatement)) {
            PsiExpressionStatement expr2 = (PsiExpressionStatement)other;
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getExpression(), (PsiElement)expr2.getExpression()));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        PsiLiteralExpression other = this.getExpression(PsiLiteralExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        PsiType type1 = expression2.getType();
        if (type1 != null && !this.myMatchingVisitor.setResult(type1.equals(other.getType()))) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)expression2.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            int offset = 0;
            int length = other.getTextLength();
            String text2 = other.getText();
            if (StringUtil.isQuotedString((String)text2)) {
                --length;
                ++offset;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, offset, length, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)expression2, (PsiElement)other, this.myMatchingVisitor.getMatchContext()));
        } else {
            Object value1 = expression2.getValue();
            Object value2 = other.getValue();
            if ((value1 instanceof String || value1 instanceof Character) && (value2 instanceof String || value2 instanceof Character)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize((String)value1.toString()), StructuralSearchUtil.normalize((String)value2.toString())));
            } else if (value1 != null && value2 != null) {
                this.myMatchingVisitor.setResult(value1.equals(value2));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)expression2, (PsiElement)other));
            }
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        PsiAssignmentExpression other = this.getExpression(PsiAssignmentExpression.class, (PsiExpression)expression2);
        if (other != null) {
            this.myMatchingVisitor.setResult(expression2.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression2.getLExpression(), (PsiElement)other.getLExpression()) && this.myMatchingVisitor.match((PsiElement)expression2.getRExpression(), (PsiElement)other.getRExpression()));
        }
    }

    public void visitIfStatement(PsiIfStatement statement) {
        PsiIfStatement other = (PsiIfStatement)this.myMatchingVisitor.getElement();
        PsiStatement elseBranch = statement.getElseBranch();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getThenBranch(), (PsiElement)other.getThenBranch()) && (elseBranch == null || this.matchBody((PsiElement)elseBranch, (PsiElement)other.getElseBranch())));
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        this.myMatchingVisitor.setResult(this.matchSwitchBlock((PsiSwitchBlock)statement));
    }

    public void visitSwitchExpression(PsiSwitchExpression expression2) {
        this.myMatchingVisitor.setResult(this.matchSwitchBlock((PsiSwitchBlock)expression2));
    }

    private boolean matchSwitchBlock(PsiSwitchBlock switchBlock) {
        PsiSwitchBlock other = (PsiSwitchBlock)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.match((PsiElement)switchBlock.getExpression(), (PsiElement)other.getExpression())) {
            return false;
        }
        PsiCodeBlock body2 = switchBlock.getBody();
        PsiSwitchLabelStatementBase[] cases1 = (PsiSwitchLabelStatementBase[])PsiTreeUtil.getChildrenOfType((PsiElement)body2, PsiSwitchLabelStatementBase.class);
        if (cases1 != null) {
            PsiSwitchLabelStatementBase[] cases2 = (PsiSwitchLabelStatementBase[])PsiTreeUtil.getChildrenOfType((PsiElement)other.getBody(), PsiSwitchLabelStatementBase.class);
            return this.myMatchingVisitor.matchSequentially((PsiElement[])cases1, (PsiElement[])(cases2 != null ? cases2 : PsiElement.EMPTY_ARRAY));
        }
        List statements1 = PsiTreeUtil.getChildrenOfAnyType((PsiElement)body2, (Class[])new Class[]{PsiStatement.class, PsiComment.class});
        if (!statements1.isEmpty()) {
            List statements2 = PsiTreeUtil.getChildrenOfAnyType((PsiElement)other.getBody(), (Class[])new Class[]{PsiStatement.class, PsiComment.class});
            return this.myMatchingVisitor.matchSequentially(statements1.toArray(PsiElement.EMPTY_ARRAY), statements2.toArray(PsiElement.EMPTY_ARRAY));
        }
        return true;
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.myMatchingVisitor.setResult(this.matchLabelStatement((PsiSwitchLabelStatementBase)statement, (PsiSwitchLabelStatementBase)this.myMatchingVisitor.getElement()));
    }

    public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
        this.myMatchingVisitor.setResult(this.matchLabelStatement((PsiSwitchLabelStatementBase)statement, (PsiSwitchLabelStatementBase)this.myMatchingVisitor.getElement()));
    }

    private boolean matchLabelStatement(PsiSwitchLabelStatementBase statement1, PsiSwitchLabelStatementBase statement2) {
        PsiExpression[] expressions2;
        PsiExpressionList values1 = statement1.getCaseValues();
        PsiExpressionList values2 = statement2.getCaseValues();
        if (statement1.isDefaultCase() && !statement2.isDefaultCase()) {
            return false;
        }
        if (values1 == null) {
            return true;
        }
        PsiExpression[] psiExpressionArray = expressions2 = values2 == null ? PsiExpression.EMPTY_ARRAY : values2.getExpressions();
        if (!this.myMatchingVisitor.matchInAnyOrder((PsiElement[])values1.getExpressions(), (PsiElement[])expressions2)) {
            return false;
        }
        PsiElement[] body2 = JavaMatchingVisitor.getBody(statement1);
        return body2.length == 0 || this.myMatchingVisitor.matchSequentially(body2, JavaMatchingVisitor.getBody(statement2));
    }

    private static PsiElement[] getBody(PsiSwitchLabelStatementBase switchLabelStatement) {
        SmartList result = new SmartList();
        if (switchLabelStatement instanceof PsiSwitchLabeledRuleStatement) {
            PsiStatement body2 = ((PsiSwitchLabeledRuleStatement)switchLabelStatement).getBody();
            if (body2 instanceof PsiBlockStatement) {
                result.addAll(PsiTreeUtil.getChildrenOfAnyType((PsiElement)((PsiBlockStatement)body2).getCodeBlock(), (Class[])new Class[]{PsiStatement.class, PsiComment.class}));
            } else {
                result.add(body2);
            }
        } else {
            for (PsiElement sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)switchLabelStatement, PsiStatement.class); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getNextSibling()) {
                if (!(sibling instanceof PsiStatement) && !(sibling instanceof PsiComment)) continue;
                result.add(sibling);
            }
        }
        return result.toArray(PsiElement.EMPTY_ARRAY);
    }

    public void visitYieldStatement(PsiYieldStatement statement) {
        PsiYieldStatement other = (PsiYieldStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getExpression(), (PsiElement)other.getExpression()));
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiForStatement other = (PsiForStatement)this.myMatchingVisitor.getElement();
        PsiStatement initialization = statement.getInitialization();
        if (!this.myMatchingVisitor.setResult(initialization == null || initialization instanceof PsiEmptyStatement ? this.myMatchingVisitor.isLeftLooseMatching() : this.myMatchingVisitor.matchSequentially(JavaMatchingVisitor.getIterator(initialization), JavaMatchingVisitor.getIterator(other.getInitialization())))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()))) {
            return;
        }
        PsiStatement update2 = statement.getUpdate();
        if (!this.myMatchingVisitor.setResult(update2 == null ? this.myMatchingVisitor.isLeftLooseMatching() : this.myMatchingVisitor.matchSequentially(JavaMatchingVisitor.getIterator(update2), JavaMatchingVisitor.getIterator(other.getUpdate())))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    private static NodeIterator getIterator(PsiStatement statement) {
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
            return new ArrayBackedNodeIterator((PsiElement[])expressionListStatement.getExpressionList().getExpressions());
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            return SingleNodeIterator.newSingleNodeIterator((PsiElement)expressionStatement.getExpression());
        }
        if (statement instanceof PsiEmptyStatement) {
            return SingleNodeIterator.EMPTY;
        }
        return SingleNodeIterator.newSingleNodeIterator((PsiElement)statement);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        PsiForeachStatement other = (PsiForeachStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getIterationParameter(), (PsiElement)other.getIterationParameter()) && this.myMatchingVisitor.match((PsiElement)statement.getIteratedValue(), (PsiElement)other.getIteratedValue()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        PsiWhileStatement other = (PsiWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (other instanceof PsiCodeBlock) {
            this.myMatchingVisitor.setResult(!(other.getParent() instanceof PsiBlockStatement) && this.myMatchingVisitor.matchSons((PsiElement)statement.getCodeBlock(), other));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)statement, other));
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiDeclarationStatement other = (PsiDeclarationStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(statement.getDeclaredElements(), other.getDeclaredElements()));
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        PsiDoWhileStatement other = (PsiDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getCondition(), (PsiElement)other.getCondition()) && this.matchBody((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        PsiReturnStatement other = (PsiReturnStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getReturnValue(), (PsiElement)other.getReturnValue()));
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        PsiPostfixExpression other = this.getExpression(PsiPostfixExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(expression2.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression2.getOperand(), (PsiElement)other.getOperand()));
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        PsiPrefixExpression other = this.getExpression(PsiPrefixExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        this.myMatchingVisitor.setResult(expression2.getOperationTokenType().equals(other.getOperationTokenType()) && this.myMatchingVisitor.match((PsiElement)expression2.getOperand(), (PsiElement)other.getOperand()));
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        PsiAssertStatement other = (PsiAssertStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getAssertCondition(), (PsiElement)other.getAssertCondition()) && this.myMatchingVisitor.matchOptionally((PsiElement)statement.getAssertDescription(), (PsiElement)other.getAssertDescription()));
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        PsiBreakStatement other = (PsiBreakStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getLabelIdentifier(), (PsiElement)other.getLabelIdentifier()));
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        PsiContinueStatement other = (PsiContinueStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)statement.getLabelIdentifier(), (PsiElement)other.getLabelIdentifier()));
    }

    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.getExpression(PsiSuperExpression.class, (PsiExpression)expression2);
    }

    public void visitThisExpression(PsiThisExpression expression2) {
        this.getExpression(PsiThisExpression.class, (PsiExpression)expression2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        PsiSynchronizedStatement other = (PsiSynchronizedStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getLockExpression(), (PsiElement)other.getLockExpression()) && this.myMatchingVisitor.matchSons((PsiElement)statement.getBody(), (PsiElement)other.getBody()));
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        PsiThrowStatement other = (PsiThrowStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)statement.getException(), (PsiElement)other.getException()));
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (this.myMatchingVisitor.setResult(other instanceof PsiParenthesizedExpression)) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expression2, other));
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        PsiCatchSection other = (PsiCatchSection)this.myMatchingVisitor.getElement();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)section);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)section.getParameter(), (PsiElement)other.getParameter()) && this.myMatchingVisitor.matchSons((PsiElement)section.getCatchBlock(), (PsiElement)other.getCatchBlock()) && ((SubstitutionHandler)handler).handle((PsiElement)other, this.myMatchingVisitor.getMatchContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitTryStatement(PsiTryStatement statement) {
        PsiTryStatement other = (PsiTryStatement)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)statement.getTryBlock(), (PsiElement)other.getTryBlock()))) {
            return;
        }
        PsiResourceList resourceList1 = statement.getResourceList();
        PsiCatchSection[] catches1 = statement.getCatchSections();
        PsiCodeBlock finally1 = statement.getFinallyBlock();
        PsiResourceList resourceList2 = other.getResourceList();
        Object[] catches2 = other.getCatchSections();
        PsiCodeBlock finally2 = other.getFinallyBlock();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        if (this.myMatchingVisitor.setResult(!(!context.getOptions().isLooseMatching() && (catches1.length == 0 && catches2.length != 0 || finally1 == null && finally2 != null || resourceList1 == null && resourceList2 != null)))) {
            SmartList unmatchedElements = new SmartList();
            if (resourceList1 != null) {
                List resources1 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList1, PsiResourceListElement.class);
                List resources2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)resourceList2, PsiResourceListElement.class);
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder(resources1.toArray(PsiElement.EMPTY_ARRAY), resources2.toArray(PsiElement.EMPTY_ARRAY)))) {
                    return;
                }
            } else if (resourceList2 != null) {
                unmatchedElements.add(resourceList2);
            }
            ContainerUtil.addAll((Collection)unmatchedElements, (Object[])catches2);
            context.pushMatchedElementsListener(arg_0 -> JavaMatchingVisitor.lambda$visitTryStatement$4((List)unmatchedElements, arg_0));
            try {
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])catches1, (PsiElement[])catches2))) {
                    return;
                }
            }
            finally {
                context.popMatchedElementsListener();
            }
            if (finally1 != null) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)finally1, (PsiElement)finally2));
            } else if (finally2 != null) {
                unmatchedElements.add(finally2);
            }
            if (this.myMatchingVisitor.getResult() && !unmatchedElements.isEmpty()) {
                other.putUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY, (Object)unmatchedElements);
            }
        }
    }

    public void visitResourceExpression(PsiResourceExpression expression2) {
        PsiElement other = this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(other instanceof PsiResourceExpression && this.myMatchingVisitor.match((PsiElement)expression2.getExpression(), (PsiElement)((PsiResourceExpression)other).getExpression()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitLabeledStatement(PsiLabeledStatement statement) {
        PsiLabeledStatement other = (PsiLabeledStatement)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = statement.getLabelIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)identifier);
        context.pushResult();
        try {
            this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier, other.getNameIdentifier())) && this.myMatchingVisitor.match((PsiElement)statement.getStatement(), (PsiElement)other.getStatement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)identifier, isTypedVar, other.getNameIdentifier());
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        PsiInstanceOfExpression other = this.getExpression(PsiInstanceOfExpression.class, (PsiExpression)expression2);
        if (other == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getOperand(), (PsiElement)other.getOperand()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getCheckType(), (PsiElement)other.getCheckType()));
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiExpression other = this.getExpression(PsiExpression.class, (PsiExpression)expression2);
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        if (other instanceof PsiArrayInitializerExpression && other.getParent() instanceof PsiVariable && JavaMatchingVisitor.areZeroLiterals(expression2.getArrayDimensions())) {
            MatchingHandler handler;
            MatchContext matchContext = this.myMatchingVisitor.getMatchContext();
            CompiledPattern pattern = matchContext.getPattern();
            boolean isTypedVar = pattern.isTypedVar((PsiElement)classReference2);
            if (isTypedVar && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference2, null))) {
                return;
            }
            PsiType otherType = other.getType();
            if (classReference2 != null && (handler = pattern.getHandler((PsiElement)classReference2)) instanceof SubstitutionHandler && otherType != null) {
                SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
                MatchPredicate predicate = substitutionHandler.getPredicate();
                if (predicate != null) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)other.getProject());
                    PsiTypeElement otherTypeElement = factory.createTypeElement(otherType.getDeepComponentType());
                    this.myMatchingVisitor.setResult(predicate.match((PsiElement)otherTypeElement, matchContext));
                }
            } else {
                PsiType type2 = expression2.getType();
                this.myMatchingVisitor.setResult(type2 != null && type2.equals(otherType));
            }
            if (this.myMatchingVisitor.getResult()) {
                PsiArrayInitializerExpression initializer = expression2.getArrayInitializer();
                if (initializer != null) {
                    this.myMatchingVisitor.matchSons((PsiElement)initializer, (PsiElement)other);
                } else {
                    this.myMatchingVisitor.setResult(((PsiArrayInitializerExpression)other).getInitializers().length == 0);
                }
            }
            return;
        }
        if (!this.myMatchingVisitor.setResult(other instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression new2 = (PsiNewExpression)other;
        if (classReference2 != null) {
            if (new2.getClassReference() != null) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference2, (PsiElement)new2.getClassReference()))) {
                    this.matchArrayOrArguments(expression2, new2);
                }
                return;
            }
            PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)new2, PsiKeyword.class);
            PsiElement element = PsiTreeUtil.getNextSiblingOfType((PsiElement)newKeyword, PsiWhiteSpace.class);
            if (element != null && element.getNextSibling() instanceof PsiKeyword) {
                if (this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)classReference2, element.getNextSibling()))) {
                    this.matchArrayOrArguments(expression2, new2);
                }
                return;
            }
        }
        if (classReference2 == new2.getClassReference()) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)expression2, (PsiElement)new2));
        } else if (expression2.getAnonymousClass() == null && classReference2 != null && new2.getAnonymousClass() != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)classReference2, (PsiElement)new2.getAnonymousClass().getBaseClassReference()) && this.myMatchingVisitor.matchSons((PsiElement)expression2.getArgumentList(), (PsiElement)new2.getArgumentList()));
        } else {
            this.myMatchingVisitor.setResult(false);
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)keyword, this.myMatchingVisitor.getElement()));
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiTypeCastExpression other = this.getExpression(PsiTypeCastExpression.class, (PsiExpression)expression2);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getCastType(), (PsiElement)other.getCastType()) && this.myMatchingVisitor.match((PsiElement)expression2.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        PsiClassObjectAccessExpression other = this.getExpression(PsiClassObjectAccessExpression.class, (PsiExpression)expression2);
        if (other != null) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)expression2.getOperand(), (PsiElement)other.getOperand()));
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        PsiAnnotation[] otherAnnotations;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((otherAnnotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])otherAnnotations))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.matchType((PsiElement)ref, other));
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        PsiAnnotation[] annotations2;
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiAnnotation.class);
        if (annotations != null && !this.myMatchingVisitor.setResult((annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiAnnotation.class)) != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])annotations, (PsiElement[])annotations2))) {
            return;
        }
        PsiTypeElement[] typeElementChildren = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
        if (typeElementChildren != null && typeElementChildren.length > 1) {
            PsiTypeElement[] typeElementChildren2 = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)other, PsiTypeElement.class);
            this.myMatchingVisitor.setResult(typeElementChildren2 != null && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])typeElementChildren, (PsiElement[])typeElementChildren2));
        } else {
            this.myMatchingVisitor.setResult(this.matchType((PsiElement)typeElement, other));
        }
    }

    public void visitTypeParameter(PsiTypeParameter parameter2) {
        PsiTypeParameter other = (PsiTypeParameter)this.myMatchingVisitor.getElement();
        PsiIdentifier identifier = parameter2.getNameIdentifier();
        assert (identifier != null);
        PsiIdentifier identifier2 = other.getNameIdentifier();
        MatchingHandler handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)identifier);
        if (handler instanceof SubstitutionHandler ? !this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)identifier2, this.myMatchingVisitor.getMatchContext())) : !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText((PsiElement)identifier, (PsiElement)identifier2))) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.matchInAnyOrder(parameter2.getExtendsList(), other.getExtendsList()))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchInAnyOrder((PsiElement[])parameter2.getAnnotations(), (PsiElement[])other.getAnnotations()));
    }

    public void visitClass(PsiClass clazz) {
        PsiClass other = (PsiClass)this.myMatchingVisitor.getElement();
        if (clazz.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)clazz.getTypeParameterList(), (PsiElement)other.getTypeParameterList()))) {
            return;
        }
        PsiDocComment comment = clazz.getDocComment();
        if (comment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)comment, (PsiElement)other))) {
            return;
        }
        PsiIdentifier identifier1 = clazz.getNameIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        CompiledPattern pattern = context.getPattern();
        boolean isTypedVar = pattern.isTypedVar((PsiElement)identifier1);
        PsiModifierList modifierList = clazz.getModifierList();
        if (modifierList != null && modifierList.getTextLength() > 0 && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)modifierList, (PsiElement)other.getModifierList()))) {
            return;
        }
        PsiIdentifier identifier2 = other.getNameIdentifier();
        if (this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText((PsiElement)identifier1, (PsiElement)identifier2)) && this.matchClasses(clazz, other)) && isTypedVar) {
            PsiIdentifier result;
            PsiClass matchElement = identifier2 == null ? other : identifier2;
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler((PsiElement)identifier1);
            Object object = result = other instanceof PsiAnonymousClass ? ((PsiAnonymousClass)other).getBaseClassReference().getReferenceNameElement() : identifier2;
            if (handler.isSubtype() || handler.isStrictSubtype()) {
                if (this.myMatchingVisitor.setResult(this.checkMatchWithinHierarchy((PsiElement)identifier1, (PsiElement)other, handler))) {
                    handler.addResult((PsiElement)(result == null ? other : result), context);
                }
            } else if (this.myMatchingVisitor.setResult(handler.validate((PsiElement)matchElement, context))) {
                handler.addResult((PsiElement)(result == null ? other : result), context);
            }
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList psiTypeParameterList) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(psiTypeParameterList.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        PsiIdentifier methodNameNode = method.getNameIdentifier();
        MatchContext context = this.myMatchingVisitor.getMatchContext();
        boolean isTypedVar = context.getPattern().isTypedVar((PsiElement)methodNameNode);
        PsiMethod other = (PsiMethod)this.myMatchingVisitor.getElement();
        context.pushResult();
        try {
            PsiDocComment docComment = method.getDocComment();
            if (docComment != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)docComment, (PsiElement)other))) {
                return;
            }
            if (method.hasTypeParameters() && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)method.getTypeParameterList(), (PsiElement)((PsiMethod)this.myMatchingVisitor.getElement()).getTypeParameterList()))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(this.checkHierarchy((PsiMember)other, (PsiMember)method))) {
                return;
            }
            if (!this.myMatchingVisitor.setResult(!(method.isConstructor() && !other.isConstructor() || !isTypedVar && !this.myMatchingVisitor.matchText((PsiElement)methodNameNode, (PsiElement)other.getNameIdentifier()) || !this.myMatchingVisitor.match((PsiElement)method.getModifierList(), (PsiElement)other.getModifierList())))) {
                return;
            }
            PsiParameterList otherParameterList = other.getParameterList();
            PsiReceiverParameter receiverParameter = (PsiReceiverParameter)PsiTreeUtil.findChildOfType((PsiElement)otherParameterList, PsiReceiverParameter.class);
            if (receiverParameter != null) {
                SubstitutionHandler substHandler;
                MatchingHandler handler;
                PsiParameterList parameterList = method.getParameterList();
                PsiVariable firstParameter = (PsiVariable)PsiTreeUtil.findChildOfType((PsiElement)parameterList, PsiVariable.class);
                if (firstParameter != null && (handler = this.myMatchingVisitor.getMatchContext().getPattern().getHandler((PsiElement)firstParameter)) instanceof SubstitutionHandler && (substHandler = (SubstitutionHandler)handler).handle((PsiElement)receiverParameter, context) && !this.myMatchingVisitor.setResult(substHandler.getMaxOccurs() != 0)) {
                    return;
                }
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)otherParameterList) || this.myMatchingVisitor.matchSequentially(parameterList.getFirstChild(), receiverParameter.getNextSibling()))) {
                    return;
                }
            } else if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)method.getParameterList(), (PsiElement)otherParameterList))) {
                return;
            }
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchOptionally((PsiElement)method.getReturnTypeElement(), (PsiElement)other.getReturnTypeElement()) && this.matchInAnyOrder(method.getThrowsList(), other.getThrowsList()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)method.getBody(), (PsiElement)other.getBody()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)methodNameNode, isTypedVar, (PsiElement)other.getNameIdentifier());
        }
    }

    @Nullable
    private <T extends PsiExpression> T getExpression(Class<T> aClass, PsiExpression patternExpression) {
        PsiElement other = this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(other instanceof PsiExpression)) {
            return null;
        }
        if (!(patternExpression.getParent() instanceof PsiExpressionStatement)) {
            other = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)other));
        }
        return (T)(this.myMatchingVisitor.setResult(aClass.isInstance(other)) ? (PsiExpression)aClass.cast(other) : null);
    }

    private <T extends PsiElement> T getElement(Class<T> aClass) {
        PsiElement other = this.myMatchingVisitor.getElement();
        return (T)(this.myMatchingVisitor.setResult(aClass.isInstance(other)) ? (PsiElement)aClass.cast(other) : null);
    }

    private static /* synthetic */ void lambda$visitTryStatement$4(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    private static /* synthetic */ void lambda$matchClasses$3(Set matchedElements, Collection elements) {
        matchedElements.addAll(elements);
    }

    private static /* synthetic */ void lambda$visitAnnotation$2(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    private static /* synthetic */ void lambda$visitModifierList$1(List unmatchedElements, Collection elements) {
        unmatchedElements.removeAll(elements);
    }

    static {
        Arrays.sort(MODIFIERS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/JavaMatchingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

