/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClassTypeArgumentMigrationProcessor {
    private static final Logger LOG = Logger.getInstance(ClassTypeArgumentMigrationProcessor.class);
    private final TypeMigrationLabeler myLabeler;

    public ClassTypeArgumentMigrationProcessor(TypeMigrationLabeler labeler) {
        this.myLabeler = labeler;
    }

    public void migrateClassTypeParameter(PsiReferenceParameterList referenceParameterList, PsiClassType migrationType) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiClass.class);
        LOG.assertTrue(psiClass != null);
        PsiClass superClass = psiClass.getSuperClass();
        LOG.assertTrue(superClass != null);
        this.myLabeler.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)superClass), (PsiType)migrationType);
        HashMap<PsiElement, Pair<PsiReference[], PsiType>> roots = new HashMap<PsiElement, Pair<PsiReference[], PsiType>>();
        this.markTypeParameterUsages(psiClass, migrationType, referenceParameterList, roots);
        HashSet processed = new HashSet();
        for (Map.Entry entry : roots.entrySet()) {
            PsiReference[] references;
            PsiElement member = (PsiElement)entry.getKey();
            PsiType type2 = (PsiType)((Pair)entry.getValue()).second;
            if (member instanceof PsiParameter && ((PsiParameter)member).getDeclarationScope() instanceof PsiMethod) {
                this.myLabeler.migrateMethodCallExpressions(type2, (PsiParameter)member, psiClass);
            }
            for (PsiReference usage : references = (PsiReference[])((Pair)entry.getValue()).first) {
                this.myLabeler.migrateRootUsageExpression(usage, processed);
            }
        }
    }

    private void markTypeParameterUsages(final PsiClass psiClass, PsiClassType migrationType, PsiReferenceParameterList referenceParameterList, final Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        final PsiSubstitutor[] fullHierarchySubstitutor = new PsiSubstitutor[]{migrationType.resolveGenerics().getSubstitutor()};
        RefactoringHierarchyUtil.processSuperTypes((PsiType)migrationType, new RefactoringHierarchyUtil.SuperTypeVisitor(){

            @Override
            public void visitType(PsiType aType) {
                fullHierarchySubstitutor[0] = fullHierarchySubstitutor[0].putAll(((PsiClassType)aType).resolveGenerics().getSubstitutor());
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }
        });
        PsiClass resolvedClass = (PsiClass)((PsiJavaCodeReferenceElement)referenceParameterList.getParent()).resolve();
        LOG.assertTrue(resolvedClass != null);
        HashSet<PsiClass> superClasses = new HashSet<PsiClass>();
        superClasses.add(resolvedClass);
        InheritanceUtil.getSuperClasses((PsiClass)resolvedClass, superClasses, (boolean)true);
        for (PsiClass superSuperClass : superClasses) {
            final HashSet typeParameters = ContainerUtil.newHashSet((Iterable)PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)superSuperClass));
            superSuperClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitMethod(PsiMethod method) {
                    super.visitMethod(method);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)method, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                    for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                        ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)parameter2, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                    }
                }

                public void visitField(PsiField field) {
                    super.visitField(field);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)field, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                }
            });
        }
    }

    private void processMemberType(PsiElement element, Set<PsiTypeParameter> typeParameters, PsiClass psiClass, PsiSubstitutor substitutor, Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        PsiType elementType = TypeMigrationLabeler.getElementType(element);
        if (elementType != null && PsiTypesUtil.mentionsTypeParameters((PsiType)elementType, typeParameters)) {
            PsiType memberType = substitutor.substitute(elementType);
            this.prepareMethodsChangeSignature(psiClass, element, memberType);
            List<PsiReference> refs = TypeMigrationLabeler.filterReferences(psiClass, (Query<? extends PsiReference>)ReferencesSearch.search((PsiElement)element, (SearchScope)psiClass.getUseScope()));
            roots.put(element, (Pair<PsiReference[], PsiType>)Pair.create((Object)this.myLabeler.markRootUsages(element, memberType, refs.toArray(PsiReference.EMPTY_ARRAY)), (Object)memberType));
        }
    }

    private void prepareMethodsChangeSignature(PsiClass currentClass, PsiElement memberToChangeSignature, PsiType memberType) {
        if (memberToChangeSignature instanceof PsiMethod) {
            PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)((PsiMethod)memberToChangeSignature), (boolean)true);
            if (method != null && method.getContainingClass() == currentClass) {
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)method), memberType, (PsiElement)method, false);
            }
        } else if (memberToChangeSignature instanceof PsiParameter && ((PsiParameter)memberToChangeSignature).getDeclarationScope() instanceof PsiMethod) {
            PsiParameter parameter2;
            PsiMethod superMethod = (PsiMethod)((PsiParameter)memberToChangeSignature).getDeclarationScope();
            int parameterIndex = superMethod.getParameterList().getParameterIndex((PsiParameter)memberToChangeSignature);
            PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)superMethod, (boolean)true);
            if (method != null && method.getContainingClass() == currentClass && !(parameter2 = Objects.requireNonNull(method.getParameterList().getParameter(parameterIndex))).getType().equals(memberType)) {
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)parameter2), memberType, (PsiElement)parameter2, false);
            }
        }
    }
}

