/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveAllClassesInFileHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classRefs.ClassInstanceScanner;
import com.intellij.refactoring.util.classRefs.ClassReferenceScanner;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveClassesOrPackagesProcessor.class);
    private final PsiElement[] myElementsToMove;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    @NotNull
    private final PackageWrapper myTargetPackage;
    private final MoveCallback myMoveCallback;
    @NotNull
    protected final MoveDestination myMoveDestination;
    protected NonCodeUsageInfo[] myNonCodeUsages;
    private boolean myOpenInEditor;
    private MultiMap<PsiElement, String> myConflicts;

    public MoveClassesOrPackagesProcessor(Project project, PsiElement[] elements, @NotNull MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (moveDestination == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        LinkedHashSet<Object> toMove = new LinkedHashSet<Object>();
        for (PsiElement element : elements) {
            PsiUtilCore.ensureValid((PsiElement)element);
            if (element instanceof PsiClassOwner) {
                PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
                if (classes2.length > 0) {
                    for (PsiClass aClass : classes2) {
                        PsiUtilCore.ensureValid((PsiElement)aClass);
                        toMove.add(aClass);
                    }
                    continue;
                }
                toMove.add(element);
                continue;
            }
            toMove.add(element);
        }
        this.myElementsToMove = PsiUtilCore.toPsiElementArray(toMove);
        Arrays.sort(this.myElementsToMove, (o1, o2) -> {
            VirtualFile virtualFile;
            PsiFile containingFile;
            if (o1 instanceof PsiClass && o2 instanceof PsiClass && Comparing.equal((Object)(containingFile = o1.getContainingFile()), (Object)o2.getContainingFile()) && (virtualFile = containingFile.getVirtualFile()) != null) {
                String fileName = virtualFile.getNameWithoutExtension();
                if (Comparing.strEqual((String)fileName, (String)((PsiClass)o1).getName())) {
                    return -1;
                }
                if (Comparing.strEqual((String)fileName, (String)((PsiClass)o2).getName())) {
                    return 1;
                }
            }
            return 0;
        });
        this.myMoveDestination = moveDestination;
        this.myTargetPackage = this.myMoveDestination.getTargetPackage();
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(1);
        }
        PsiElement[] elements = new PsiElement[this.myElementsToMove.length];
        System.arraycopy(this.myElementsToMove, 0, elements, 0, this.myElementsToMove.length);
        return new MoveMultipleElementsViewDescriptor(elements, MoveClassesOrPackagesUtil.getPackageName(this.myTargetPackage));
    }

    public boolean verifyValidPackageName() {
        PsiNameHelper helper;
        String qName = this.myTargetPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qName) && !(helper = PsiNameHelper.getInstance((Project)this.myProject)).isQualifiedName(qName)) {
            Messages.showMessageDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"invalid.target.package.name.specified", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"move.classes.invalid.package.name.warning.message", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> allUsages = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> usagesToSkip = new ArrayList<UsageInfo>();
        this.myConflicts = new MultiMap();
        for (PsiElement element : this.myElementsToMove) {
            String newName = this.getNewQName(element);
            if (newName == null) continue;
            UsageInfo[] usages = MoveClassesOrPackagesUtil.findUsages(element, this.myRefactoringScope, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
            ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>(Arrays.asList(usages));
            allUsages.addAll(infos);
            if (Comparing.strEqual((String)newName, (String)this.getOldQName(element))) {
                usagesToSkip.addAll(infos);
            }
            if (!(element instanceof PsiPackage)) continue;
            for (PsiDirectory directory : ((PsiPackage)element).getDirectories()) {
                UsageInfo[] dirUsages = MoveClassesOrPackagesUtil.findUsages((PsiElement)directory, this.myRefactoringScope, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
                allUsages.addAll(new ArrayList<UsageInfo>(Arrays.asList(dirUsages)));
            }
        }
        this.myMoveDestination.analyzeModuleConflicts(Arrays.asList(this.myElementsToMove), this.myConflicts, allUsages.toArray(UsageInfo.EMPTY_ARRAY));
        UsageInfo[] usageInfos = allUsages.toArray(UsageInfo.EMPTY_ARRAY);
        this.detectPackageLocalsMoved(usageInfos, this.myConflicts);
        MoveClassesOrPackagesProcessor.detectPackageLocalsUsed(this.myConflicts, this.myElementsToMove, this.myTargetPackage);
        allUsages.removeAll(usagesToSkip);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])allUsages.toArray(UsageInfo.EMPTY_ARRAY));
        if (usageInfoArray == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    public List<PsiElement> getElements() {
        return ContainerUtil.immutableList((Object[])this.myElementsToMove);
    }

    public PackageWrapper getTargetPackage() {
        return this.myMoveDestination.getTargetPackage();
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElementsToMove);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(3);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTargetPackage.getDirectories());
        data.addElement((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(this.myTargetPackage.getQualifiedName()));
        return data;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(4);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        return this.showConflicts(this.myConflicts, usages);
    }

    private boolean isInsideMoved(PsiElement place) {
        for (PsiElement element : this.myElementsToMove) {
            if (!(element instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    static void detectPackageLocalsUsed(MultiMap<PsiElement, String> conflicts, PsiElement[] elementsToMove, PackageWrapper targetPackage) {
        PackageLocalsUsageCollector visitor2 = new PackageLocalsUsageCollector(elementsToMove, targetPackage, conflicts);
        for (PsiElement element : elementsToMove) {
            if (element.getContainingFile() == null) continue;
            element.accept((PsiElementVisitor)visitor2);
        }
    }

    private void detectPackageLocalsMoved(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        HashSet<PsiClass> movedClasses = new HashSet<PsiClass>();
        HashMap<PsiClass, Set> reportedClassToContainers = new HashMap<PsiClass, Set>();
        for (UsageInfo usage : usages) {
            PsiPackage usagePackage;
            PsiDirectory directory;
            PsiElement element = usage.getElement();
            if (element == null || !(usage instanceof MoveRenameUsageInfo) || usage instanceof NonCodeUsageInfo || !(((MoveRenameUsageInfo)usage).getReferencedElement() instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)((MoveRenameUsageInfo)usage).getReferencedElement();
            movedClasses.add(aClass);
            if (aClass == null || !aClass.hasModifierProperty("packageLocal") || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) continue;
            PsiElement container = ConflictsUtil.getContainer(element);
            Set reported = reportedClassToContainers.computeIfAbsent(aClass, __ -> new HashSet());
            if (reported.contains(container)) continue;
            reported.add(container);
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || this.isInsideMoved(element) || (directory = containingFile.getContainingDirectory()) == null || (usagePackage = JavaDirectoryService.getInstance().getPackage(directory)) == null || this.myTargetPackage.equalToPackage(usagePackage)) continue;
            String message2 = JavaRefactoringBundle.message((String)"a.package.local.class.0.will.no.longer.be.accessible.from.1", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)aClass.getName()), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
            conflicts.putValue((Object)aClass, (Object)message2);
        }
        MyClassInstanceReferenceVisitor instanceReferenceVisitor = new MyClassInstanceReferenceVisitor(conflicts);
        for (PsiClass aClass : movedClasses) {
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList());
            if ("packageLocal".equals(visibility)) {
                MoveClassesOrPackagesProcessor.findInstancesOfPackageLocal(aClass, usages, instanceReferenceVisitor);
                continue;
            }
            MoveClassesOrPackagesProcessor.findPublicClassConflicts(aClass, instanceReferenceVisitor);
        }
    }

    private static void findPublicClassConflicts(PsiClass aClass, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        NonPublicClassMemberWrappersSet members = new NonPublicClassMemberWrappersSet();
        members.addElements((PsiMember[])aClass.getFields());
        members.addElements((PsiMember[])aClass.getMethods());
        members.addElements((PsiMember[])aClass.getInnerClasses());
        RefactoringUtil.IsDescendantOf isDescendantOf = new RefactoringUtil.IsDescendantOf(aClass);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        GlobalSearchScope packageScope = aPackage == null ? aClass.getResolveScope() : PackageScope.packageScopeWithoutLibraries((PsiPackage)aPackage, (boolean)false);
        for (ClassMemberWrapper memberWrapper : members) {
            ReferencesSearch.search((PsiElement)memberWrapper.getMember(), (SearchScope)packageScope, (boolean)false).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiReferenceExpression) {
                    PsiReferenceExpression expression2 = (PsiReferenceExpression)element;
                    PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                    if (qualifierExpression2 != null) {
                        PsiClass resolvedTypeClass;
                        PsiType type2 = qualifierExpression2.getType();
                        if (type2 != null && isDescendantOf.value(resolvedTypeClass = PsiUtil.resolveClassInType((PsiType)type2))) {
                            instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression2, isDescendantOf);
                        }
                    } else {
                        instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression2, isDescendantOf);
                    }
                }
                return true;
            });
        }
    }

    private static void findInstancesOfPackageLocal(final PsiClass aClass, final UsageInfo[] usages, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        ClassReferenceScanner referenceScanner = new ClassReferenceScanner(aClass){

            @Override
            public PsiReference[] findReferences() {
                ArrayList<PsiReference> result = new ArrayList<PsiReference>();
                for (UsageInfo usage : usages) {
                    PsiReference reference;
                    if (!(usage instanceof MoveRenameUsageInfo) || ((MoveRenameUsageInfo)usage).getReferencedElement() != aClass || (reference = usage.getReference()) == null) continue;
                    result.add(reference);
                }
                return result.toArray(PsiReference.EMPTY_ARRAY);
            }
        };
        referenceScanner.processReferences(new ClassInstanceScanner(aClass, instanceReferenceVisitor));
    }

    @Nullable
    private String getNewQName(PsiElement element) {
        String qualifiedName = this.myTargetPackage.getQualifiedName();
        if (element instanceof PsiClass) {
            return StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)((PsiClass)element).getName()));
        }
        if (element instanceof PsiPackage) {
            return StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)((PsiPackage)element).getName()));
        }
        if (element instanceof PsiClassOwner) {
            return ((PsiClassOwner)element).getName();
        }
        LOG.assertTrue(false);
        return null;
    }

    @Nullable
    private String getOldQName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClassOwner) {
            return ((PsiClassOwner)element).getName();
        }
        LOG.assertTrue(false);
        return null;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(6);
        }
        if (UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        ProgressIndicator indicator;
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(7);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setIndeterminate(false);
        }
        try {
            PsiClass psiClass;
            HashMap<PsiClass, Boolean> allClasses = new HashMap<PsiClass, Boolean>();
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass) || allClasses.containsKey(psiClass = (PsiClass)element)) continue;
                for (MoveAllClassesInFileHandler fileHandler : MoveAllClassesInFileHandler.EP_NAME.getExtensionList()) {
                    fileHandler.processMoveAllClassesInFile(allClasses, psiClass, this.myElementsToMove);
                }
            }
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                MoveClassesOrPackagesUtil.prepareMoveClass((PsiClass)element);
            }
            HashMap<Object, Object> oldToNewElementsMapping = new HashMap<Object, Object>();
            RefactoringElementListener[] listeners = (RefactoringElementListener[])Arrays.stream(this.myElementsToMove).map(psiElement -> this.getTransaction().getElementListener(psiElement)).toArray(RefactoringElementListener[]::new);
            for (int idx = 0; idx < this.myElementsToMove.length; ++idx) {
                PsiPackage newElement;
                PsiElement element;
                element = this.myElementsToMove[idx];
                if (element instanceof PsiPackage) {
                    PsiDirectory[] directories = ((PsiPackage)element).getDirectories();
                    newElement = MoveClassesOrPackagesUtil.doMovePackage((PsiPackage)element, this.myMoveDestination);
                    LOG.assertTrue(newElement != null, (Object)element);
                    oldToNewElementsMapping.put(element, newElement);
                    int i = 0;
                    PsiDirectory[] newDirectories = newElement.getDirectories();
                    if (newDirectories.length == 1) {
                        for (PsiDirectory directory : directories) {
                            oldToNewElementsMapping.put(directory, newDirectories[0]);
                        }
                    } else {
                        for (PsiDirectory directory : directories) {
                            if (this.myMoveDestination.verify(directory) != null) continue;
                            oldToNewElementsMapping.put(directory, newDirectories[i++]);
                        }
                    }
                    element = newElement;
                } else if (element instanceof PsiClass) {
                    psiClass = (PsiClass)element;
                    newElement = MoveClassesOrPackagesUtil.doMoveClass(psiClass, this.myMoveDestination.getTargetDirectory(element.getContainingFile()), (Boolean)allClasses.get(psiClass));
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else if (element instanceof PsiClassOwner) {
                    String qualifiedName;
                    PsiDirectory directory = this.myMoveDestination.getTargetDirectory(element.getContainingFile());
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiClassOwner)element), (PsiDirectory)directory);
                    newElement = directory.findFile(((PsiClassOwner)element).getName());
                    LOG.assertTrue(newElement != null);
                    DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
                    PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (newPackage != null && !Comparing.strEqual((String)(qualifiedName = newPackage.getQualifiedName()), (String)((PsiClassOwner)newElement).getPackageName()) && (qualifiedName.isEmpty() || PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(qualifiedName))) {
                        ((PsiClassOwner)newElement).setPackageName(qualifiedName);
                    }
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else {
                    LOG.error("Unexpected element to move: " + element);
                }
                listeners[idx].elementMoved(element);
                this.myElementsToMove[idx] = element;
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages((UsageInfo[])usages, oldToNewElementsMapping);
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                MoveClassesOrPackagesUtil.finishMoveClass((PsiClass)element);
            }
            if (this.myOpenInEditor) {
                ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])Arrays.stream(this.myElementsToMove).filter(PsiElement::isValid).toArray(PsiElement[]::new))));
            }
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesOrPackagesMoved(this.myMoveDestination);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @NotNull
    protected String getCommandName() {
        String elements = RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElementsToMove);
        String target = this.myTargetPackage.getQualifiedName();
        String string = JavaRefactoringBundle.message((String)"move.classes.command", (Object[])new Object[]{elements, target});
        if (string == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonPublicClassMemberWrappersSet
    extends HashSet<ClassMemberWrapper> {
        private NonPublicClassMemberWrappersSet() {
        }

        public void addElement(PsiMember member) {
            PsiNamedElement namedElement = (PsiNamedElement)member;
            if (member.hasModifierProperty("public")) {
                return;
            }
            if (member.hasModifierProperty("private")) {
                return;
            }
            this.add(new ClassMemberWrapper(namedElement));
        }

        public void addElements(PsiMember[] members) {
            for (PsiMember member : members) {
                this.addElement(member);
            }
        }
    }

    private class MyClassInstanceReferenceVisitor
    implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
        private final MultiMap<PsiElement, String> myConflicts;
        private final Map<PsiModifierListOwner, HashSet<PsiElement>> myReportedElementToContainer = new HashMap<PsiModifierListOwner, HashSet<PsiElement>>();
        private final Map<PsiClass, RefactoringUtil.IsDescendantOf> myIsDescendantOfCache = new HashMap<PsiClass, RefactoringUtil.IsDescendantOf>();

        MyClassInstanceReferenceVisitor(MultiMap<PsiElement, String> conflicts) {
            this.myConflicts = conflicts;
        }

        @Override
        public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
            PsiElement resolved = qualified.resolve();
            if (resolved instanceof PsiMember) {
                PsiMember member = (PsiMember)resolved;
                PsiClass containingClass = member.getContainingClass();
                RefactoringUtil.IsDescendantOf isDescendantOf = this.myIsDescendantOfCache.get(containingClass);
                if (isDescendantOf == null) {
                    isDescendantOf = new RefactoringUtil.IsDescendantOf(containingClass);
                    this.myIsDescendantOfCache.put(containingClass, isDescendantOf);
                }
                this.visitMemberReference((PsiModifierListOwner)member, qualified, isDescendantOf);
            }
        }

        private synchronized void visitMemberReference(PsiModifierListOwner member, PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            if (member.hasModifierProperty("packageLocal")) {
                this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
            } else if (member.hasModifierProperty("protected")) {
                PsiExpression qualifier = qualified.getQualifierExpression();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                } else if (!this.isInInheritor(qualified, descendantOf)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member);
                }
            }
        }

        private boolean isInInheritor(PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)qualified, PsiClass.class);
            while (aClass != null) {
                if (descendantOf.value(aClass)) {
                    return true;
                }
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            }
            return false;
        }

        private void visitPackageLocalMemberReference(PsiJavaCodeReferenceElement qualified, PsiModifierListOwner member) {
            PsiElement container = ConflictsUtil.getContainer((PsiElement)qualified);
            Set reportedContainers = this.myReportedElementToContainer.computeIfAbsent(member, __ -> new HashSet());
            if (!reportedContainers.contains(container)) {
                PsiDirectory directory;
                PsiFile containingFile;
                reportedContainers.add(container);
                if (!MoveClassesOrPackagesProcessor.this.isInsideMoved(container) && (containingFile = container.getContainingFile()) != null && (directory = containingFile.getContainingDirectory()) != null) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (!MoveClassesOrPackagesProcessor.this.myTargetPackage.equalToPackage(aPackage)) {
                        String message2 = JavaRefactoringBundle.message((String)"0.will.be.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
                        this.myConflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
                    }
                }
            }
        }

        @Override
        public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
        }

        @Override
        public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
        }

        @Override
        public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
        }
    }

    static class ClassMemberWrapper {
        final PsiNamedElement myElement;
        final PsiModifierListOwner myMember;

        ClassMemberWrapper(PsiNamedElement element) {
            this.myElement = element;
            this.myMember = (PsiModifierListOwner)element;
        }

        PsiModifierListOwner getMember() {
            return this.myMember;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassMemberWrapper)) {
                return false;
            }
            ClassMemberWrapper wrapper = (ClassMemberWrapper)o;
            if (this.myElement instanceof PsiMethod) {
                return wrapper.myElement instanceof PsiMethod && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)this.myElement), (PsiMethod)((PsiMethod)wrapper.myElement));
            }
            return Comparing.equal((String)this.myElement.getName(), (String)wrapper.myElement.getName());
        }

        public int hashCode() {
            String name2 = this.myElement.getName();
            if (name2 != null) {
                return name2.hashCode();
            }
            return 0;
        }
    }
}

