/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class InlineToAnonymousConstructorProcessor {
    private static final Logger LOG = Logger.getInstance(InlineToAnonymousConstructorProcessor.class);
    private static final Key<PsiAssignmentExpression> ourAssignmentKey = Key.create((String)"assignment");
    private static final Key<PsiCallExpression> ourCallKey = Key.create((String)"call");
    public static final ElementPattern ourNullPattern = PlatformPatterns.psiElement(PsiLiteralExpression.class).withText("null");
    private static final ElementPattern ourAssignmentPattern = PsiJavaPatterns.psiExpressionStatement().withChild((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class).save(ourAssignmentKey));
    private static final ElementPattern ourSuperCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiMethodCallExpression.class).save(ourCallKey)).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("super")));
    private static final ElementPattern ourThisCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)PlatformPatterns.psiElement(PsiMethodCallExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("this")));
    private final PsiClass myClass;
    private PsiNewExpression myNewExpression;
    private final PsiType mySuperType;
    private final Map<String, PsiExpression> myFieldInitializers = new HashMap<String, PsiExpression>();
    private final Map<PsiParameter, PsiVariable> myLocalsForParameters = new HashMap<PsiParameter, PsiVariable>();
    private PsiElement myNewStatement;
    private final PsiElementFactory myElementFactory;
    private PsiMethod myConstructor;
    private PsiExpression[] myConstructorArguments;
    private PsiParameterList myConstructorParameters;

    InlineToAnonymousConstructorProcessor(PsiClass aClass, PsiNewExpression psiNewExpression, PsiType superType) {
        this.myClass = aClass;
        this.myNewExpression = psiNewExpression;
        this.mySuperType = superType;
        this.myNewStatement = PsiTreeUtil.getParentOfType((PsiElement)this.myNewExpression, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject());
    }

    public void run() throws IncorrectOperationException {
        this.checkInlineChainingConstructor();
        JavaResolveResult classResolveResult = this.myNewExpression.getClassReference().advancedResolve(false);
        JavaResolveResult methodResolveResult = this.myNewExpression.resolveMethodGenerics();
        PsiElement element = methodResolveResult.getElement();
        this.myConstructor = element != null ? (PsiMethod)element.getNavigationElement() : null;
        this.myConstructorArguments = this.initConstructorArguments();
        PsiSubstitutor classResolveSubstitutor = classResolveResult.getSubstitutor();
        PsiType substType = classResolveSubstitutor.substitute(this.mySuperType);
        PsiTypeParameter[] typeParams = this.myClass.getTypeParameters();
        PsiType[] substitutedParameters = PsiType.createArray((int)typeParams.length);
        for (int i = 0; i < typeParams.length; ++i) {
            substitutedParameters[i] = classResolveSubstitutor.substitute(typeParams[i]);
        }
        StringBuilder builder = new StringBuilder("new ");
        builder.append(substType.getCanonicalText());
        builder.append("() {}");
        PsiNewExpression superNewExpressionTemplate = (PsiNewExpression)this.myElementFactory.createExpressionFromText(builder.toString(), (PsiElement)this.myNewExpression.getContainingFile());
        PsiClassInitializer initializerBlock = this.myElementFactory.createClassInitializer();
        PsiVariable outerClassLocal = null;
        if (this.myNewExpression.getQualifier() != null && this.myClass.getContainingClass() != null) {
            outerClassLocal = this.generateOuterClassLocal();
        }
        if (this.myConstructor != null) {
            this.myConstructorParameters = this.myConstructor.getParameterList();
            PsiExpressionList argumentList = superNewExpressionTemplate.getArgumentList();
            assert (argumentList != null);
            if (this.myNewStatement != null) {
                this.generateLocalsForArguments();
            }
            this.analyzeConstructor(initializerBlock.getBody());
            this.addSuperConstructorArguments(argumentList);
        }
        ChangeContextUtil.encodeContextInfo(this.myClass.getNavigationElement(), true);
        PsiClass classCopy = (PsiClass)this.myClass.getNavigationElement().copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myClass);
        PsiAnonymousClass anonymousClass = superNewExpressionTemplate.getAnonymousClass();
        assert (anonymousClass != null);
        int fieldCount = this.myClass.getFields().length;
        int processedFields = 0;
        PsiElement token = anonymousClass.getRBrace();
        if (!initializerBlock.getBody().isEmpty() && fieldCount == 0) {
            this.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        for (PsiElement child : classCopy.getChildren()) {
            if (child instanceof PsiMethod && !((PsiMethod)child).isConstructor() || child instanceof PsiClassInitializer || child instanceof PsiClass) {
                if (!this.myFieldInitializers.isEmpty() || !this.myLocalsForParameters.isEmpty() || classResolveSubstitutor != PsiSubstitutor.EMPTY || outerClassLocal != null) {
                    this.replaceReferences((PsiMember)child, substitutedParameters, outerClassLocal);
                }
                child = anonymousClass.addBefore(child, token);
                continue;
            }
            if (!(child instanceof PsiField)) continue;
            PsiField field = (PsiField)child;
            this.replaceReferences((PsiMember)field, substitutedParameters, outerClassLocal);
            PsiExpression initializer = this.myFieldInitializers.get(field.getName());
            field = (PsiField)anonymousClass.addBefore((PsiElement)field, token);
            if (initializer != null) {
                field.setInitializer(initializer);
            }
            if (++processedFields != fieldCount || initializerBlock.getBody().isEmpty()) continue;
            this.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        if (PsiTreeUtil.getChildrenOfType((PsiElement)anonymousClass, PsiMember.class) == null) {
            anonymousClass.deleteChildRange(anonymousClass.getLBrace(), anonymousClass.getRBrace());
        }
        PsiNewExpression superNewExpression = (PsiNewExpression)this.myNewExpression.replace((PsiElement)superNewExpressionTemplate);
        PsiAnonymousClass newExpressionAnonymousClass = (superNewExpression = (PsiNewExpression)ChangeContextUtil.decodeContextInfo((PsiElement)superNewExpression, (PsiClass)superNewExpression.getAnonymousClass(), null)).getAnonymousClass();
        if (newExpressionAnonymousClass != null && AnonymousCanBeLambdaInspection.isLambdaForm(newExpressionAnonymousClass, false, Collections.emptySet())) {
            PsiExpression lambda2 = AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)superNewExpression, (PsiType)newExpressionAnonymousClass.getBaseClassType());
            JavaCodeStyleManager.getInstance((Project)newExpressionAnonymousClass.getProject()).shortenClassReferences(superNewExpression.replace((PsiElement)lambda2));
        } else {
            JavaCodeStyleManager.getInstance((Project)superNewExpression.getProject()).shortenClassReferences((PsiElement)superNewExpression);
        }
    }

    private void insertInitializerBefore(PsiClassInitializer initializerBlock, PsiClass anonymousClass, PsiElement token) throws IncorrectOperationException {
        anonymousClass.addBefore(CodeEditUtil.createLineFeed((PsiManager)token.getManager()), token);
        anonymousClass.addBefore((PsiElement)initializerBlock, token);
        anonymousClass.addBefore(CodeEditUtil.createLineFeed((PsiManager)token.getManager()), token);
    }

    private void checkInlineChainingConstructor() {
        PsiMethod constructor;
        while ((constructor = this.myNewExpression.resolveConstructor()) != null && InlineUtil.isChainingConstructor(constructor)) {
            InlineMethodProcessor.inlineConstructorCall((PsiCall)this.myNewExpression);
        }
    }

    private void analyzeConstructor(PsiCodeBlock initializerBlock) throws IncorrectOperationException {
        PsiCodeBlock body2 = this.myConstructor.getBody();
        assert (body2 != null);
        for (PsiElement child : body2.getChildren()) {
            if (child instanceof PsiStatement) {
                PsiStatement stmt = (PsiStatement)child;
                ProcessingContext context = new ProcessingContext();
                if (ourAssignmentPattern.accepts((Object)stmt, context)) {
                    PsiAssignmentExpression expression2 = (PsiAssignmentExpression)context.get(ourAssignmentKey);
                    if (!this.processAssignmentInConstructor(expression2)) continue;
                    initializerBlock.addBefore(this.replaceParameterReferences((PsiElement)stmt, null, false), (PsiElement)initializerBlock.getRBrace());
                    continue;
                }
                if (ourSuperCallPattern.accepts((Object)stmt) || ourThisCallPattern.accepts((Object)stmt)) continue;
                this.replaceParameterReferences((PsiElement)stmt, new ArrayList(), false);
                initializerBlock.addBefore((PsiElement)stmt, (PsiElement)initializerBlock.getRBrace());
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            if (child.getPrevSibling() instanceof PsiWhiteSpace) {
                initializerBlock.addBefore(child.getPrevSibling(), (PsiElement)initializerBlock.getRBrace());
            }
            initializerBlock.addBefore(child, (PsiElement)initializerBlock.getRBrace());
        }
    }

    private boolean processAssignmentInConstructor(PsiAssignmentExpression expression2) {
        if (expression2.getLExpression() instanceof PsiReferenceExpression) {
            PsiReferenceExpression lExpr = (PsiReferenceExpression)expression2.getLExpression();
            PsiExpression rExpr = expression2.getRExpression();
            if (rExpr == null) {
                return false;
            }
            PsiElement psiElement = lExpr.resolve();
            if (psiElement instanceof PsiField) {
                PsiField field = (PsiField)psiElement;
                if (this.myClass.getManager().areElementsEquivalent((PsiElement)field.getContainingClass(), (PsiElement)this.myClass)) {
                    PsiExpression initializer;
                    ArrayList localVarRefs = new ArrayList();
                    try {
                        initializer = (PsiExpression)this.replaceParameterReferences(rExpr.copy(), localVarRefs, false);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return false;
                    }
                    if (!localVarRefs.isEmpty()) {
                        return true;
                    }
                    this.myFieldInitializers.put(field.getName(), initializer);
                }
            } else if (psiElement instanceof PsiVariable) {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstant(PsiExpression expr2) {
        Object constantValue = JavaPsiFacade.getInstance((Project)expr2.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr2);
        return constantValue != null || ourNullPattern.accepts((Object)expr2);
    }

    private PsiVariable generateOuterClassLocal() {
        PsiClass outerClass = this.myClass.getContainingClass();
        assert (outerClass != null);
        return this.generateLocal(StringUtil.decapitalize((String)StringUtil.notNullize((String)outerClass.getName())), (PsiType)this.myElementFactory.createType(outerClass), this.myNewExpression.getQualifier());
    }

    private PsiVariable generateLocal(String baseName, PsiType type2, PsiExpression initializer) {
        String localName;
        Project project = this.myClass.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String baseNameForIndex = baseName;
        int index = 0;
        while (this.myClass.findFieldByName(localName = codeStyleManager.suggestUniqueVariableName(baseNameForIndex, (PsiElement)this.myNewExpression, true), false) != null) {
            baseNameForIndex = baseName + ++index;
        }
        try {
            PsiElement parent;
            PsiDeclarationStatement declaration2 = this.myElementFactory.createVariableDeclarationStatement(localName, type2, initializer);
            PsiVariable variable = (PsiVariable)declaration2.getDeclaredElements()[0];
            if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myNewExpression) || JavaCodeStyleSettings.getInstance((PsiFile)initializer.getContainingFile()).GENERATE_FINAL_LOCALS) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
            }
            if ((parent = this.myNewStatement.getParent()) instanceof PsiCodeBlock) {
                variable = (PsiVariable)((PsiDeclarationStatement)parent.addBefore((PsiElement)declaration2, this.myNewStatement)).getDeclaredElements()[0];
            } else if (this.myNewStatement instanceof PsiLambdaExpression) {
                Object marker = new Object();
                PsiTreeUtil.mark((PsiElement)this.myNewExpression, (Object)marker);
                PsiCodeBlock block = RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)this.myNewStatement);
                this.myNewStatement = block.getStatements()[0];
                this.myNewExpression = (PsiNewExpression)PsiTreeUtil.releaseMark((PsiElement)this.myNewStatement, (Object)marker);
                variable = (PsiVariable)((PsiDeclarationStatement)block.addBefore((PsiElement)declaration2, this.myNewStatement)).getDeclaredElements()[0];
                this.myConstructorArguments = this.initConstructorArguments();
            } else {
                int offsetInStatement = this.myNewExpression.getTextRange().getStartOffset() - this.myNewStatement.getTextRange().getStartOffset();
                PsiBlockStatement blockStatement = (PsiBlockStatement)this.myElementFactory.createStatementFromText("{}", null);
                PsiCodeBlock block = blockStatement.getCodeBlock();
                block.add((PsiElement)declaration2);
                block.add(this.myNewStatement);
                block = ((PsiBlockStatement)this.myNewStatement.replace((PsiElement)blockStatement)).getCodeBlock();
                variable = (PsiVariable)((PsiDeclarationStatement)block.getStatements()[0]).getDeclaredElements()[0];
                this.myNewStatement = block.getStatements()[1];
                this.myNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myNewStatement.findElementAt(offsetInStatement), PsiNewExpression.class);
                this.myConstructorArguments = this.initConstructorArguments();
            }
            return variable;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiExpression[] initConstructorArguments() {
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        return argumentList != null ? argumentList.getExpressions() : PsiExpression.EMPTY_ARRAY;
    }

    private void generateLocalsForArguments() {
        for (int i = 0; i < this.myConstructorArguments.length; ++i) {
            PsiExpression expr2 = this.myConstructorArguments[i];
            PsiParameter parameter2 = this.myConstructorParameters.getParameters()[i];
            if (parameter2.isVarArgs()) {
                PsiEllipsisType ellipsisType = (PsiEllipsisType)parameter2.getType();
                PsiType baseType = ellipsisType.getComponentType();
                StringBuilder exprBuilder = new StringBuilder("new ");
                exprBuilder.append(baseType.getCanonicalText());
                exprBuilder.append("[] { }");
                try {
                    PsiNewExpression newExpr = (PsiNewExpression)this.myElementFactory.createExpressionFromText(exprBuilder.toString(), (PsiElement)this.myClass);
                    PsiArrayInitializerExpression arrayInitializer = newExpr.getArrayInitializer();
                    assert (arrayInitializer != null);
                    for (int j = i; j < this.myConstructorArguments.length; ++j) {
                        arrayInitializer.add((PsiElement)this.myConstructorArguments[j]);
                    }
                    PsiVariable variable = this.generateLocal(parameter2.getName(), ellipsisType.toArrayType(), (PsiExpression)newExpr);
                    this.myLocalsForParameters.put(parameter2, variable);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                break;
            }
            if (InlineToAnonymousConstructorProcessor.isConstant(expr2)) continue;
            PsiVariable variable = this.generateLocal(parameter2.getName(), parameter2.getType(), expr2);
            this.myLocalsForParameters.put(parameter2, variable);
        }
    }

    private void addSuperConstructorArguments(PsiExpressionList argumentList) throws IncorrectOperationException {
        PsiCodeBlock body2 = this.myConstructor.getBody();
        assert (body2 != null);
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (!ourSuperCallPattern.accepts((Object)statements[0], context)) {
            return;
        }
        PsiExpressionList superArguments = ((PsiCallExpression)context.get(ourCallKey)).getArgumentList();
        if (superArguments != null) {
            for (PsiExpression argument : superArguments.getExpressions()) {
                PsiElement superArgument = this.replaceParameterReferences(argument.copy(), new ArrayList(), true);
                argumentList.add(superArgument);
            }
        }
    }

    private PsiElement replaceParameterReferences(PsiElement argument, final @Nullable List<? super PsiReferenceExpression> localVarRefs, final boolean replaceFieldsWithInitializers) throws IncorrectOperationException {
        PsiElement element;
        if (argument instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)argument).resolve()) instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)element;
            if (this.myLocalsForParameters.containsKey(parameter2)) {
                return argument.replace((PsiElement)this.getParameterReference(parameter2));
            }
            int index = this.myConstructorParameters.getParameterIndex(parameter2);
            return argument.replace((PsiElement)this.myConstructorArguments[index]);
        }
        final ArrayList parameterReferences = new ArrayList();
        final HashMap<PsiElement, PsiElement> elementsToReplace = new HashMap<PsiElement, PsiElement>();
        argument.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement psiElement = expression2.resolve();
                if (psiElement instanceof PsiParameter && ((PsiParameter)psiElement).getDeclarationScope() == InlineToAnonymousConstructorProcessor.this.myConstructor) {
                    parameterReferences.add(Pair.create((Object)expression2, (Object)((PsiParameter)psiElement)));
                } else if ((psiElement instanceof PsiField || psiElement instanceof PsiMethod) && ((PsiMember)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass()) {
                    PsiMember member = (PsiMember)psiElement;
                    if (member.hasModifierProperty("static") && expression2.getQualifierExpression() == null) {
                        String qualifiedText = InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass().getQualifiedName() + "." + member.getName();
                        try {
                            PsiExpression replacement = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(qualifiedText, (PsiElement)InlineToAnonymousConstructorProcessor.this.myClass);
                            elementsToReplace.put(expression2, replacement);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                } else if (psiElement instanceof PsiVariable) {
                    PsiExpression initializer;
                    if (localVarRefs != null) {
                        localVarRefs.add(expression2);
                    }
                    if (replaceFieldsWithInitializers && psiElement instanceof PsiField && ((PsiField)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass && InlineToAnonymousConstructorProcessor.isConstant(initializer = ((PsiField)psiElement).getInitializer())) {
                        elementsToReplace.put(expression2, initializer);
                    }
                }
            }
        });
        for (Pair pair2 : parameterReferences) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair2.first;
            PsiParameter param = (PsiParameter)pair2.second;
            if (this.myLocalsForParameters.containsKey(param)) {
                ref.replace((PsiElement)this.getParameterReference(param));
                continue;
            }
            int index = this.myConstructorParameters.getParameterIndex(param);
            if (ref == argument) {
                argument = argument.replace((PsiElement)this.myConstructorArguments[index]);
                continue;
            }
            ref.replace((PsiElement)this.myConstructorArguments[index]);
        }
        return RefactoringUtil.replaceElementsWithMap(argument, elementsToReplace);
    }

    private PsiExpression getParameterReference(PsiParameter parameter2) throws IncorrectOperationException {
        PsiVariable variable = this.myLocalsForParameters.get(parameter2);
        return this.myElementFactory.createExpressionFromText(variable.getName(), (PsiElement)this.myClass);
    }

    private void replaceReferences(final PsiMember method, final PsiType[] substitutedParameters, final PsiVariable outerClassLocal) throws IncorrectOperationException {
        final HashMap<PsiElement, PsiElement> elementsToReplace = new HashMap<PsiElement, PsiElement>();
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement element = expression2.resolve();
                if (element instanceof PsiField) {
                    try {
                        PsiField field = (PsiField)element;
                        if (InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() != null && field.getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() && outerClassLocal != null) {
                            PsiReferenceExpression expr2 = (PsiReferenceExpression)expression2.copy();
                            PsiExpression qualifier = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(outerClassLocal.getName(), (PsiElement)field.getContainingClass());
                            expr2.setQualifierExpression(qualifier);
                            elementsToReplace.put(expression2, expr2);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public void visitTypeParameter(PsiTypeParameter classParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                super.visitTypeParameter(classParameter);
                PsiReferenceList list = classParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement reference : referenceElements = list.getReferenceElements()) {
                    PsiElement psiElement = reference.resolve();
                    if (!(psiElement instanceof PsiTypeParameter)) continue;
                    this.checkReplaceTypeParameter((PsiElement)reference, (PsiTypeParameter)psiElement);
                }
            }

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiClassType classType;
                PsiClass psiClass;
                super.visitTypeElement(typeElement);
                if (typeElement.getType() instanceof PsiClassType && (psiClass = (classType = (PsiClassType)typeElement.getType()).resolve()) instanceof PsiTypeParameter) {
                    this.checkReplaceTypeParameter((PsiElement)typeElement, (PsiTypeParameter)psiClass);
                }
            }

            private void checkReplaceTypeParameter(PsiElement element, PsiTypeParameter target) {
                PsiClass containingClass = method.getContainingClass();
                PsiTypeParameter[] psiTypeParameters = containingClass.getTypeParameters();
                for (int i = 0; i < psiTypeParameters.length; ++i) {
                    if (psiTypeParameters[i] != target) continue;
                    PsiType substType = substitutedParameters[i];
                    if (substType == null) {
                        substType = PsiType.getJavaLangObject((PsiManager)element.getManager(), (GlobalSearchScope)ProjectScope.getAllScope((Project)element.getProject()));
                    }
                    if (element instanceof PsiJavaCodeReferenceElement) {
                        LOG.assertTrue(substType instanceof PsiClassType);
                        elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createReferenceElementByType((PsiClassType)substType));
                        continue;
                    }
                    elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createTypeElement(substType));
                }
            }
        });
        RefactoringUtil.replaceElementsWithMap((PsiElement)method, elementsToReplace);
    }
}

