/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;

public class InlineMethodSpecialization {
    private static final CallMatcher CLASS_METHODS = CallMatcher.exactInstanceCall("java.lang.Class", "getName", "getSimpleName").parameterCount(0);
    private static final CallMatcher ENUM_NAME = CallMatcher.exactInstanceCall("java.lang.Enum", "name").parameterCount(0);
    private static final CallMapper<Supplier<PsiCodeBlock>> SPECIALIZATIONS = new CallMapper<Function<PsiMethodCallExpression, Supplier>>().register(CLASS_METHODS, call -> {
        PsiReferenceExpression ref = call.getMethodExpression();
        PsiExpression qualifier = ref.getQualifierExpression();
        PsiClassObjectAccessExpression receiver2 = (PsiClassObjectAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiClassObjectAccessExpression.class);
        if (receiver2 == null) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)receiver2.getOperand().getType());
        if (psiClass == null) {
            return null;
        }
        String name2 = "getSimpleName".equals(ref.getReferenceName()) ? psiClass.getName() : psiClass.getQualifiedName();
        return InlineMethodSpecialization.getStringSupplier((PsiElement)call, name2);
    }).register(ENUM_NAME, call -> {
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiEnumConstant.class);
        if (enumConstant == null) {
            return null;
        }
        return InlineMethodSpecialization.getStringSupplier((PsiElement)call, enumConstant.getName());
    }).register((CallMatcher)CallMatcher.enumValueOf(), call -> {
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiClass cls = (PsiClass)ObjectUtils.tryCast((Object)qualifier.resolve(), PsiClass.class);
        if (cls == null || !cls.isEnum()) {
            return null;
        }
        PsiLiteralExpression literal = ExpressionUtils.getLiteral(call.getArgumentList().getExpressions()[0]);
        if (literal == null) {
            return null;
        }
        String name2 = (String)ObjectUtils.tryCast((Object)literal.getValue(), String.class);
        if (name2 == null) {
            return null;
        }
        PsiEnumConstant constant = (PsiEnumConstant)ObjectUtils.tryCast((Object)cls.findFieldByName(name2, false), PsiEnumConstant.class);
        if (constant == null) {
            return null;
        }
        return () -> {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
            return factory.createCodeBlockFromText("{return " + qualifier.getText() + "." + constant.getName() + ";}", (PsiElement)call);
        };
    });

    @Contract(value="_, null -> null", pure=true)
    private static Supplier<PsiCodeBlock> getStringSupplier(PsiElement context, String name2) {
        if (name2 == null) {
            return null;
        }
        return () -> {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            return factory.createCodeBlockFromText("{return \"" + StringUtil.escapeStringCharacters((String)name2) + "\";}", context);
        };
    }

    static Supplier<PsiCodeBlock> forReference(PsiReference ref) {
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiReferenceExpression)ref).getParent(), PsiMethodCallExpression.class);
        return SPECIALIZATIONS.mapFirst(call);
    }

    static PsiMethod specialize(PsiMethod method, PsiReference ref) {
        Supplier<PsiCodeBlock> specialization = InlineMethodSpecialization.forReference(ref);
        if (specialization == null) {
            return method;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        String parameters2 = method.getParameterList().getText();
        PsiType returnType = method.getReturnType();
        String type2 = returnType == null ? "" : returnType.getCanonicalText(true);
        PsiMethod copy = factory.createMethodFromText(type2 + " " + method.getName() + parameters2 + " {}", (PsiElement)method);
        Objects.requireNonNull(copy.getBody()).replace((PsiElement)specialization.get());
        return copy;
    }
}

