/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractclass.BackpointerUtil;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExtractedClassBuilder {
    private static final Logger LOGGER = Logger.getInstance(ExtractedClassBuilder.class);
    private String className;
    private String packageName;
    private final List<PsiField> fields = new ArrayList<PsiField>(5);
    private final List<PsiMethod> methods = new ArrayList<PsiMethod>(5);
    private final List<PsiClassInitializer> initializers = new ArrayList<PsiClassInitializer>(5);
    private final List<PsiClass> innerClasses = new ArrayList<PsiClass>(5);
    private final List<PsiClass> innerClassesToMakePublic = new ArrayList<PsiClass>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private final List<PsiClass> interfaces = new ArrayList<PsiClass>();
    private boolean requiresBackPointer;
    private String originalClassName;
    private String backPointerName;
    private Project myProject;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private Set<PsiField> myFieldsNeedingSetters;
    private Set<PsiField> myFieldsNeedingGetter;
    private List<? extends PsiField> enumConstantFields;
    private PsiType myEnumParameterType;

    ExtractedClassBuilder() {
    }

    public void setClassName(String className2) {
        this.className = className2;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOriginalClassName(String originalClassName) {
        this.originalClassName = originalClassName;
    }

    public void addField(PsiField field) {
        this.fields.add(field);
    }

    public void addMethod(PsiMethod method) {
        this.methods.add(method);
    }

    public void addInitializer(PsiClassInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addInnerClass(PsiClass innerClass, boolean makePublic) {
        this.innerClasses.add(innerClass);
        if (makePublic) {
            this.innerClassesToMakePublic.add(innerClass);
        }
    }

    public void setTypeArguments(List<? extends PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setInterfaces(List<? extends PsiClass> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    public String buildBeanClass(boolean normalizeDeclaration) {
        boolean first;
        if (this.requiresBackPointer) {
            this.calculateBackpointerName();
        }
        StringBuffer out = new StringBuffer(1024);
        if (this.packageName.length() > 0) {
            out.append("package " + this.packageName + ';');
        }
        out.append("public ");
        this.fields.removeAll(this.enumConstantFields);
        out.append(this.hasEnumConstants() ? "enum " : "class ");
        out.append(this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        if (!this.interfaces.isEmpty()) {
            out.append(" implements ");
            first = true;
            for (PsiClass implemented : this.interfaces) {
                if (!first) {
                    out.append(',');
                }
                out.append(implemented.getQualifiedName());
                first = false;
            }
        }
        out.append('{');
        if (this.requiresBackPointer) {
            out.append("private final " + this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ' + this.backPointerName + ";");
        }
        this.outputFieldsAndInitializers(out, normalizeDeclaration);
        if (this.hasEnumConstants()) {
            String fieldName = this.getValueFieldName();
            out.append("\n").append("private ").append(this.myEnumParameterType.getCanonicalText()).append(" ").append(fieldName).append(";\n");
            out.append("public ").append(this.myEnumParameterType.getCanonicalText()).append(" ").append(this.getterName()).append("(){\nreturn ").append(fieldName).append(";\n}\n");
        }
        if (this.hasEnumConstants() || this.needConstructor() || this.requiresBackPointer) {
            this.outputConstructor(out);
        }
        this.outputMethods(out);
        this.outputInnerClasses(out);
        out.append("}");
        return out.toString();
    }

    private String getterName() {
        return GenerateMembersUtil.suggestGetterName("value", this.myEnumParameterType, this.myProject);
    }

    private boolean hasEnumConstants() {
        return !this.enumConstantFields.isEmpty();
    }

    private String getValueFieldName() {
        String myValue = this.myJavaCodeStyleManager.variableNameToPropertyName("value", VariableKind.FIELD);
        return this.myJavaCodeStyleManager.suggestUniqueVariableName(myValue, (PsiElement)this.enumConstantFields.get(0), true);
    }

    private void calculateBackpointerName() {
        String baseName;
        if (this.originalClassName.indexOf(46) == 0) {
            baseName = StringUtil.decapitalize((String)this.originalClassName);
        } else {
            String simpleClassName = this.originalClassName.substring(this.originalClassName.lastIndexOf(46) + 1);
            baseName = StringUtil.decapitalize((String)simpleClassName);
        }
        String name2 = this.myJavaCodeStyleManager.propertyNameToVariableName(baseName, VariableKind.FIELD);
        if (!this.existsFieldWithName(name2)) {
            this.backPointerName = name2;
            return;
        }
        int counter = 1;
        while (true) {
            if (!this.existsFieldWithName(name2 = name2 + counter)) {
                this.backPointerName = name2;
                return;
            }
            ++counter;
        }
    }

    private boolean existsFieldWithName(String name2) {
        for (PsiField field : this.fields) {
            String fieldName = field.getName();
            if (!name2.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean needConstructor() {
        for (PsiField field : this.fields) {
            if (field.hasModifierProperty("static")) continue;
            return true;
        }
        for (PsiMethod method : this.methods) {
            if (method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private void outputMethods(StringBuffer out) {
        for (PsiMethod method : this.methods) {
            method.accept((PsiElementVisitor)new Mutator(out));
        }
    }

    private void outputInnerClasses(StringBuffer out) {
        for (PsiClass innerClass : this.innerClasses) {
            this.outputMutatedInnerClass(out, innerClass, this.innerClassesToMakePublic.contains(innerClass));
        }
    }

    private void outputMutatedInnerClass(StringBuffer out, PsiClass innerClass, boolean makePublic) {
        if (makePublic) {
            try {
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"public", (boolean)false);
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
            }
        }
        innerClass.accept((PsiElementVisitor)new Mutator(out));
    }

    private void outputFieldsAndInitializers(StringBuffer out, boolean normalizeDeclaration) {
        if (this.hasEnumConstants()) {
            out.append(StringUtil.join(this.enumConstantFields, field -> {
                StringBuffer fieldStr = new StringBuffer(field.getName() + "(");
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    initializer.accept((PsiElementVisitor)new Mutator(fieldStr));
                }
                fieldStr.append(")");
                return fieldStr.toString();
            }, (String)", "));
            out.append(";");
        }
        ArrayList<PsiClassInitializer> remainingInitializers = new ArrayList<PsiClassInitializer>(this.initializers);
        for (PsiField field2 : this.fields) {
            if (normalizeDeclaration) {
                field2.normalizeDeclaration();
            }
            Iterator initializersIterator = remainingInitializers.iterator();
            int fieldOffset = field2.getTextRange().getStartOffset();
            while (initializersIterator.hasNext()) {
                PsiClassInitializer initializer = (PsiClassInitializer)initializersIterator.next();
                if (initializer.getTextRange().getStartOffset() >= fieldOffset) continue;
                initializer.accept((PsiElementVisitor)new Mutator(out));
                initializersIterator.remove();
            }
            field2.accept((PsiElementVisitor)new Mutator(out));
            if (this.myFieldsNeedingGetter != null && this.myFieldsNeedingGetter.contains(field2)) {
                out.append(GenerateMembersUtil.generateGetterPrototype(field2).getText());
                out.append("\n");
            }
            if (this.myFieldsNeedingSetters == null || !this.myFieldsNeedingSetters.contains(field2)) continue;
            out.append(GenerateMembersUtil.generateSetterPrototype(field2).getText());
            out.append("\n");
        }
        for (PsiClassInitializer initializer : remainingInitializers) {
            initializer.accept((PsiElementVisitor)new Mutator(out));
        }
    }

    private void outputConstructor(@NonNls StringBuffer out) {
        String parameterName;
        out.append("\t").append(this.hasEnumConstants() ? "" : "public ").append(this.className).append('(');
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            out.append(this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                boolean first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ' + parameterName);
        } else if (this.hasEnumConstants()) {
            out.append(this.myEnumParameterType.getCanonicalText()).append(" ").append("value");
        }
        out.append(")");
        out.append("\t{");
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            if (this.backPointerName.equals(parameterName)) {
                out.append("\t\tthis." + this.backPointerName + " = " + parameterName + ";");
            } else {
                out.append("\t\t" + this.backPointerName + " = " + parameterName + ";");
            }
        } else if (this.hasEnumConstants()) {
            String fieldName = this.getValueFieldName();
            out.append(fieldName.equals("value") ? "this." : "").append(fieldName).append(" = value;");
        }
        out.append("\t}");
    }

    public void setRequiresBackPointer(boolean requiresBackPointer) {
        this.requiresBackPointer = requiresBackPointer;
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
    }

    public void setFieldsNeedingGetters(Set<PsiField> fieldsNeedingGetter) {
        this.myFieldsNeedingGetter = fieldsNeedingGetter;
    }

    public void setFieldsNeedingSetters(Set<PsiField> fieldsNeedingSetters) {
        this.myFieldsNeedingSetters = fieldsNeedingSetters;
    }

    private boolean fieldIsExtracted(PsiField field) {
        ArrayList<PsiField> extractedFields = new ArrayList<PsiField>(this.fields);
        extractedFields.addAll(this.enumConstantFields);
        if (extractedFields.contains(field)) {
            return true;
        }
        PsiClass containingClass = field.getContainingClass();
        return this.innerClasses.contains(containingClass);
    }

    public void setExtractAsEnum(List<? extends PsiField> extractAsEnum) {
        this.enumConstantFields = extractAsEnum;
        if (this.hasEnumConstants()) {
            this.myEnumParameterType = this.enumConstantFields.get(0).getType();
        }
    }

    private class Mutator
    extends JavaElementVisitor {
        @NonNls
        private final StringBuffer out;

        private Mutator(StringBuffer out) {
            this.out = out;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                Mutator.$$$reportNull$$$0(0);
            }
            super.visitElement(element);
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                String text2 = element.getText();
                this.out.append(text2);
            } else {
                for (PsiElement child : children) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            JavaResolveResult resolveResult = expression2.advancedResolve(true);
            boolean staticImported = resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement;
            PsiElement qualifier = expression2.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiElement referent = resolveResult.getElement();
                if (referent instanceof PsiField) {
                    PsiField field = (PsiField)referent;
                    if (ExtractedClassBuilder.this.fieldIsExtracted(field)) {
                        String name2 = field.getName();
                        if (ExtractedClassBuilder.this.enumConstantFields.contains(field)) {
                            this.out.append(name2).append(".").append(ExtractedClassBuilder.this.getterName()).append("()");
                        } else {
                            if (qualifier != null && name2.equals(expression2.getReferenceName())) {
                                this.out.append("this.");
                            }
                            this.out.append(name2);
                        }
                    } else if (field.hasModifierProperty("static")) {
                        if (field instanceof PsiEnumConstant) {
                            this.out.append(field.getName());
                        } else if (staticImported) {
                            PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)resolveResult.getCurrentFileResolveScope();
                            PsiClass targetClass = importStaticStatement.resolveTargetClass();
                            this.out.append(targetClass != null ? targetClass.getQualifiedName() : "").append(".").append(field.getName());
                        } else {
                            this.out.append(ExtractedClassBuilder.this.originalClassName + '.' + field.getName());
                        }
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + GenerateMembersUtil.suggestGetterName(field) + "()");
                    }
                } else if (referent instanceof PsiClass) {
                    String qualifiedName = ((PsiClass)referent).getQualifiedName();
                    if (qualifiedName != null) {
                        this.out.append(qualifiedName);
                    }
                } else {
                    this.visitElement((PsiElement)expression2);
                }
            } else {
                this.visitElement((PsiElement)expression2);
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            PsiExpression lhs = expression2.getLExpression();
            PsiExpression rhs = expression2.getRExpression();
            if (this.isBackpointerReference(lhs) && rhs != null) {
                while (lhs instanceof PsiParenthesizedExpression) {
                    lhs = ((PsiParenthesizedExpression)lhs).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
                assert (reference != null);
                PsiField field = (PsiField)reference.resolve();
                PsiJavaToken sign = expression2.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.delegate(rhs, field, sign, tokenType, ExtractedClassBuilder.this.backPointerName);
                } else {
                    this.visitElement((PsiElement)expression2);
                }
            } else {
                this.visitElement((PsiElement)expression2);
            }
        }

        private void delegate(PsiExpression rhs, PsiField field, PsiJavaToken sign, IElementType tokenType, String fieldName) {
            if (tokenType.equals(JavaTokenType.EQ)) {
                String setterName = GenerateMembersUtil.suggestSetterName(field);
                this.out.append(fieldName + '.' + setterName + '(');
                rhs.accept((PsiElementVisitor)this);
                this.out.append(')');
            } else {
                String operator2 = sign.getText().substring(0, sign.getTextLength() - 1);
                String setterName = GenerateMembersUtil.suggestSetterName(field);
                this.out.append(fieldName + '.' + setterName + '(');
                String getterName = GenerateMembersUtil.suggestGetterName(field);
                this.out.append(fieldName + '.' + getterName + "()");
                this.out.append(operator2);
                rhs.accept((PsiElementVisitor)this);
                this.out.append(')');
            }
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            PsiExpression operand2 = expression2.getOperand();
            IElementType tokenType = expression2.getOperationSign().getTokenType();
            if (this.isBackpointerReference(operand2) && (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS))) {
                while (operand2 instanceof PsiParenthesizedExpression) {
                    operand2 = ((PsiParenthesizedExpression)operand2).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)operand2;
                String operator2 = tokenType.equals(JavaTokenType.PLUSPLUS) ? "+" : "-";
                PsiField field = (PsiField)reference.resolve();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + GenerateMembersUtil.suggestSetterName(field) + '(' + ExtractedClassBuilder.this.backPointerName + '.' + GenerateMembersUtil.suggestGetterName(field) + "()" + operator2 + "1)");
                } else {
                    this.visitElement((PsiElement)expression2);
                }
            } else {
                this.visitElement((PsiElement)expression2);
            }
        }

        private boolean isBackpointerReference(PsiExpression expression2) {
            return BackpointerUtil.isBackpointerReference(expression2, (Condition<? super PsiField>)((Condition)psiField -> !ExtractedClassBuilder.this.fieldIsExtracted(psiField)));
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            this.out.append(ExtractedClassBuilder.this.backPointerName);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiReferenceExpression expression2 = call.getMethodExpression();
            JavaResolveResult resolveResult = expression2.advancedResolve(false);
            PsiElement qualifier = expression2.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiMethod method = call.resolveMethod();
                if (method != null && !this.isCompletelyMoved(method)) {
                    String methodName = method.getName();
                    if (method.hasModifierProperty("static")) {
                        PsiElement resolveScope = resolveResult.getCurrentFileResolveScope();
                        if (resolveScope instanceof PsiImportStaticStatement) {
                            PsiClass targetClass = ((PsiImportStaticStatement)resolveScope).resolveTargetClass();
                            this.out.append(targetClass != null ? targetClass.getQualifiedName() : "").append('.').append(methodName);
                        } else {
                            this.out.append(ExtractedClassBuilder.this.originalClassName + '.' + methodName);
                        }
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName + '.' + methodName);
                    }
                    PsiExpressionList argumentList = call.getArgumentList();
                    argumentList.accept((PsiElementVisitor)this);
                } else {
                    this.visitElement((PsiElement)call);
                }
            } else {
                this.visitElement((PsiElement)call);
            }
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String referenceText = reference.getCanonicalText();
            this.out.append(referenceText);
        }

        private boolean isCompletelyMoved(PsiMethod method) {
            return ExtractedClassBuilder.this.methods.contains(method) && !MethodInheritanceUtils.hasSiblingMethods(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/extractclass/ExtractedClassBuilder$Mutator", "visitElement"));
        }
    }
}

