/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.extractclass.BackpointerUsageVisitor;
import com.intellij.refactoring.extractclass.ExtractClassProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractClassDialog
extends RefactoringDialog
implements MemberInfoChangeListener<PsiMember, MemberInfo> {
    private final Map<MemberInfoBase<PsiMember>, PsiMember> myMember2CauseMap = new HashMap<MemberInfoBase<PsiMember>, PsiMember>();
    private final PsiClass sourceClass;
    private final List<MemberInfo> memberInfo;
    private final JTextField classNameField;
    private final ReferenceEditorComboWithBrowseButton packageTextField;
    private final DestinationFolderComboBox myDestinationFolderComboBox;
    private JCheckBox myGenerateAccessorsCb;
    private final JavaVisibilityPanel myVisibilityPanel;
    private final JCheckBox extractAsEnum;
    private final JCheckBox createInner;
    private final List<MemberInfo> enumConstants = new ArrayList<MemberInfo>();

    ExtractClassDialog(PsiClass sourceClass, PsiMember selectedMember) {
        super(sourceClass.getProject(), true);
        this.setModal(true);
        this.setTitle(RefactorJBundle.message("extract.class.title", new Object[0]));
        this.myVisibilityPanel = new JavaVisibilityPanel(true, true);
        this.myVisibilityPanel.setVisibility(null);
        this.sourceClass = sourceClass;
        DocumentAdapter docListener = new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExtractClassDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/extractclass/ExtractClassDialog$1", "textChanged"));
            }
        };
        this.classNameField = new JTextField();
        PsiFile file = sourceClass.getContainingFile();
        String text2 = file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "";
        this.packageTextField = new PackageNameReferenceEditorCombo(text2, this.myProject, "ExtractClass.RECENTS_KEY", RefactorJBundle.message("choose.destination.package.label", new Object[0]));
        ((EditorComboBox)this.packageTextField.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ExtractClassDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/extractclass/ExtractClassDialog$2", "documentChanged"));
            }
        });
        this.myDestinationFolderComboBox = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return ExtractClassDialog.this.getPackageName();
            }
        };
        this.myDestinationFolderComboBox.setData(this.myProject, sourceClass.getContainingFile().getContainingDirectory(), (EditorComboBox)this.packageTextField.getChildComponent());
        this.classNameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)docListener);
        MemberInfoBase.Filter<PsiMember> filter = new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                if (element instanceof PsiMethod) {
                    return !((PsiMethod)element).isConstructor() && ((PsiMethod)element).getBody() != null;
                }
                if (element instanceof PsiField) {
                    return true;
                }
                if (element instanceof PsiClass) {
                    return PsiTreeUtil.isAncestor((PsiElement)ExtractClassDialog.this.sourceClass, (PsiElement)element, (boolean)true);
                }
                return false;
            }
        };
        this.memberInfo = MemberInfo.extractClassMembers(this.sourceClass, filter, false);
        this.extractAsEnum = new JCheckBox(JavaRefactoringBundle.message((String)"extract.delegate.as.enum.checkbox", (Object[])new Object[0]));
        boolean hasConstants = false;
        for (MemberInfo info : this.memberInfo) {
            PsiMember member = (PsiMember)info.getMember();
            if (member.equals(selectedMember)) {
                info.setChecked(true);
            }
            if (hasConstants || !(member instanceof PsiField) || !member.hasModifierProperty("final") || !member.hasModifierProperty("static")) continue;
            hasConstants = true;
        }
        if (!hasConstants) {
            this.extractAsEnum.setVisible(false);
        }
        this.createInner = new JCheckBox(JavaRefactoringBundle.message((String)"extract.delegate.create.nested.checkbox", (Object[])new Object[0]));
        super.init();
        this.validateButtons();
    }

    protected void doAction() {
        List<PsiField> fields = this.getFieldsToExtract();
        List<PsiMethod> methods = this.getMethodsToExtract();
        List<PsiClass> classes2 = this.getClassesToExtract();
        String newClassName = this.getClassName();
        String packageName = this.getPackageName();
        Collections.sort(this.enumConstants, Comparator.comparingInt(o -> ((PsiMember)o.getMember()).getTextOffset()));
        ExtractClassProcessor processor = new ExtractClassProcessor(this.sourceClass, fields, methods, classes2, packageName, this.myDestinationFolderComboBox.selectDirectory(new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName), false), newClassName, this.myVisibilityPanel.getVisibility(), this.isGenerateAccessors(), this.isExtractAsEnum() ? this.enumConstants : Collections.emptyList(), this.createInner.isSelected());
        if (processor.getCreatedClass() == null) {
            Messages.showErrorDialog((Component)((Object)this.myVisibilityPanel), (String)JavaRefactoringBundle.message((String)"extract.delegate.unable.create.warning.message", (Object[])new Object[0]));
            this.classNameField.requestFocusInWindow();
            return;
        }
        this.invokeRefactoring((BaseRefactoringProcessor)processor);
    }

    protected void canRun() throws ConfigurationException {
        Project project = this.sourceClass.getProject();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        List<PsiMethod> methods = this.getMethodsToExtract();
        List<PsiField> fields = this.getFieldsToExtract();
        List<PsiClass> innerClasses = this.getClassesToExtract();
        if (methods.isEmpty() && fields.isEmpty() && innerClasses.isEmpty()) {
            throw new ConfigurationException("Nothing found to extract");
        }
        String className2 = this.getClassName();
        if (className2.length() == 0 || !nameHelper.isIdentifier(className2)) {
            throw new ConfigurationException("'" + className2 + "' is invalid extracted class name");
        }
        for (PsiClass innerClass : innerClasses) {
            if (!className2.equals(innerClass.getName())) continue;
            throw new ConfigurationException("Extracted class should have unique name. Name '" + className2 + "' is already in use by one of the inner classes");
        }
    }

    @NotNull
    public String getPackageName() {
        String string = this.packageTextField.getText().trim();
        if (string == null) {
            ExtractClassDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.classNameField.getText().trim();
        if (string == null) {
            ExtractClassDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    public List<PsiField> getFieldsToExtract() {
        return this.getMembersToExtract(true, PsiField.class);
    }

    public <T> List<T> getMembersToExtract(boolean checked, Class<T> memberClass) {
        ArrayList<PsiMember> out = new ArrayList<PsiMember>();
        for (MemberInfo info : this.memberInfo) {
            PsiMember member;
            if (checked && !info.isChecked() || !checked && info.isChecked() || !memberClass.isAssignableFrom((member = (PsiMember)info.getMember()).getClass())) continue;
            out.add(member);
        }
        return out;
    }

    public List<PsiMethod> getMethodsToExtract() {
        return this.getMembersToExtract(true, PsiMethod.class);
    }

    public List<PsiClass> getClassesToExtract() {
        return this.getMembersToExtract(true, PsiClass.class);
    }

    public List<PsiClassInitializer> getClassInitializersToExtract() {
        return this.getMembersToExtract(true, PsiClassInitializer.class);
    }

    public boolean isGenerateAccessors() {
        return this.myGenerateAccessorsCb.isSelected();
    }

    public boolean isExtractAsEnum() {
        return this.extractAsEnum.isVisible() && this.extractAsEnum.isEnabled() && this.extractAsEnum.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.ExtractClass";
    }

    protected JComponent createNorthPanel() {
        JPanel checkboxPanel = new JPanel(new BorderLayout());
        checkboxPanel.add((Component)this.createInner, "West");
        checkboxPanel.add((Component)this.extractAsEnum, "East");
        FormBuilder builder = FormBuilder.createFormBuilder().addComponent((JComponent)JBLabelDecorator.createJBLabelDecorator((String)RefactorJBundle.message("extract.class.from.label", this.sourceClass.getQualifiedName())).setBold(true)).addLabeledComponent(RefactorJBundle.message("name.for.new.class.label", new Object[0]), (JComponent)this.classNameField, 12).addLabeledComponent((JComponent)new JLabel(), (JComponent)checkboxPanel).addLabeledComponent(RefactorJBundle.message("package.for.new.class.label", new Object[0]), (JComponent)((Object)this.packageTextField));
        if (JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject).size() > 1) {
            builder.addLabeledComponent(RefactoringBundle.message((String)"target.destination.folder"), (JComponent)((Object)this.myDestinationFolderComboBox));
        }
        return builder.addVerticalGap(5).getPanel();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        final MemberSelectionTable table = new MemberSelectionTable(this.memberInfo, "As enum"){

            @Override
            @Nullable
            protected Object getAbstractColumnValue(MemberInfo memberInfo) {
                PsiMember member;
                if (ExtractClassDialog.this.isExtractAsEnum() && ExtractClassDialog.isConstantField(member = (PsiMember)memberInfo.getMember())) {
                    return ExtractClassDialog.this.enumConstants.contains((Object)memberInfo);
                }
                return null;
            }

            @Override
            protected boolean isAbstractColumnEditable(int rowIndex) {
                PsiMember member;
                MemberInfo info = (MemberInfo)((Object)ExtractClassDialog.this.memberInfo.get(rowIndex));
                if (info.isChecked() && ExtractClassDialog.isConstantField(member = (PsiMember)info.getMember())) {
                    if (ExtractClassDialog.this.enumConstants.isEmpty()) {
                        return true;
                    }
                    MemberInfo currentEnumConstant = (MemberInfo)((Object)ExtractClassDialog.this.enumConstants.get(0));
                    if (((PsiField)currentEnumConstant.getMember()).getType().equals(((PsiField)member).getType())) {
                        return true;
                    }
                }
                return false;
            }
        };
        table.setMemberInfoModel((MemberInfoModel)new DelegatingMemberInfoModel<PsiMember, MemberInfo>(table.getMemberInfoModel()){

            public int checkForProblems(@NotNull MemberInfo member) {
                if (member == null) {
                    6.$$$reportNull$$$0(0);
                }
                PsiMember cause = this.getCause(member);
                if (member.isChecked() && cause != null) {
                    return 2;
                }
                if (!member.isChecked() && cause != null) {
                    return 1;
                }
                return 0;
            }

            public String getTooltipText(MemberInfo member) {
                PsiMember cause = this.getCause(member);
                if (cause != null) {
                    String presentation = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)cause);
                    if (member.isChecked()) {
                        return "Depends on " + presentation + " from " + ExtractClassDialog.this.sourceClass.getName();
                    }
                    String className2 = ExtractClassDialog.this.getClassName();
                    return "Depends on " + presentation + " from new class" + (className2.length() > 0 ? ": " + className2 : "");
                }
                return null;
            }

            private PsiMember getCause(MemberInfo member) {
                PsiMember cause = (PsiMember)ExtractClassDialog.this.myMember2CauseMap.get((Object)member);
                if (cause != null) {
                    return cause;
                }
                BackpointerUsageVisitor visitor2 = member.isChecked() ? new BackpointerUsageVisitor(ExtractClassDialog.this.getFieldsToExtract(), ExtractClassDialog.this.getClassesToExtract(), ExtractClassDialog.this.getMethodsToExtract(), ExtractClassDialog.this.sourceClass) : new BackpointerUsageVisitor(ExtractClassDialog.this.getMembersToExtract(false, PsiField.class), ExtractClassDialog.this.getMembersToExtract(false, PsiClass.class), ExtractClassDialog.this.getMembersToExtract(false, PsiMethod.class), ExtractClassDialog.this.sourceClass, false);
                ((PsiMember)member.getMember()).accept((PsiElementVisitor)visitor2);
                cause = visitor2.getCause();
                ExtractClassDialog.this.myMember2CauseMap.put(member, cause);
                return cause;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/extractclass/ExtractClassDialog$6", "checkForProblems"));
            }
        });
        MemberSelectionPanelBase memberSelectionPanel = new MemberSelectionPanelBase(RefactorJBundle.message("members.to.extract.label", new Object[0]), (AbstractMemberSelectionTable)table);
        panel2.add((Component)memberSelectionPanel, "Center");
        table.addMemberInfoChangeListener(this);
        this.extractAsEnum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExtractClassDialog.this.extractAsEnum.isSelected()) {
                    ExtractClassDialog.this.preselectOneTypeEnumConstants();
                }
                table.repaint();
            }
        });
        this.createInner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isCreateInner = ExtractClassDialog.this.createInner.isSelected();
                ExtractClassDialog.this.packageTextField.setEnabled(!isCreateInner);
                ExtractClassDialog.this.myDestinationFolderComboBox.setEnabled(!isCreateInner);
            }
        });
        this.myGenerateAccessorsCb = new JCheckBox(JavaRefactoringBundle.message((String)"extract.delegate.generate.accessors.checkbox", (Object[])new Object[0]));
        this.myGenerateAccessorsCb.setMnemonic('G');
        panel2.add((Component)this.myGenerateAccessorsCb, "South");
        panel2.add((Component)((Object)this.myVisibilityPanel), "East");
        return panel2;
    }

    private void preselectOneTypeEnumConstants() {
        if (this.enumConstants.isEmpty()) {
            MemberInfo selected = null;
            for (MemberInfo info : this.memberInfo) {
                if (!info.isChecked()) continue;
                selected = info;
                break;
            }
            if (selected != null && ExtractClassDialog.isConstantField((PsiMember)selected.getMember())) {
                this.enumConstants.add(selected);
                selected.setToAbstract(true);
            }
        }
        for (MemberInfo info : this.memberInfo) {
            PsiMember member = (PsiMember)info.getMember();
            if (!ExtractClassDialog.isConstantField(member) || !this.enumConstants.isEmpty() && !((PsiField)this.enumConstants.get(0).getMember()).getType().equals(((PsiField)member).getType())) continue;
            if (!this.enumConstants.contains((Object)info)) {
                this.enumConstants.add(info);
            }
            info.setToAbstract(true);
        }
    }

    private static boolean isConstantField(PsiMember member) {
        return member instanceof PsiField && member.hasModifierProperty("static") && ((PsiField)member).hasInitializer();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected String getHelpId() {
        return "refactorj.extractClass";
    }

    public void memberInfoChanged(@NotNull MemberInfoChange memberInfoChange) {
        if (memberInfoChange == null) {
            ExtractClassDialog.$$$reportNull$$$0(2);
        }
        this.validateButtons();
        this.myMember2CauseMap.clear();
        if (this.extractAsEnum.isVisible()) {
            for (Object info : memberInfoChange.getChangedMembers()) {
                if (((MemberInfo)((Object)info)).isToAbstract()) {
                    if (this.enumConstants.contains(info)) continue;
                    this.enumConstants.add((MemberInfo)((Object)info));
                    continue;
                }
                this.enumConstants.remove((Object)((MemberInfo)((Object)info)));
            }
            this.extractAsEnum.setEnabled(this.canExtractEnum());
        }
    }

    private boolean canExtractEnum() {
        ArrayList<PsiField> fields = new ArrayList<PsiField>();
        ArrayList<PsiClass> innerClasses = new ArrayList<PsiClass>();
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        for (MemberInfo info : this.memberInfo) {
            if (!info.isChecked()) continue;
            PsiMember member = (PsiMember)info.getMember();
            if (member instanceof PsiField) {
                fields.add((PsiField)member);
                continue;
            }
            if (member instanceof PsiMethod) {
                methods.add((PsiMethod)member);
                continue;
            }
            if (!(member instanceof PsiClass)) continue;
            innerClasses.add((PsiClass)member);
        }
        return !new BackpointerUsageVisitor(fields, innerClasses, methods, this.sourceClass).backpointerRequired();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractclass/ExtractClassDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractclass/ExtractClassDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "memberInfoChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

