/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MemberQualifierUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThisReferenceDescriptor
implements ItemToReplaceDescriptor {
    private final PsiThisExpression myThisExpression;
    private final PsiClass myPsiClass;

    public ThisReferenceDescriptor(PsiThisExpression expression2, PsiClass aClass) {
        this.myThisExpression = expression2;
        this.myPsiClass = aClass;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiThisExpression thisExpression) {
        PsiType expressionType;
        if (thisExpression == null) {
            ThisReferenceDescriptor.$$$reportNull$$$0(0);
        }
        if ((expressionType = thisExpression.getType()) != null && !PsiReflectionAccessUtil.isAccessibleType(expressionType)) {
            return new ThisReferenceDescriptor(thisExpression, PsiTypesUtil.getPsiClass((PsiType)expressionType));
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        if (outerClass == null) {
            ThisReferenceDescriptor.$$$reportNull$$$0(1);
        }
        if (elementFactory == null) {
            ThisReferenceDescriptor.$$$reportNull$$$0(2);
        }
        if (callExpression == null) {
            ThisReferenceDescriptor.$$$reportNull$$$0(3);
        }
        String newExpression = MemberQualifierUtil.handleThisReference((PsiElement)this.myThisExpression, this.myPsiClass, outerClass, callExpression, elementFactory);
        this.myThisExpression.replace((PsiElement)elementFactory.createExpressionFromText(newExpression, (PsiElement)this.myThisExpression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ThisReferenceDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfInaccessible";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

