/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ExtractGeneratedClassUtil {
    private static final String GENERATED_CLASS_PACKAGE = "idea.debugger.rt";
    private static final Logger LOG = Logger.getInstance(ExtractGeneratedClassUtil.class);

    ExtractGeneratedClassUtil() {
    }

    static PsiClass extractGeneratedClass(@NotNull PsiClass generatedInnerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiElement anchor) {
        if (generatedInnerClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(2);
        }
        Project project = generatedInnerClass.getProject();
        PsiClass extractedClass = elementFactory.createClass("GeneratedEvaluationClass");
        for (PsiField psiField : generatedInnerClass.getAllFields()) {
            extractedClass.add((PsiElement)elementFactory.createFieldFromText(psiField.getText(), anchor));
        }
        for (PsiField psiField : generatedInnerClass.getMethods()) {
            extractedClass.add((PsiElement)elementFactory.createMethodFromText(psiField.getText(), anchor));
        }
        PsiJavaFile generatedFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(extractedClass.getName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)extractedClass.getContainingFile().getText());
        generatedFile.setPackageName(GENERATED_CLASS_PACKAGE);
        extractedClass = (PsiClass)PsiTreeUtil.findChildOfType((PsiElement)generatedFile, PsiClass.class);
        assert (extractedClass != null);
        PsiElement codeBlock = PsiTreeUtil.findFirstParent((PsiElement)anchor, (boolean)false, element -> element instanceof PsiCodeBlock);
        if (codeBlock == null) {
            codeBlock = anchor.getParent();
        }
        ExtractGeneratedClassUtil.addGeneratedClassInfo(codeBlock, generatedInnerClass, extractedClass);
        return extractedClass;
    }

    private static void addGeneratedClassInfo(@NotNull PsiElement element, final @NotNull PsiClass generatedClass, final @NotNull PsiClass extractedClass) {
        if (element == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(3);
        }
        if (generatedClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(4);
        }
        if (extractedClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(5);
        }
        generatedClass.putUserData(ExtractLightMethodObjectHandler.REFERENCED_TYPE, (Object)PsiTypesUtil.getClassType((PsiClass)extractedClass));
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                List methods;
                super.visitNewExpression(expression2);
                PsiMethod constructor = expression2.resolveConstructor();
                if (constructor != null && generatedClass.equals(constructor.getContainingClass()) && (methods = Arrays.stream(extractedClass.getConstructors()).filter(x -> this.isSameMethod((PsiMethod)x, constructor)).collect(Collectors.toList())).size() == 1) {
                    LOG.info("Replace constructor: " + constructor.getName());
                    constructor.putUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD, methods.get(0));
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                List methods;
                super.visitMethodCallExpression(expression2);
                PsiMethod method = expression2.resolveMethod();
                if (method != null && generatedClass.equals(method.getContainingClass()) && (methods = Arrays.stream(extractedClass.getMethods()).filter(x -> this.isSameMethod((PsiMethod)x, method)).collect(Collectors.toList())).size() == 1) {
                    LOG.info("Replace method: " + method.getName());
                    method.putUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD, methods.get(0));
                }
            }

            private boolean isSameMethod(@NotNull PsiMethod first, @NotNull PsiMethod second) {
                if (first == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (first.getName().equals(second.getName())) {
                    return first.getParameterList().getParametersCount() == second.getParameterList().getParametersCount();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "first";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "second";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/extractMethodObject/ExtractGeneratedClassUtil$1";
                objectArray[2] = "isSameMethod";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedInnerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractGeneratedClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractGeneratedClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addGeneratedClassInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

