/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.structures;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import java.util.List;

public class StatementGroup {
    public final IElementType type;
    public final List<PsiStatement> statements;

    private StatementGroup(IElementType type2, List<PsiStatement> statements) {
        this.type = type2;
        this.statements = statements;
    }

    public static StatementGroup of(List<PsiStatement> statements) {
        IElementType type2 = StatementGroup.findTypeAndCheck(statements);
        return new StatementGroup(type2, statements);
    }

    private static IElementType findTypeAndCheck(List<PsiStatement> statements) {
        if (statements.isEmpty()) {
            throw new IllegalArgumentException("Statement group is empty");
        }
        IElementType type2 = statements.get(0).getNode().getElementType();
        boolean areOfSameType = statements.stream().map(statement -> statement.getNode().getElementType()).allMatch(currentType -> currentType == type2);
        if (!areOfSameType) {
            throw new IllegalArgumentException("Some statements are of different type");
        }
        return type2;
    }

    public boolean areEffectivelySame() {
        PsiStatement firstStatement = this.statements.get(0);
        return this.statements.stream().allMatch(statement -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)firstStatement, (PsiElement)statement));
    }
}

