/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.structures;

import com.intellij.psi.PsiElement;

public class PsiSubstitutionFactory {
    public static Runnable createAddAfter(PsiElement anchor, PsiElement element) {
        return new AddSubstitution(Place.After, anchor, element);
    }

    public static Runnable createAddBefore(PsiElement anchor, PsiElement element) {
        return new AddSubstitution(Place.Before, anchor, element);
    }

    public static Runnable createReplace(PsiElement source, PsiElement target) {
        return new ReplaceSubstitution(source, target);
    }

    private static enum Place {
        Before,
        After;

    }

    private static class ReplaceSubstitution
    implements Runnable {
        public final PsiElement source;
        public final PsiElement target;

        private ReplaceSubstitution(PsiElement source, PsiElement target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void run() {
            this.source.replace(this.target);
        }
    }

    private static class AddSubstitution
    implements Runnable {
        public final Place place;
        public final PsiElement anchor;
        public final PsiElement element;

        private AddSubstitution(Place place, PsiElement anchor, PsiElement element) {
            this.place = place;
            this.anchor = anchor;
            this.element = element;
        }

        @Override
        public void run() {
            switch (this.place) {
                case Before: {
                    this.anchor.getParent().addBefore(this.element, this.anchor);
                    break;
                }
                case After: {
                    this.anchor.getParent().addAfter(this.element, this.anchor);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

