/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;

public class SignatureBuilder {
    private final PsiElementFactory factory;
    @PsiModifier.ModifierConstant
    private String visibility = "private";
    private boolean isStatic = false;
    private PsiType returnType = PsiType.VOID;
    private String methodName = "extracted";
    private List<String> parameterNames = Collections.emptyList();
    private List<PsiType> parameterTypes = Collections.emptyList();
    private List<PsiClassType> thrownExceptions = Collections.emptyList();

    public SignatureBuilder(Project project) {
        this.factory = PsiElementFactory.getInstance((Project)project);
    }

    public SignatureBuilder visibility(@PsiModifier.ModifierConstant String visibility) {
        this.visibility = visibility;
        return this;
    }

    public SignatureBuilder makeStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public SignatureBuilder throwExceptions(List<PsiClassType> exceptions) {
        this.thrownExceptions = exceptions;
        return this;
    }

    public SignatureBuilder methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public SignatureBuilder parameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
        return this;
    }

    public SignatureBuilder parameterTypes(List<PsiType> parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    public SignatureBuilder returnType(PsiType returnType) {
        this.returnType = returnType;
        return this;
    }

    public List<String> parameterNames() {
        return this.parameterNames;
    }

    public List<PsiType> parameterTypes() {
        return this.parameterTypes;
    }

    public PsiMethod build() {
        if (this.parameterNames.size() != this.parameterTypes.size()) {
            throw new IllegalStateException("Different number of parameter names and types");
        }
        String[] names2 = ArrayUtil.toStringArray(this.parameterNames);
        PsiType[] types = this.parameterTypes.toArray(PsiType.EMPTY_ARRAY);
        PsiParameterList parameterList = this.factory.createParameterList(names2, types);
        PsiMethod method = this.factory.createMethod(this.methodName, this.returnType);
        method.getParameterList().replace((PsiElement)parameterList);
        method.getModifierList().setModifierProperty("static", this.isStatic);
        method.getModifierList().setModifierProperty(this.visibility, true);
        this.thrownExceptions.forEach(exception -> method.getThrowsList().add((PsiElement)this.factory.createReferenceElementByType(exception)));
        return method;
    }
}

