/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallBuilder {
    private final PsiElementFactory factory;
    private String methodName;
    private List<String> parameters;
    @Nullable
    private String variableToAssign;
    @Nullable
    private PsiType variableType;
    private Computable<String> callStatementProducer;

    public CallBuilder(@NotNull Project project) {
        if (project == null) {
            CallBuilder.$$$reportNull$$$0(0);
        }
        this.methodName = "extracted";
        this.parameters = Collections.emptyList();
        this.variableToAssign = null;
        this.variableType = null;
        this.callStatementProducer = () -> null;
        this.factory = PsiElementFactory.getInstance((Project)project);
    }

    public CallBuilder methodName(@NotNull String name2) {
        if (name2 == null) {
            CallBuilder.$$$reportNull$$$0(1);
        }
        this.methodName = name2;
        return this;
    }

    public CallBuilder parameters(@NotNull List<String> parameters2) {
        if (parameters2 == null) {
            CallBuilder.$$$reportNull$$$0(2);
        }
        this.parameters = parameters2;
        return this;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public CallBuilder assignToVariable(@NotNull String name2) {
        if (name2 == null) {
            CallBuilder.$$$reportNull$$$0(3);
        }
        this.variableToAssign = name2;
        this.variableType = null;
        return this;
    }

    public CallBuilder declareVariable(PsiType type2, String name2) {
        this.variableType = type2;
        this.variableToAssign = name2;
        return this;
    }

    public CallBuilder guardMethodCall(@NotNull String exitStatement) {
        if (exitStatement == null) {
            CallBuilder.$$$reportNull$$$0(4);
        }
        this.callStatementProducer = () -> "if (" + this.getCallExpression() + ")" + exitStatement;
        return this;
    }

    public CallBuilder returnNotNullVariable() {
        this.callStatementProducer = () -> "if (" + this.variableToAssign + " != null) return " + this.variableToAssign + ";";
        return this;
    }

    public CallBuilder guardNullVariable(String exitStatement) {
        this.callStatementProducer = () -> "if (" + this.variableToAssign + " == null) " + exitStatement;
        return this;
    }

    public CallBuilder returnMethodCall() {
        this.callStatementProducer = () -> "return " + this.getCallExpression() + ";";
        return this;
    }

    public CallBuilder methodCall() {
        this.callStatementProducer = () -> this.getCallExpression() + ";";
        return this;
    }

    private String getVariableDeclaration(String variableName, PsiType type2) {
        if (variableName == null) {
            return null;
        }
        String callExpression = this.getCallExpression();
        if (type2 != null) {
            PsiExpression initializer = this.factory.createExpressionFromText(callExpression, null);
            return this.factory.createVariableDeclarationStatement(variableName, type2, initializer).getText();
        }
        return this.variableToAssign + " = " + callExpression + ";";
    }

    private String getCallExpression() {
        return this.methodName + "(" + StringUtil.join(this.parameters, (String)",") + ")";
    }

    private List<PsiStatement> parseStatementsFromText(String ... statements) {
        PsiCodeBlock container = this.factory.createCodeBlock();
        for (String statement : statements) {
            if (statement == null) continue;
            container.add((PsiElement)this.factory.createStatementFromText(statement, null));
        }
        return Arrays.asList(container.getStatements());
    }

    private String getCallStatement(Computable<String> callStatementProducer) {
        if (this.variableToAssign == null && callStatementProducer == null) {
            return this.getCallExpression() + ";";
        }
        return callStatementProducer != null ? (String)callStatementProducer.compute() : null;
    }

    public List<PsiStatement> build() {
        return this.parseStatementsFromText(this.getVariableDeclaration(this.variableToAssign, this.variableType), this.getCallStatement(this.callStatementProducer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/newImpl/CallBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "methodName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assignToVariable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "guardMethodCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

