/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiRecordUtil {
    @Nullable
    public static PsiRecordComponent getRecordComponentForAccessor(@NotNull PsiMethod accessor) {
        PsiClass aClass;
        if (accessor == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(0);
        }
        if ((aClass = accessor.getContainingClass()) == null || !aClass.isRecord()) {
            return null;
        }
        if (!accessor.getParameterList().isEmpty()) {
            return null;
        }
        String name2 = accessor.getName();
        for (PsiRecordComponent c : aClass.getRecordComponents()) {
            if (!name2.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static PsiField getFieldForComponent(@NotNull PsiRecordComponent component) {
        PsiClass aClass;
        if (component == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(1);
        }
        if ((aClass = component.getContainingClass()) == null) {
            return null;
        }
        String name2 = component.getName();
        for (PsiField field : aClass.getFields()) {
            if (!field.getName().equals(name2) || field.hasModifierProperty("static")) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiRecordComponent getComponentForField(@NotNull PsiField field) {
        if (field == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(2);
        }
        return field instanceof LightRecordField ? ((LightRecordField)field).getRecordComponent() : null;
    }

    public static boolean isCompactConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(3);
        }
        return method.isConstructor() && method.getParameterList().getText() == null;
    }

    public static boolean isExplicitCanonicalConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(4);
        }
        if (!method.isConstructor() || JavaPsiRecordUtil.isCompactConstructor(method)) {
            return false;
        }
        if (method instanceof SyntheticElement) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isRecord()) {
            return false;
        }
        return JavaPsiRecordUtil.hasCanonicalSignature(method, aClass.getRecordComponents());
    }

    private static boolean hasCanonicalSignature(@NotNull PsiMethod method, PsiRecordComponent[] components) {
        PsiParameter[] parameters2;
        if (method == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(5);
        }
        if (components.length != (parameters2 = method.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiType componentType = components[i].getType();
            PsiType parameterType = parameters2[i].getType();
            if (componentType instanceof PsiEllipsisType) {
                componentType = ((PsiEllipsisType)componentType).toArrayType();
            }
            if (parameterType instanceof PsiEllipsisType) {
                parameterType = ((PsiEllipsisType)parameterType).toArrayType();
            }
            if (TypeConversionUtil.erasure((PsiType)componentType).equals(TypeConversionUtil.erasure((PsiType)parameterType))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiMethod findCanonicalConstructor(@NotNull PsiClass recordClass) {
        if (recordClass == null) {
            JavaPsiRecordUtil.$$$reportNull$$$0(6);
        }
        if (!recordClass.isRecord()) {
            return null;
        }
        PsiMethod[] constructors = recordClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiRecordComponent[] components = recordClass.getRecordComponents();
        for (PsiMethod constructor : constructors) {
            if (!JavaPsiRecordUtil.isCompactConstructor(constructor) && !JavaPsiRecordUtil.hasCanonicalSignature(constructor, components)) continue;
            return constructor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/JavaPsiRecordUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRecordComponentForAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldForComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentForField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompactConstructor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExplicitCanonicalConstructor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCanonicalSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findCanonicalConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

